/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostAccountService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostAccountsPanel
extends ForpostBasePanel<ForpostAccountService> {
    private BGTextField accountName = new BGTextField(20);

    @Override
    protected JPanel getFilterPanel() {
        this.accountName.setHorizontalAlignment(0);
        int gridx = 1;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.accountName, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        JButton syncButton = this.getGetSyncButton();
        if (syncButton != null) {
            panel.add((Component)syncButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    @Override
    protected void initListeners() {
        try {
            super.initListeners();
            super.initPopupListener();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    @Override
    protected int getSelectedContractId() {
        try {
            ForpostAccount forpostAccount = (ForpostAccount)this.getTableModel().getSelectedRow();
            if (forpostAccount != null) {
                return forpostAccount.getContractId();
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return super.getSelectedContractId();
    }

    @Override
    protected void doRefresh() throws BGException {
        SearchResult searchResult = this.getService(ForpostAccountService.class).searchForpostAccounts(this.getContractId(), this.accountName.getText(), this.table.getSort(), this.pagePanel.getPage());
        ((AccountTableModel)this.getTableModel()).setData(searchResult.getList());
        Page page = searchResult.getPage();
        this.records.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)page.getRecordCount()));
        this.pagePanel.setPage(page);
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getOpenContractMenuItem());
        }
        return this.popupMenu;
    }

    @Override
    protected BGTableModel<?> getTableModel() throws BGException {
        if (this.tableModel == null) {
            this.tableModel = new AccountTableModel(AccountTableModel.class.getName());
        }
        return this.tableModel;
    }

    @Override
    protected void doSync() throws Exception {
        this.getService(ForpostAccountService.class).doSync();
        this.doRefresh();
    }

    class AccountTableModel
    extends BGTableModel<ForpostAccount> {
        public AccountTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 200, -1, "contractTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 100, 200, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u0430\u043c\u0435\u0440\u044b", 100, 100, 100, "maxCameraCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438", 100, 100, 100, "maxLoginCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u0440\u043e\u0441\u043c. \u043e\u043d-\u043b\u0430\u0439\u043d \u043a\u0430\u043c\u0435\u0440\u044b", 170, 170, 170, "cameraOnline", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041f\u0440\u043e\u0441\u043c. \u0430\u0440\u0445\u0438\u0432 \u043a\u0430\u043c\u0435\u0440\u044b", 170, 170, 170, "cameraArchival", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u0414\u043b\u0438\u0442. \u0430\u0440\u0445\u0438\u0432\u0430 (\u0441\u0435\u043a.)", 150, 150, 150, "quota", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u0435\u043d", Boolean.class, 70, 70, 70, "isActive", true);
        }

        public Object getValueAt(ForpostAccount forpostAccount, int column) throws Exception {
            Map map = Utils.linesToPairsHash((String)forpostAccount.getData());
            String identifier = this.getIdentifier(column);
            if ("isActive".equals(identifier)) {
                return forpostAccount.getIsActive() > 0;
            }
            if ("cameraOnline".equals(identifier)) {
                return (String)map.get("MaxCameraUserOnlineTranslationCount") + " / " + (String)map.get("MaxCameraOnlineTranslationCount");
            }
            if ("cameraArchival".equals(identifier)) {
                return (String)map.get("MaxCameraUserArchivalTranslationCount") + " / " + (String)map.get("MaxCameraArchivalTranslationCount");
            }
            if ("quota".equals(identifier)) {
                return Utils.formatInteger((int)Utils.parseInt((String)((String)map.get("Quota"))));
            }
            return super.getValueAt((Object)forpostAccount, column);
        }
    }
}

