/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public abstract class ForpostBasePanel<T>
extends BGUPanel {
    protected BGUTable table = null;
    protected BGTableModel<?> tableModel = null;
    protected JLabel records = new JLabel();
    protected JPopupMenu popupMenu = null;
    protected ForpostService forpostService = null;
    protected BGControlPanelPages pagePanel = new BGControlPanelPages();
    private T service = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.getTable()), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.initListeners();
    }

    protected JPanel getTopPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.records, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    protected JPanel getFilterPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.WHITE);
        panel.setOpaque(false);
        JButton syncButton = this.getGetSyncButton();
        if (syncButton != null) {
            panel.add((Component)syncButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    protected JButton getGetSyncButton() {
        return new JButton(this.getSyncAction());
    }

    protected AbstractAction getSyncAction() {
        return new SyncAction();
    }

    protected T getService(Class<T> clazz) {
        if (this.service == null) {
            this.service = ((ClientContext)this.getContext()).getPort(clazz);
        }
        return this.service;
    }

    protected void initPopupListener() throws BGException {
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    if (ForpostBasePanel.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(event) && ForpostBasePanel.this.getTable().getSelectedRow() == ForpostBasePanel.this.getTable().rowAtPoint(event.getPoint())) {
                        ForpostBasePanel.this.getPopupMenu().show((Component)ForpostBasePanel.this.getTable(), event.getX(), event.getY());
                    }
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        });
    }

    protected void initListeners() throws BGException {
        this.pagePanel.addPropertyChangeListener(e -> this.performAction("refresh"));
        this.getTable().getRowSorter().addRowSorterListener(e -> {
            if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                this.pagePanel.setPageIndex(1);
                this.performAction("refresh");
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.doRefresh());
    }

    protected void doRefresh() throws Exception {
        ClientUtils.showMessageDialog((Object)"\u041c\u0435\u0442\u043e\u0434 doRefresh() \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d");
    }

    protected BGUTable getTable() throws BGException {
        if (this.table == null) {
            this.table = new BGUTable(this.getTableModel());
            this.table.setSelectionMode(0);
        }
        return this.table;
    }

    protected BGTableModel<?> getTableModel() throws BGException {
        if (this.tableModel == null) {
            throw new BGException("tableModel is null");
        }
        return this.tableModel;
    }

    protected int getContractId() {
        return -1;
    }

    protected JMenuItem getOpenContractMenuItem() {
        return new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440"){
            {
                this.addActionListener(e -> {
                    int contractId = ForpostBasePanel.this.getSelectedContractId();
                    if (contractId > 0) {
                        ClientUtils.openContract((int)contractId);
                    }
                });
            }
        };
    }

    protected int getSelectedContractId() {
        return -1;
    }

    protected JPopupMenu getPopupMenu() {
        return null;
    }

    protected void doSync() throws Exception {
        ClientUtils.showErrorMessageDialog((String)"\u041c\u0435\u0442\u043e\u0434 doSync() \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d...");
    }

    protected ForpostService getForpostService() {
        if (this.forpostService == null) {
            this.forpostService = (ForpostService)((ClientContext)this.getContext()).getPort(ForpostService.class);
        }
        return this.forpostService;
    }

    class SyncAction
    extends AbstractAction {
        public SyncAction() {
            this.putValue("Name", "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ForpostBasePanel.this.doSync();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }
}

