/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostCamerasPanel
extends ForpostBasePanel<ForpostService> {
    private JComboBox<KeyValue> filterKey = null;
    private BGTextField filterValue = new BGTextField(20);

    @Override
    protected JPanel getFilterPanel() {
        this.filterKey = new JComboBox<KeyValue>(new KeyValue[]{new KeyValue("id", "ID"), new KeyValue("host", "\u0425\u043e\u0441\u0442"), new KeyValue("name", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435")});
        this.filterValue.setHorizontalAlignment(0);
        this.filterValue.addActionListener(e -> this.performAction("refresh"));
        int gridx = 1;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(this.filterKey, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.filterValue, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        JButton syncButton = this.getGetSyncButton();
        if (syncButton != null) {
            panel.add((Component)syncButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    @Override
    protected void initListeners() {
        try {
            super.initListeners();
            super.initPopupListener();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    @Override
    protected int getSelectedContractId() {
        try {
            ForpostTMCAO forpostCamera = (ForpostTMCAO)this.getTableModel().getSelectedRow();
            if (forpostCamera != null) {
                return forpostCamera.getContractId();
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return super.getSelectedContractId();
    }

    @Override
    protected void doRefresh() throws Exception {
        KeyValue filter = new KeyValue(((KeyValue)this.filterKey.getSelectedItem()).getKey(), this.filterValue.getText());
        SearchResult searchResult = this.getService(ForpostService.class).searchForpostCameras(filter, this.table.getSort(), this.pagePanel.getPage());
        ((CameraTableModel)this.getTableModel()).setData(searchResult.getList());
        Page page = searchResult.getPage();
        this.records.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)page.getRecordCount()));
        this.pagePanel.setPage(page);
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getOpenContractMenuItem());
        }
        return this.popupMenu;
    }

    @Override
    protected void doSync() throws Exception {
        this.getService(ForpostService.class).doSync();
        this.doRefresh();
    }

    @Override
    protected BGTableModel<?> getTableModel() throws BGException {
        if (this.tableModel == null) {
            this.tableModel = new CameraTableModel();
        }
        return this.tableModel;
    }

    class CameraTableModel
    extends BGTableModel<ForpostTMCAO<ForpostCamera>> {
        public CameraTableModel() {
            super(CameraTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 150, 200, "contractTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u043a\u043a\u0430\u0443\u043d\u0442", 100, 150, 200, "accountName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430", Boolean.class, 70, 70, 70, "isActive", true);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u043c\u0435\u0440\u044b", 300, 500, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041b\u043e\u0433\u0438\u043d", 150, 150, 150, "login", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0425\u043e\u0441\u0442:\u043f\u043e\u0440\u0442", 200, 200, 200, "ipOrDomain", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043b\u0430\u0441\u0442\u0435\u0440", 200, 200, 200, "masterName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u0431\u044a\u0435\u043a\u0442", 200, 200, 200, "objectName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValueAt(ForpostTMCAO<ForpostCamera> value, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            ForpostCamera forpostCamera = (ForpostCamera)value.getObject();
            if ("id".equals(identifier)) {
                return forpostCamera.getId();
            }
            if ("name".equals(identifier)) {
                return forpostCamera.getName();
            }
            if ("login".equals(identifier)) {
                return forpostCamera.getLogin();
            }
            if ("ipOrDomain".equals(identifier)) {
                return forpostCamera.getIpOrDomain() + ":" + forpostCamera.getPort();
            }
            if ("objectName".equals(identifier)) {
                return forpostCamera.getAccountObjectId();
            }
            if ("masterName".equals(identifier)) {
                return forpostCamera.getMasterId();
            }
            if ("isActive".equals(identifier)) {
                return forpostCamera.getIsActive() == 1;
            }
            if ("contractTitle".equals(identifier)) {
                return value.getContractTitle();
            }
            if ("accountName".equals(identifier)) {
                return value.getAccountName();
            }
            return super.getValueAt(value, column);
        }
    }
}

