/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostGroupService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostGroupsPanel
extends ForpostBasePanel<ForpostGroupService> {
    @Override
    protected void initListeners() {
        try {
            super.initListeners();
            super.initPopupListener();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getOpenContractMenuItem());
        }
        return this.popupMenu;
    }

    @Override
    protected int getSelectedContractId() {
        try {
            ForpostTMCAO forpostTMCAO = (ForpostTMCAO)((GroupTableModel)this.getTableModel()).getSelectedRow();
            if (forpostTMCAO != null) {
                return forpostTMCAO.getContractId();
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return super.getSelectedContractId();
    }

    @Override
    protected void doRefresh() throws BGException {
        SearchResult searchResult = this.getService(ForpostGroupService.class).searchForpostGroups(this.table.getSort(), this.pagePanel.getPage());
        ((GroupTableModel)this.getTableModel()).setData(searchResult.getList());
        Page page = searchResult.getPage();
        this.records.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)page.getRecordCount()));
        this.pagePanel.setPage(page);
    }

    @Override
    protected void doSync() throws Exception {
        this.getService(ForpostGroupService.class).doSync();
        this.doRefresh();
    }

    @Override
    protected BGTableModel<?> getTableModel() throws BGException {
        if (this.tableModel == null) {
            this.tableModel = new GroupTableModel(GroupTableModel.class.getName());
        }
        return this.tableModel;
    }

    class GroupTableModel
    extends BGTableModel<ForpostTMCAO<ForpostGroup>> {
        public GroupTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 200, 300, "contractTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u043a\u043a\u0430\u0443\u043d\u0442", 100, 200, 300, "accountName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", 300, 500, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(ForpostTMCAO<ForpostGroup> value, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            ForpostGroup forpostGroup = (ForpostGroup)value.getObject();
            if ("id".equals(identifier)) {
                return forpostGroup.getId();
            }
            if ("name".equals(identifier)) {
                return forpostGroup.getName();
            }
            return super.getValueAt(value, column);
        }
    }
}

