/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.contract;

import bitel.billing.module.common.BGTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.tv.client.TvDevicePanel;
import ru.bitel.bgbilling.modules.tv.client.contract.TvAccountPanel;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.common.service.TvDeviceService;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;

public class TvAccountForm
extends BGUPanel {
    private List<ParamRowData> params = null;
    private ParamRowData paramDevice = new ParamRowData("device", "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", "");
    private ParamRowData paramMAC = new ParamRowData("mac", "MAC-\u0430\u0434\u0440\u0435\u0441", "");
    private ParamRowData paramIdentifier = new ParamRowData("identifier", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", "");
    private ParamRowData paramLogin = new ParamRowData("login", "\u041b\u043e\u0433\u0438\u043d", "");
    private ParamRowData paramAutoLogin = new ParamRowData("autoLogin", "\u0410\u0432\u0442\u043e\u043c. \u0433\u0435\u043d\u0435\u0440. \u043b\u043e\u0433\u0438\u043d\u0430", "true");
    private ParamRowData paramPassword = new ParamRowData("password", "\u041f\u0430\u0440\u043e\u043b\u044c", "");
    private ParamRowData paramAutoPassword = new ParamRowData("autoPassword", "\u0410\u0432\u0442\u043e\u043c. \u0433\u0435\u043d\u0435\u0440. \u043f\u0430\u0440\u043e\u043b\u044f", "");
    private ParamRowData paramPin = new ParamRowData("pin", "PIN", "");
    private ParamRowData paramAutoPin = new ParamRowData("autoPin", "\u0410\u0432\u0442\u043e\u043c. \u0433\u0435\u043d\u0435\u0440. PIN", "");
    private ParamTableModel paramTableModel = new ParamTableModel();
    private final TvAccountPanel panel;
    private BGEditor editor;
    private BGUComboBox<TvAccountSpec> serviceType;
    private BGTextField accountId = new BGTextField(6);
    private BGControlPanelPeriodNoB period;
    private BGUComboBox<IdTitle> status;
    private BGTextArea comment = new BGTextArea(2, 30);
    private BGTextArea state = new BGTextArea(2, 30);
    private JTabbedPane tabbedPane;
    private JPopupMenu tableJPopupMenu = null;
    private EntityAttributesForm entityAttributesForm;
    private AtomicReference<TvAccount> currentTypeRef = new AtomicReference();
    private Directory<ProductSpec> productSpecDirectory;
    TvAccountService tvAccountService = null;
    TvAccount parent;
    TvAccount current;

    public TvAccountForm(TvAccountPanel panel) {
        super((LayoutManager)new BorderLayout());
        this.panel = panel;
        this.params = Arrays.asList(this.paramMAC, this.paramIdentifier, this.paramLogin, this.paramPassword, this.paramPin);
    }

    private TvAccountService getTvAccountService() {
        if (this.tvAccountService == null) {
            this.tvAccountService = (TvAccountService)((ClientContext)this.getContext()).getPort(TvAccountService.class);
        }
        return this.tvAccountService;
    }

    protected void jbInit() throws BGException {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ParamRowData paramRowData = (ParamRowData)TvAccountForm.this.paramTableModel.getSelectedRow();
                    if (TvAccountForm.this.paramAutoLogin.equals(paramRowData)) {
                        boolean newValue = Boolean.valueOf(TvAccountForm.this.paramAutoLogin.value) == false;
                        TvAccountForm.this.paramAutoLogin.value = String.valueOf(newValue);
                        TvAccountForm.this.paramLogin.value = newValue ? "" : TvAccountForm.this.current.getLogin();
                    } else if (TvAccountForm.this.paramAutoPassword.equals(paramRowData)) {
                        boolean newValue = Boolean.valueOf(TvAccountForm.this.paramAutoPassword.value) == false;
                        TvAccountForm.this.paramAutoPassword.value = String.valueOf(newValue);
                        TvAccountForm.this.paramPassword.value = newValue ? "" : TvAccountForm.this.current.getPassword();
                    } else if (TvAccountForm.this.paramDevice.equals(paramRowData)) {
                        TvAccountForm.this.performAction("device.select", String.valueOf(TvAccountForm.this.current.getDeviceId()));
                    }
                    TvAccountForm.this.paramTableModel.fireTableDataChanged();
                }
            }
        };
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        font = new FontUIResource(new Font(font.getName(), font.getStyle(), font.getSize() + 2));
        int fontHeight = this.getFontMetrics(font).getHeight() + 3;
        BGUTable paramTable = new BGUTable((TableModel)((Object)this.paramTableModel));
        paramTable.setFont((Font)font);
        paramTable.setRowHeight(fontHeight);
        paramTable.setSelectionMode(0);
        paramTable.addMouseListener((MouseListener)mouseAdapter);
        paramTable.setComponentPopupMenu(this.getPopupMenu());
        paramTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    TvAccountForm.this.deleteParamValue();
                }
            }
        });
        paramTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)this.getTypePeriodStatusPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)paramTable, (int)300, (int)120), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 0, 3), 0, 0));
        mainPanel.add((Component)this.getCommentAndStatePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        ActionListener editorsListener = e -> {
            String command = e.getActionCommand();
            if ("device.selected".equals(command)) {
                TvDevicePanel panel = (TvDevicePanel)((Object)((Object)e.getSource()));
                TvDevice selectedDevice = (TvDevice)panel.getSelectedDevice();
                this.current.setDeviceId(selectedDevice.getId());
                this.paramDevice.value = selectedDevice.getTitle();
            }
        };
        this.entityAttributesForm = new EntityAttributesForm(this.currentTypeRef, (ClientContext)this.getContext());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)mainPanel, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.tabbedPane.add((Component)this.entityAttributesForm, "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b");
        this.editor = new BGEditor("main");
        this.editor.addForm((JComponent)this.tabbedPane, (Object)"main");
        this.editor.addForm((JComponent)BGSwingUtilites.wrapBorder((JPanel)((Object)new TvDevicePanel((ClientContext)this.getContext(), 2, editorsListener)), (String)"\u0412\u044b\u0431\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430"));
        this.add((Component)this.editor, "Center");
        this.productSpecDirectory = ((ClientContext)this.getContext()).getDirectory(ProductSpec.class, 0);
    }

    private JPanel getCommentAndStatePanel() {
        this.state.setEditable(false);
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(BGSwingUtilites.wrapBorder((JComponent)BGSwingUtilites.wrapScrollPane((JComponent)this.comment, (int)300, (int)50), (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        panel.add(BGSwingUtilites.wrapBorder((JComponent)BGSwingUtilites.wrapScrollPane((JComponent)this.state, (int)300, (int)50), (String)"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435"));
        return panel;
    }

    private JPanel getTypePeriodStatusPanel() {
        this.serviceType = new BGUComboBox(false);
        this.serviceType.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.onTvAccountSpecSelected();
            }
        });
        this.period = new BGControlPanelPeriod();
        ArrayList<IdTitle> data = new ArrayList<IdTitle>();
        data.add(new IdTitle(0, "\u041e\u0442\u043a\u0440\u044b\u0442"));
        data.add(new IdTitle(1, "\u0417\u0430\u043a\u0440\u044b\u0442"));
        data.add(new IdTitle(2, "\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
        this.status = new BGUComboBox();
        this.status.setData(data);
        this.accountId.setEditable(false);
        this.accountId.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapBorder(this.serviceType, (String)"\u0422\u0438\u043f"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JComponent)this.accountId, (String)"ID#"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.period, (String)"\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder(this.status, (String)"\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void onTvAccountSpecSelected() {
        Preferences tvAccountSpecConfig;
        int constDeviceId;
        TvAccountSpec tvAccountSpec = (TvAccountSpec)this.serviceType.getSelectedItem();
        if (tvAccountSpec == null) {
            return;
        }
        this.paramTableModel.deleteRows();
        if (tvAccountSpec.isNeedDevice()) {
            this.paramDevice.value = "";
            this.paramTableModel.getRows().add(this.paramDevice);
        }
        if (tvAccountSpec.isNeedLogin()) {
            this.paramLogin.reset();
            this.paramAutoLogin.value = "true";
            this.paramTableModel.getRows().add(this.paramLogin);
            this.paramTableModel.getRows().add(this.paramAutoLogin);
        }
        if (tvAccountSpec.isNeedPassword()) {
            this.paramPassword.reset();
            this.paramAutoPassword.value = "true";
            this.paramTableModel.getRows().add(this.paramPassword);
            this.paramTableModel.getRows().add(this.paramAutoPassword);
        }
        if (tvAccountSpec.isNeedPin()) {
            this.paramPin.reset();
            this.paramAutoPin.value = "true";
            this.paramTableModel.getRows().add(this.paramPin);
            this.paramTableModel.getRows().add(this.paramAutoPin);
        }
        if (tvAccountSpec.isNeedMacAddress()) {
            this.paramMAC.reset();
            this.paramTableModel.getRows().add(this.paramMAC);
        }
        if (tvAccountSpec.isNeedIdentifier()) {
            this.paramIdentifier.reset();
            this.paramTableModel.getRows().add(this.paramIdentifier);
        }
        if (this.current.getId() <= 0 && (constDeviceId = (tvAccountSpecConfig = new Preferences(tvAccountSpec.getConfig(), "\n\r")).getInt("const.device.id", -1)) > 0) {
            this.current.setDeviceId(constDeviceId);
            if (tvAccountSpec.isNeedDevice()) {
                try {
                    TvDevice device = (TvDevice)((TvDeviceService)((ClientContext)this.getContext()).getPort(TvDeviceService.class)).deviceGet(constDeviceId);
                    if (device != null) {
                        this.current.setDeviceTitle(device.getTitle());
                        this.paramDevice.value = device.getTitle();
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        }
    }

    public void performActionOpen() {
        this.serviceType.setSelectedItem((Object)this.current.getSpecId());
        this.period.setDateString1(TimeUtils.formatDate((Date)this.current.getDateFrom()));
        this.period.setDateString2(TimeUtils.formatDate((Date)this.current.getDateTo()));
        this.comment.setText(this.current.getComment());
        if (this.current.getMacAddressList() == null) {
            this.paramMAC.reset();
        } else {
            StringBuilder sb = new StringBuilder();
            for (byte[] macAddress : this.current.getMacAddressList()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(TvAccount.macAddressToString((byte[])macAddress));
            }
            this.paramMAC.value = sb.toString();
        }
        this.paramIdentifier.value = Utils.maskNull((String)this.current.getIdentifier());
        this.paramDevice.value = Utils.maskNull((String)this.current.getDeviceTitle());
        this.paramLogin.value = Utils.maskNull((String)this.current.getLogin());
        this.paramPassword.value = Utils.maskNull((String)this.current.getPassword());
        this.paramPin.value = Utils.maskNull((String)this.current.getPin());
        this.status.setSelectedItem((Object)this.current.getStatus());
        this.status.setEnabled(this.current.getParentId() <= 0);
        super.performActionOpen();
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            ArrayList<TvAccountSpec> newServTypeList;
            if (this.isShowing()) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                return;
            }
            ArrayList<TvAccountSpec> servTypeList = this.getTvAccountService().tvAccountSpecList();
            this.parent = (TvAccount)this.panel.model.getSelectedRow();
            if (this.parent != null && this.parent.getId() <= 0) {
                this.parent = null;
            }
            TvAccountSpec parentType = null;
            TvAccount parentTvAccount = this.parent;
            if (parentTvAccount != null) {
                parentType = servTypeList.stream().filter(a -> a.getId() == parentTvAccount.getSpecId()).findFirst().orElse(null);
            }
            if (parentType != null) {
                newServTypeList = new ArrayList<TvAccountSpec>();
                newServTypeList.addAll(servTypeList.stream().filter(a -> a.getParentTypeIds().contains(parentTvAccount.getSpecId())).toList());
                if (newServTypeList.size() > 0) {
                    servTypeList = newServTypeList;
                } else {
                    parentType = null;
                }
            }
            if (parentType == null) {
                this.parent = null;
                newServTypeList = new ArrayList();
                for (TvAccountSpec type : servTypeList) {
                    if (type.getParentTypeIds() != null && type.getParentTypeIds().size() != 0) continue;
                    newServTypeList.add(type);
                }
                servTypeList = newServTypeList;
            }
            TvAccountSpec emptyType = new TvAccountSpec();
            emptyType.setTitle("===== \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f =====");
            servTypeList.add(0, emptyType);
            this.current = new TvAccount();
            this.accountId.setText("");
            this.current.setContractId(((ClientContext)this.getContext()).getContractId());
            this.current.setDateFrom(new Date());
            if (this.parent != null) {
                this.current.setParentId(this.parent.getId());
                this.current.setDeviceId(this.parent.getDeviceId());
            }
            this.serviceType.setData(servTypeList);
            this.serviceType.setEnabled(true);
            this.state.setText("");
            this.performActionOpen();
            this.paramAutoLogin.value = "true";
            this.paramAutoPassword.value = "true";
            this.paramTableModel.deleteRows();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (this.isShowing()) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                return;
            }
            this.tabbedPane.setSelectedIndex(0);
            this.current = (TvAccount)this.panel.model.getSelectedRow();
            if (this.current == null || this.current.getId() == 0) {
                return;
            }
            this.current = this.current.clone();
            this.parent = this.current.getParentId() > 0 ? this.getTvAccountService().tvAccountGet(this.current.getContractId(), this.current.getParentId()) : null;
            List servTypeList = this.getTvAccountService().tvAccountSpecList();
            TvAccountSpec emptyType = new TvAccountSpec();
            emptyType.setTitle("===== \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f =====");
            servTypeList.add(0, emptyType);
            this.serviceType.setData(servTypeList);
            this.serviceType.setEnabled(false);
            this.accountId.setText(String.valueOf(this.current.getId()));
            if (this.current.getParentId() > 0) {
                this.state.setText("");
            } else {
                StringBuilder sb = new StringBuilder();
                switch (this.current.getDeviceState()) {
                    case 1: {
                        sb.append("\u0412\u043a\u043b\u044e\u0447\u0435\u043d");
                        break;
                    }
                    case 0: {
                        sb.append("\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
                        break;
                    }
                    case -1: {
                        sb.append("\u0423\u0434\u0430\u043b\u0435\u043d");
                        break;
                    }
                    default: {
                        sb.append("null");
                    }
                }
                sb.append(", \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b-\u043e\u043f\u0446\u0438\u0438: ");
                if (this.current.getDeviceOptionIds() != null && this.current.getDeviceOptionIds().size() > 0) {
                    for (Integer optionId : this.current.getDeviceOptionIds()) {
                        sb.append(this.productSpecDirectory.get(optionId.intValue())).append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                } else {
                    sb.append("-");
                }
                this.state.setText(sb.toString());
            }
            this.performActionOpen();
            this.paramAutoPin.value = "false";
            this.paramAutoLogin.value = "false";
            this.paramAutoPassword.value = "false";
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TvAccountSpec _tvAccountSpec = (TvAccountSpec)TvAccountForm.this.serviceType.getSelectedItem();
                if (_tvAccountSpec == null) {
                    return;
                }
                IdTitle _status = (IdTitle)TvAccountForm.this.status.getSelectedItem();
                if (_status == null) {
                    return;
                }
                TvAccountForm.this.current.setSpecId(_tvAccountSpec.getId());
                TvAccountForm.this.current.setDateFrom(TvAccountForm.this.period.getDateFrom());
                TvAccountForm.this.current.setDateTo(TvAccountForm.this.period.getDateTo());
                TvAccountForm.this.current.setMacAddressList(Stream.of(TvAccountForm.this.paramMAC.value.split("\\s*,\\s*")).filter(a -> a.length() > 0).map(a -> TvAccount.parseMacAddress((String)a)).collect(Collectors.toList()));
                TvAccountForm.this.current.setIdentifier(TvAccountForm.this.paramIdentifier.value);
                TvAccountForm.this.current.setLogin(TvAccountForm.this.paramLogin.value);
                TvAccountForm.this.current.setPassword(TvAccountForm.this.paramPassword.value);
                TvAccountForm.this.current.setPin(TvAccountForm.this.paramPin.value);
                TvAccountForm.this.current.setStatus(_status.getId());
                TvAccountForm.this.current.setComment(TvAccountForm.this.comment.getText());
                TvAccountForm.this.getTvAccountService().tvAccountUpdate(TvAccountForm.this.current.getContractId(), TvAccountForm.this.current, Boolean.valueOf(TvAccountForm.this.paramAutoLogin.value).booleanValue(), Boolean.valueOf(TvAccountForm.this.paramAutoPassword.value).booleanValue(), 0L);
                TvAccountForm.this.performActionClose();
                TvAccountForm.this.panel.performAction("refresh");
            }
        };
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (this.isShowing()) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                return;
            }
            this.current = (TvAccount)this.panel.model.getSelectedRow();
            if (this.current == null || this.current.getId() == 0) {
                return;
            }
            if (BGSwingUtilites.confirmDelete((Object)this.current)) {
                this.getTvAccountService().tvAccountDelete(this.current.getContractId(), this.current.getId(), false);
                this.panel.performAction("refresh");
            }
        });
    }

    private void deleteParamValue() {
        ParamRowData paramRowData = (ParamRowData)this.paramTableModel.getSelectedRow();
        if (paramRowData != null) {
            paramRowData.value = "";
            this.paramTableModel.fireTableDataChanged();
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.tableJPopupMenu == null) {
            this.tableJPopupMenu = new JPopupMenu();
            JMenuItem deleteItem = new JMenuItem("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
            deleteItem.addActionListener(e -> this.deleteParamValue());
            this.tableJPopupMenu.add(deleteItem);
            JMenuItem copyItem = new JMenuItem("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
            copyItem.addActionListener(e -> {
                ParamRowData paramRowData = (ParamRowData)this.paramTableModel.getSelectedRow();
                if (paramRowData != null && paramRowData.value != null) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(paramRowData.value), null);
                }
            });
            this.tableJPopupMenu.add(copyItem);
        }
        return this.tableJPopupMenu;
    }

    public class ParamRowData {
        String key;
        String title;
        String value;

        public ParamRowData(String key, String title, String value) {
            this.key = key;
            this.title = title;
            this.value = value;
        }

        public String getTitle() {
            return this.title;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void reset() {
            this.value = "";
        }
    }

    class ParamTableModel
    extends BGTableModel<ParamRowData> {
        public ParamTableModel() {
            super(ParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 100, 300, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", String.class, 100, 200, -1, "value", true, true, new ParamTableCellRenderer());
        }

        public Object getValue(ParamRowData val, int column) throws Exception {
            return super.getValue((Object)val, column);
        }

        protected void setValue(ParamRowData e, int column, Object val) {
            super.setValue((Object)e, column, val);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            super.setValueAt(value, rowIndex, columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ParamRowData data = (ParamRowData)this.getRows().get(rowIndex);
            return columnIndex == 1 && (TvAccountForm.this.params.contains(this.getRows().get(rowIndex)) || "login".equals(data.key) && this.getRows().stream().anyMatch(p -> p.key.equals("autoLogin") && !p.value.equals("true")) || "password".equals(data.key) && this.getRows().stream().anyMatch(p -> p.key.equals("autoPassword") && !p.value.equals("true")));
        }
    }

    class ParamTableCellRenderer
    implements TableCellRenderer {
        ParamTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ParamRowData data = (ParamRowData)((ParamTableModel)((Object)table.getModel())).getRows().get(row);
            if (TvAccountForm.this.paramAutoLogin.equals(data) || TvAccountForm.this.paramAutoPassword.equals(data)) {
                JCheckBox component = (JCheckBox)table.getDefaultRenderer(Boolean.class).getTableCellRendererComponent(table, Boolean.valueOf((String)value), isSelected, hasFocus, row, column);
                component.setHorizontalAlignment(2);
                component.setBorder(new EmptyBorder(1, 5, 1, 1));
                return component;
            }
            if (TvAccountForm.this.paramPassword.equals(data)) {
                JLabel label = (JLabel)table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setText("*".repeat(15));
                return label;
            }
            return table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

