/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.twpg.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.time.LocalDate;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodWithTime;
import ru.bitel.bgbilling.client.common.BGSummaTextField;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.modules.twpg.common.bean.Transaction;
import ru.bitel.bgbilling.modules.twpg.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.twpg.common.service.TWPGService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionMonitor
extends BGUPanel {
    private TransactionTableModel transactionTableModel;
    private BGTextField contractTitleTextfield = new BGTextField(10);
    private BGComboBox<AbstractTransactionStatus> statusComboBox = new BGComboBox();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelPeriodWithTime periodPanel = new BGControlPanelPeriodWithTime();
    private BGSummaTextField summaField = new BGSummaTextField(10);
    private JLabel recordCountLabel = new JLabel();
    private JPopupMenu popupMenu = null;

    public TransactionMonitor() {
        this.transactionTableModel = new TransactionTableModel("TWPGTransactionMonitor");
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected void jbInit() throws Exception {
        final BGUTable paymentTable = new BGUTable((TableModel)((Object)this.transactionTableModel));
        paymentTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) && paymentTable.getSelectedRow() == paymentTable.rowAtPoint(event.getPoint())) {
                    TransactionMonitor.this.getPopupMenu().show((Component)paymentTable, event.getX(), event.getY());
                }
            }
        });
        this.periodPanel.setDateFrom(LocalDate.now().withDayOfMonth(1).atStartOfDay());
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        filterPanel.add((Component)this.contractTitleTextfield, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
        filterPanel.add((Component)this.statusComboBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)new JLabel("\u041f\u043b\u0430\u0442\u0435\u0436\u0438 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 5), 0, 0));
        filterPanel.add((Component)this.periodPanel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.recordCountLabel, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.pagePanel, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        JPanel infoPanel = new JPanel(new GridBagLayout());
        infoPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 \u0438\u0442\u043e\u0433\u043e: "), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        infoPanel.add((Component)this.summaField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(filterPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)paymentTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(infoPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.statusComboBox.addActionListener(e -> {
            this.pagePanel.setPageIndex(1);
            this.performAction("refresh");
        });
        this.periodPanel.addPropertyChangeListener(e -> {
            this.pagePanel.setPageIndex(1);
            this.performAction("refresh");
        });
        this.contractTitleTextfield.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TransactionMonitor.this.pagePanel.setPageIndex(1);
                TransactionMonitor.this.performAction("refresh");
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TransactionMonitor.this.pagePanel.setPageIndex(1);
                TransactionMonitor.this.performAction("refresh");
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TransactionMonitor.this.pagePanel.setPageIndex(1);
                TransactionMonitor.this.performAction("refresh");
            }
        });
        this.pagePanel.addPropertyChangeListener(e -> this.performAction("refresh"));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchParam searchParam = SearchParam.builder().setContractId(-1).setContractTitle(this.contractTitleTextfield.getText()).setStatus(((TransactionStatus)this.statusComboBox.getSelectedItem()).getCode()).setPeriod(this.periodPanel.getPeriod()).setPage(this.pagePanel.getPage()).build();
            SearchResult searchResult = ((TWPGService)((ClientContext)this.getContext()).getPort(TWPGService.class)).searchTransactionList(searchParam);
            this.transactionTableModel.setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        });
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440"){
                {
                    this.addActionListener(e -> {
                        int contractId;
                        Transaction selectedPayment = (Transaction)TransactionMonitor.this.transactionTableModel.getSelectedRow();
                        if (selectedPayment != null && (contractId = selectedPayment.getContractId()) > 0) {
                            ClientUtils.openContract((int)contractId);
                        }
                    });
                }
            });
            this.popupMenu.add(new JMenuItem("\u0412\u0435\u0440\u043d\u0443\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436"){
                {
                    this.addActionListener(e -> {
                        Transaction selectedPayment = (Transaction)TransactionMonitor.this.transactionTableModel.getSelectedRow();
                        if (selectedPayment != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430", 0) == 0) {
                            try {
                                ((TWPGService)((ClientContext)TransactionMonitor.this.getContext()).getPort(TWPGService.class)).refund(selectedPayment.getId());
                            }
                            catch (Exception ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                            }
                            TransactionMonitor.this.performAction("refresh");
                        }
                    });
                }
            });
        }
        return this.popupMenu;
    }

    class TransactionTableModel
    extends ru.bitel.bgbilling.modules.twpg.client.TransactionTableModel {
        public TransactionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumnContractTitle();
            this.addColumnCreateDate();
            this.addColumnTransactionDate();
            this.addColumn("\u041a\u0430\u0440\u0442\u0430", 200, 200, 200, "card", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u0434 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438", 150, 150, 150, "authorizationCode", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumnStatus();
            this.addColumnSum();
        }
    }
}

