/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.Invoice;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class ActionContractInvoice
extends ActionBase {
    public void doAction() throws Exception {
        if (this.mid <= 0 || this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Page page = this.getPage();
        DecimalFormat format = new DecimalFormat("00");
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Invoice payBill : new InvoiceManager(this.con, this.mid).getInvoiceList(page, this.cid, false)) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(payBill.getId()));
            row.setAttribute("number", String.valueOf(payBill.getFormatNumber()));
            row.setAttribute("create_dt", TimeUtils.formatDate((Date)payBill.getCreateDate()));
            row.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)payBill.getSumm()));
            row.setAttribute("sum", String.valueOf(payBill.getSumm()));
            row.setAttribute("type", String.valueOf(payBill.getTypeId()));
            row.setAttribute("type_title", Utils.maskNull((String)payBill.getTypeTitle()));
            row.setAttribute("month", payBill.getYy() + "." + format.format(payBill.getMm() + 1));
            row.setAttribute("show_ready", String.valueOf(payBill.isShowReady()));
            row.setAttribute("userId", "" + payBill.getUserId());
        }
        this.setPageAttribute(table, page);
    }
}

