/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.phone;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Dect_1
extends BGJasperReport {
    public Report_Dect_1() {
        this.id = "phone_dect_1";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            BGReportFilter filter = this.createBGReportFilter();
            Calendar date1 = TimeUtils.parseCalendar((String)filter.getStringParam("date1"), (String)"dd.MM.yyyy");
            Calendar date2 = TimeUtils.parseCalendar((String)filter.getStringParam("date2"), (String)"dd.MM.yyyy");
            int hour1 = Utils.parseInt((String)filter.getStringParam("hour1"), (int)-1);
            int hour2 = Utils.parseInt((String)filter.getStringParam("hour2"), (int)-1);
            String groups = filter.getStringParam("gr");
            String sids = filter.getStringParam("sids");
            int mid = Utils.parseInt((String)filter.getStringParam("mid"), (int)-1);
            if (date1 != null && groups != null && mid > 0) {
                String tableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1.getTime(), (int)mid);
                BGDataSource data = new BGDataSource();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("addInfo", " \u0433\u043e\u0434: " + date1.get(1) + " \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.monthNames[date1.get(2)]);
                if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                    long groupMask = Utils.enumToMask((String)groups);
                    StringBuilder query = new StringBuilder(300);
                    query.append("SELECT service.title, log.sid, COUNT(log.id), SUM(log.session_time), SUM(log.round_session_time), SUM(log.cost) FROM service LEFT JOIN ");
                    query.append(tableName);
                    query.append(" AS log ON service.id=log.sid");
                    query.append(" LEFT JOIN contract ON contract.id=log.cid WHERE");
                    query.append(" TO_DAYS(log.hour)>=TO_DAYS('");
                    query.append(TimeUtils.format((Calendar)date1, (String)"yyyy-MM-dd"));
                    query.append("') AND TO_DAYS(log.hour)<=TO_DAYS('");
                    query.append(TimeUtils.format((Calendar)date2, (String)"yyyy-MM-dd"));
                    query.append("')");
                    if (groupMask != 0L) {
                        query.append(" AND contract.gr&");
                        query.append(groupMask);
                        query.append(">0");
                    }
                    if (sids != null && sids.length() > 0) {
                        query.append(" AND service.id IN (");
                        query.append(sids);
                        query.append(")");
                    }
                    if (hour1 >= 0) {
                        query.append(" AND HOUR(log.hour)>=");
                        query.append(hour1);
                    }
                    if (hour2 >= 0) {
                        query.append(" AND HOUR(log.hour)<=");
                        query.append(hour2);
                    }
                    query.append(" GROUP BY log.sid");
                    PreparedStatement ps = this.con.prepareStatement(query.toString());
                    ResultSet rs = ps.executeQuery();
                    int count = 0;
                    int amount = 0;
                    int round_amount = 0;
                    BigDecimal summa = new BigDecimal(0);
                    while (rs.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        row.put("title", rs.getString(1));
                        row.put("sid", String.valueOf(rs.getInt(2)));
                        int cnt = rs.getInt(3);
                        count += cnt;
                        row.put("count", String.valueOf(cnt));
                        int amnt = rs.getInt(4);
                        amount += amnt;
                        row.put("amount", String.valueOf(Math.round((float)amnt / 60.0f)));
                        amnt = rs.getInt(5);
                        round_amount += amnt;
                        row.put("round_amount", String.valueOf(Math.round((float)amnt / 60.0f)));
                        BigDecimal temp = rs.getBigDecimal(6);
                        summa = summa.add(temp);
                        row.put("summa", Utils.formatCost((BigDecimal)temp));
                        data.addRow(row);
                    }
                    rs.close();
                    ps.close();
                    params.put("summa", Utils.formatCost((BigDecimal)summa));
                    params.put("amount", String.valueOf(Math.round((float)amount / 60.0f)));
                    params.put("round_amount", String.valueOf(Math.round((float)round_amount / 60.0f)));
                    params.put("count", String.valueOf(count));
                }
                this.fillReportToStream("phone_dect_1", out, params, data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

