/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusProcessor;

public class ConnectionCountChecker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(ConnectionCountChecker.class);
    private DialUpRadiusProcessor processor;

    public ConnectionCountChecker(DialUpRadiusProcessor processor) {
        this.processor = processor;
        logger.info("Connection count checker..");
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                final HashMap connectionCounts = new HashMap();
                this.processor.processConnections(new DialUpRadiusProcessor.ConnectionIterator(){

                    public boolean processConnection(DialUpNas nas, DialUpNasConnection con) {
                        DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
                        if (con.getStatus() != NasConnection.Status.working) {
                            return true;
                        }
                        if (session.isFakeSession()) {
                            return true;
                        }
                        Login login = session.getLogin();
                        int maxSessions = login.getMaxSession();
                        Integer currentCount = (Integer)connectionCounts.get(login.getId());
                        if (currentCount == null) {
                            currentCount = 0;
                        }
                        Integer n = currentCount;
                        currentCount = currentCount + 1;
                        connectionCounts.put(login.getId(), currentCount);
                        if (maxSessions != 0 && maxSessions < currentCount) {
                            ((DialUpSessionRealtime)con.getSession()).addLogInfo("Breaking connection by session count limit..");
                            con.kill(nas);
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                ConnectionCountChecker.sleep(30000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

