/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatus;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebTariff;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebAgentDAO;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebTariffDAO;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;

public class DrwebApiManager
extends BGLogger {
    private static final String ADD_CUSTOMER = "add.ds";
    private Connection con;
    int mid;
    private String urlString = null;
    private String userName = null;
    private String userPswd = null;
    private String encoding = null;
    private String errorBalance = null;
    private int maxAgentCount = -1;
    private String maxAgentCountMessage = null;
    private int httpTimeout = 30000;

    public DrwebApiManager(Connection con, ParameterMap moduleSetup, int mid) {
        this.con = con;
        this.mid = mid;
        this.urlString = moduleSetup.get("drweb.api.url", null);
        this.userName = moduleSetup.get("drweb.api.user", null);
        this.userPswd = moduleSetup.get("drweb.api.pswd", null);
        this.encoding = moduleSetup.get("drweb.api.encoding", null);
        this.errorBalance = moduleSetup.get("drweb.error.balance.message", "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u0435\u043d\u0435\u0433 \u043d\u0430 \u0441\u0447\u0435\u0442\u0435");
        this.maxAgentCount = moduleSetup.getInt("drweb.agent.max.count", -1);
        this.maxAgentCountMessage = moduleSetup.get("drweb.error.max.count.message", "\u0412\u044b \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u0438 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0433\u0435\u043d\u0442\u043e\u0432");
        this.httpTimeout = moduleSetup.getInt("drweb.api.timeout", 30000);
    }

    private String getDescription(int cid) throws SQLException {
        DrwebAgentDAO agentManager = new DrwebAgentDAO(this.con, this.mid);
        return new ContractUtils(this.con).getContractTitle(cid, false) + "_" + agentManager.getAgentCount(cid);
    }

    public DrwebAgent newAgent(int contractId, int tariffId) throws SQLException {
        DrwebTariffDAO drwebTariffDAO = new DrwebTariffDAO(this.con, this.mid);
        DrwebAgentDAO agentManager = new DrwebAgentDAO(this.con, this.mid);
        DrwebTariff tariff = (DrwebTariff)drwebTariffDAO.get(tariffId);
        if (!this.checkBalance(contractId)) {
            throw new BGRuntimeException(this.errorBalance);
        }
        if (tariff == null) {
            throw new BGRuntimeException("\u0422\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443");
        }
        DrwebAgent agent = this.getAgentFromAVD(contractId, tariff.getGroupTitle());
        agent.setCid(contractId);
        agent.setStatus(1);
        agent.setTariffId(tariff.getId());
        agent.setDateFrom(new Date());
        agentManager.newAgent(agent);
        DrwebAgentStatus status = new DrwebAgentStatus();
        status.setAgentId(agent.getId());
        status.setStatusDate(new Date());
        status.setTariffId(tariff.getId());
        status.setStatus(1);
        agentManager.updateStatus(status, -1, true);
        return agent;
    }

    private DrwebAgent getAgentFromAVD(int contractId, String groupTitle) {
        DrwebAgent agent = null;
        try {
            InputStream answer;
            HashMap<String, String> params = new HashMap<String, String>();
            String des = this.getDescription(contractId);
            params.put("description", des);
            params.put("name", des);
            if (groupTitle != null) {
                params.put("rate", groupTitle);
            }
            if ((answer = this.transferData(ADD_CUSTOMER, params)) == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430");
            }
            Document doc = XMLUtils.parseDocument((InputSource)new InputSource(answer));
            int errorCode = this.checkError(doc);
            if (errorCode != 0) {
                this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430" + XMLUtils.selectText((Node)doc, (String)"//error/message/text()"));
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430");
            }
            agent = new DrwebAgent();
            agent.setAgentUUID(XMLUtils.selectText((Node)doc, (String)"//station/@id"));
            agent.setName(des);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGRuntimeException((Throwable)ex);
        }
        return agent;
    }

    private boolean checkBalance(int contractId) {
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            boolean bl = bu.getBalance(LocalDate.now(), contractId).compareTo(BigDecimal.ZERO) > 0;
            return bl;
        }
    }

    private InputStream transferData(String command, Map<String, String> params) throws Exception {
        String userAndPswd = this.userName + ":" + this.userPswd;
        URL url = null;
        StringBuilder paramStr = new StringBuilder();
        for (String key : params.keySet()) {
            paramStr.append(this.urlEncode(key));
            paramStr.append("=");
            paramStr.append(this.urlEncode(params.get(key)));
            paramStr.append("&");
        }
        url = paramStr.length() == 0 ? new URL(this.urlString + command) : new URL(this.urlString + command + "?" + paramStr.toString());
        this.getLogger().debug("url = " + url);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        con.setRequestProperty("Authorization", "Basic " + Base64.encode((String)userAndPswd));
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setConnectTimeout(this.httpTimeout);
        int code = con.getResponseCode();
        if (con.getResponseCode() == 200) {
            this.getLogger().debug("code=" + code);
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer result = new StringBuffer();
                int b = 0;
                byte[] in = new byte[1024];
                BufferedInputStream bis = new BufferedInputStream(con.getInputStream());
                while ((b = bis.read(in, 0, 1024)) != -1) {
                    result.append(new String(in, 0, b, this.encoding));
                }
                bis.close();
                this.getLogger().debug("result=" + result.toString());
                return new ByteArrayInputStream(result.toString().getBytes());
            }
            return con.getInputStream();
        }
        this.getLogger().error("code=" + code);
        return null;
    }

    private String urlEncode(String inStr) {
        String outStr = "";
        if (inStr != null) {
            try {
                outStr = URLEncoder.encode(inStr, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return outStr;
    }

    private int checkError(Document doc) throws Exception {
        String codeElementTextContent = XMLUtils.selectText((Node)doc, (String)"//error/errno/text()");
        if (Utils.isEmptyString((String)codeElementTextContent)) {
            return 0;
        }
        return Integer.parseInt(codeElementTextContent);
    }

    public int getActualAgentCount(int contractId) throws SQLException {
        return new DrwebAgentDAO(this.con, this.mid).getActualAgentCount(contractId);
    }

    public void checkMaxAgentCount(int contractId) throws SQLException {
        DrwebAgentDAO agentManager;
        if (this.maxAgentCount > 0 && (agentManager = new DrwebAgentDAO(this.con, this.mid)).getActualAgentCount(contractId) >= this.maxAgentCount) {
            throw new BGRuntimeException(this.maxAgentCountMessage);
        }
    }
}

