/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BSHEditor;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class IPNServiceConfigGateTypes
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGTextField title_TF = new BGTextField();
    private JTextArea comment_TA = new JTextArea();
    private BGConfigEditorPane config = new BGConfigEditorPane();
    private JTextPane rule = new JTextPane();
    private DefaultListModel<BGUListItem> ruleTypeModel = new DefaultListModel();
    private JList<BGUListItem> ruleTypeList = new JList<BGUListItem>(this.ruleTypeModel);
    private DefaultComboBoxModel<ComboBoxItem> ruleTypeCBModel = new DefaultComboBoxModel();
    private JComboBox<ComboBoxItem> ruleTypeCmb = new JComboBox<ComboBoxItem>(this.ruleTypeCBModel);
    private BGDialogToolBar ruleTypeToolBar = new BGDialogToolBar();
    private JSplitPane splitPane = null;
    private BSHEditor script = new BSHEditor();
    private JTabbedPane tabbedPane = new JTabbedPane();

    public IPNServiceConfigGateTypes() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "gate_type");
    }

    private void jbInit() throws Exception {
        ClientUtils.addShowCodeListener((BGTable)this.table);
        this.splitPane = new JSplitPane(0);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setTopComponent(new JScrollPane((Component)this.table));
        this.setLayout(new GridBagLayout());
        this.add(this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.createEditor();
        BGSwingUtilites.handleLDMouseClicked((Component)this.table, e -> this.editItem());
    }

    private void createEditor() {
        this.title_TF.setMinimumSize(new Dimension(300, 24));
        this.title_TF.setPreferredSize(new Dimension(300, 24));
        this.editor.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editor.setMinimumSize(new Dimension(100, 300));
        this.editor.setPreferredSize(new Dimension(100, 300));
        this.editor.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.title_TF, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.editor.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)new JScrollPane(this.comment_TA), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.createConfigTab(this.tabbedPane);
        this.createRuleTab(this.tabbedPane);
        this.createRuleTypeTab(this.tabbedPane);
        this.createScriptTab(this.tabbedPane);
        JButton saveButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        saveButton.setActionCommand("save");
        JButton saveAndExitButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u044c");
        saveAndExitButton.setActionCommand("saveandexit");
        JButton exitButton = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u043d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u044f");
        exitButton.setActionCommand("exit");
        this.editor.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.editor.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.editor.add((Component)saveButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.editor.add((Component)saveAndExitButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.editor.add((Component)exitButton, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        ActionListener buttonListener = e -> {
            if ("save".equals(e.getActionCommand())) {
                this.save();
            } else if ("saveandexit".equals(e.getActionCommand())) {
                this.stopEdit(true);
            } else if ("exit".equals(e.getActionCommand())) {
                this.stopEdit(false);
            }
        };
        saveButton.addActionListener(buttonListener);
        saveAndExitButton.addActionListener(buttonListener);
        exitButton.addActionListener(buttonListener);
        this.editor.add((Component)this.tabbedPane, new GridBagConstraints(1, 0, 4, 4, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.editor.setVisible(false);
        this.editor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                IPNServiceConfigGateTypes.this.setData();
            }
        });
    }

    private void createRuleTypeTab(JTabbedPane tabbedPane) {
        this.ruleTypeToolBar.setOrientation(0);
        this.ruleTypeToolBar.setMargin(new Insets(5, 5, 5, 5));
        this.ruleTypeToolBar.setBorderPainted(false);
        this.ruleTypeToolBar.setFloatable(false);
        this.buildRuleToolBar();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0440\u0430\u0432\u0438\u043b\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add(this.ruleTypeCmb, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.ruleTypeToolBar, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.ruleTypeList), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        tabbedPane.add((Component)panel, "\u0422\u0438\u043f\u044b \u043f\u0440\u0430\u0432\u0438\u043b");
    }

    private void createRuleTab(JTabbedPane tabbedPane) {
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.rule);
        panel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        tabbedPane.add((Component)panel, "\u041a\u043e\u043c\u0430\u043d\u0434\u044b");
    }

    private void createConfigTab(JTabbedPane tabbedPane) {
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView((Component)this.config);
        panel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        tabbedPane.add((Component)panel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
    }

    private void createScriptTab(JTabbedPane tabbedPane) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.script, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        tabbedPane.add((Component)panel, "\u0421\u043a\u0440\u0438\u043f\u0442");
    }

    private void buildRuleToolBar() {
        this.ruleTypeToolBar.setDefaultButtons((ActionListener)new PropertyToolBarActionListener(), new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM});
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GateTypeTable");
        request.setModuleId(this.getModuleId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }

    public void newItem() {
        this.id = "0";
        this.startEdit();
    }

    public void editItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != null) {
            this.startEdit();
        }
    }

    public void deleteItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0448\u043b\u044e\u0437\u0430?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("DeleteGateType");
            request.setAttribute("id", this.id);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    private void startEdit() {
        if ("0".equals(this.id)) {
            this.title_TF.setText("");
            this.comment_TA.setText("");
            this.config.setText("");
            this.rule.setText("");
            this.script.setText("");
        } else {
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("GetGateType");
            req.setAttribute("id", this.id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element type = XMLUtils.getElement((Document)doc, (String)"gate_type");
                this.title_TF.setText(type.getAttribute("title"));
                this.comment_TA.setText(ClientUtils.linesToString((Element)XMLUtils.getElement((Document)doc, (String)"comment")));
                this.config.setText(ClientUtils.linesToString((Element)XMLUtils.getElement((Document)doc, (String)"config")));
                this.rule.setText(ClientUtils.linesToString((Element)XMLUtils.getElement((Document)doc, (String)"rule")));
                this.script.setText(ClientUtils.linesToString((Element)XMLUtils.getElement((Document)doc, (String)"script")));
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("RuleTypeTable");
            request.setModuleId(this.getModuleId());
            doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                try {
                    Element node = XMLUtils.selectElement((Node)doc, (String)"//table/data");
                    ClientUtils.buildComboBox(this.ruleTypeCmb, (Node)node, (String)"");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            request = new Request();
            request.setModule(this.module);
            request.setAction("RuleTypeList");
            request.setModuleId(this.getModuleId());
            request.setAttribute("gtid", this.id);
            doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildList(this.ruleTypeList, this.ruleTypeModel, (Node)XMLUtils.getElement((Document)doc, (String)"list"));
            }
            this.adjustRules();
        }
        this.editor.setVisible(true);
        this.splitPane.setBottomComponent(this.editor);
    }

    private void adjustRules() {
        ArrayList<ComboBoxItem> removeList = new ArrayList<ComboBoxItem>();
        for (int i = 0; i < this.ruleTypeModel.getSize(); ++i) {
            BGUListItem listItem = this.ruleTypeModel.getElementAt(i);
            String listId = (String)listItem.getAttribute("id");
            for (int j = 0; j < this.ruleTypeCBModel.getSize(); ++j) {
                ComboBoxItem cmbItem = this.ruleTypeCBModel.getElementAt(j);
                String cmbId = (String)cmbItem.getObject();
                if (!listId.equals(cmbId)) continue;
                removeList.add(cmbItem);
            }
        }
        for (ComboBoxItem item : removeList) {
            this.ruleTypeCBModel.removeElement(item);
        }
    }

    private void sortRuleTypeList() {
        TreeMap<String, BGUListItem> map = new TreeMap<String, BGUListItem>();
        for (int j = 0; j < this.ruleTypeModel.getSize(); ++j) {
            BGUListItem listItem = this.ruleTypeModel.getElementAt(j);
            map.put(listItem.getTitle(), listItem);
        }
        this.ruleTypeModel.clear();
        for (String title : map.keySet()) {
            BGUListItem listItem = (BGUListItem)map.get(title);
            this.ruleTypeModel.addElement(listItem);
        }
    }

    private void sortRuleTypeCmb() {
        TreeMap<String, ComboBoxItem> map = new TreeMap<String, ComboBoxItem>();
        for (int j = 0; j < this.ruleTypeCBModel.getSize(); ++j) {
            ComboBoxItem cmbItem = this.ruleTypeCBModel.getElementAt(j);
            map.put(cmbItem.toString(), cmbItem);
        }
        this.ruleTypeCBModel.removeAllElements();
        for (String title : map.keySet()) {
            this.ruleTypeCBModel.addElement((ComboBoxItem)map.get(title));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean save() {
        String title = this.title_TF.getText();
        String comment = this.comment_TA.getText();
        String config = this.config.getText();
        String rule = this.rule.getText();
        StringBuffer rules = new StringBuffer();
        String script = this.script.getText();
        for (int i = 0; i < this.ruleTypeModel.getSize(); ++i) {
            BGUListItem item = this.ruleTypeModel.getElementAt(i);
            String id = (String)item.getAttribute("id");
            rules.append(id);
            if (i == this.ruleTypeModel.getSize() - 1) continue;
            rules.append(",");
        }
        if (Utils.isBlankString((String)title)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
            return false;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateGateType");
        request.setModuleId(this.getModuleId());
        request.setAttribute("id", this.id);
        request.setAttribute("title", title);
        request.setAttribute("comment", comment);
        request.setAttribute("config", config);
        request.setAttribute("rule", rule);
        request.setAttribute("rules", (Object)rules);
        request.setAttribute("script", script);
        Document doc = this.getDocument(request);
        if (!ClientUtils.checkStatus((Document)doc)) return false;
        Element rootNode = doc.getDocumentElement();
        Object validationError = rootNode.getAttribute("validationError");
        if (Utils.notBlankString((String)validationError)) {
            this.tabbedPane.setSelectedIndex(3);
            int line2 = Utils.parseInt((String)rootNode.getAttribute("validationErrorEndLine"), (int)-1);
            int column2 = Utils.parseInt((String)rootNode.getAttribute("validationErrorEndColumn"), (int)-1);
            validationError = (String)validationError + "\n\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0441\u043a\u0440\u0438\u043f\u0442?";
            this.script.select(line2, column2, line2, column2);
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), validationError, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0441\u043a\u0440\u0438\u043f\u0442\u0430", 0) == 1) {
                return false;
            }
            request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateGateType");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", this.id);
            request.setAttribute("title", title);
            request.setAttribute("comment", comment);
            request.setAttribute("config", config);
            request.setAttribute("rule", rule);
            request.setAttribute("rules", (Object)rules);
            request.setAttribute("script", script);
            request.setAttribute("novalid", true);
            doc = this.getDocument(request);
            if (!ClientUtils.checkStatus((Document)doc)) return false;
            if (!"0".equals(this.id)) return true;
            Element newid = XMLUtils.getElement((Document)doc, (String)"newid");
            this.id = newid.getAttribute("id");
            return true;
        } else {
            if (!"0".equals(this.id)) return true;
            Element newid = XMLUtils.getElement((Document)doc, (String)"newid");
            this.id = newid.getAttribute("id");
        }
        return true;
    }

    private void stopEdit(boolean save) {
        if (save) {
            if (this.save()) {
                this.editor.setVisible(false);
                this.splitPane.setBottomComponent(null);
                this.setData();
            }
        } else {
            this.editor.setVisible(false);
            this.splitPane.setBottomComponent(null);
        }
    }

    class PropertyToolBarActionListener
    implements ActionListener {
        PropertyToolBarActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String actionCommand = actionEvent.getActionCommand();
            if (actionCommand.equals("newItem")) {
                ComboBoxItem cmbItem = (ComboBoxItem)IPNServiceConfigGateTypes.this.ruleTypeCBModel.getSelectedItem();
                IPNServiceConfigGateTypes.this.ruleTypeCBModel.removeElement(IPNServiceConfigGateTypes.this.ruleTypeCBModel.getSelectedItem());
                BGUListItem listItem = new BGUListItem(0, cmbItem.toString());
                listItem.setAttribute("id", cmbItem.getObject());
                IPNServiceConfigGateTypes.this.ruleTypeModel.addElement(listItem);
                IPNServiceConfigGateTypes.this.sortRuleTypeList();
            } else if (actionCommand.equals("deleteItem")) {
                BGUListItem listItem = IPNServiceConfigGateTypes.this.ruleTypeList.getSelectedValue();
                IPNServiceConfigGateTypes.this.ruleTypeModel.getElementAt(IPNServiceConfigGateTypes.this.ruleTypeList.getSelectedIndex());
                IPNServiceConfigGateTypes.this.ruleTypeModel.removeElement(listItem);
                DefaultComboBoxModel cmbModel = (DefaultComboBoxModel)IPNServiceConfigGateTypes.this.ruleTypeCmb.getModel();
                ComboBoxItem cmbItem = new ComboBoxItem(listItem.getAttribute("id"), listItem.getTitle());
                cmbModel.addElement(cmbItem);
                IPNServiceConfigGateTypes.this.sortRuleTypeCmb();
            }
        }
    }
}

