/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectTypeDirectory
extends BGPanel {
    private ObjectTypeTableModel objectTypeTableModel = new ObjectTypeTableModel();
    private ContractObjectService contractObjectService;

    public ObjectTypeDirectory() {
        this.jbInit();
    }

    private void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.objectTypeTableModel));
        table.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.editItem());
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() throws Exception {
        this.objectTypeTableModel.setData(this.getContractObjectService().objectTypeList(false));
    }

    public void deleteItem() {
        ObjectType objectType = (ObjectType)((Object)this.objectTypeTableModel.getSelectedRow());
        if (objectType != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getContractObjectService().objectTypeDelete(objectType.getId());
                objectType = null;
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void editItem() {
        this.objectTypeTableModel.optSelectedRow().ifPresentOrElse(objectType -> new ObjectTypeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (ObjectType)((Object)objectType)).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
    }

    public void newItem() {
        new ObjectTypeEditor("\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430", new ObjectType()).open();
    }

    private ContractObjectService getContractObjectService() {
        if (this.contractObjectService == null) {
            this.contractObjectService = (ContractObjectService)this.getContext().getWebService(ContractObjectService.class, 0);
        }
        return this.contractObjectService;
    }

    class ObjectTypeTableModel
    extends BGTableModel<ObjectType> {
        public ObjectTypeTableModel() {
            super(ObjectTypeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u0430\u043a\u0440\u043e\u0441", 100, 500, 800, "nameMakros", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043a\u0440\u044b\u0442\u044b\u0439", 80, 80, 80, "hidden", true);
        }
    }

    class ObjectTypeEditor
    extends BGEditorDialog<ObjectType> {
        private BGTextField titleField;
        private BGTextField macrosField;
        private BGTextArea commentTextArea;
        private JCheckBox hiddenCheckBox;
        private BGControlPanelListSelect modules;

        public ObjectTypeEditor(String title, ObjectType data) {
            super(title, (Object)data);
            this.titleField = new BGTextField(40);
            this.macrosField = new BGTextField(40);
            this.commentTextArea = new BGTextArea(4, 40);
            this.hiddenCheckBox = new JCheckBox("\u0421\u043a\u0440\u044b\u0442");
            this.modules = new BGControlPanelListSelect();
        }

        public void doDialogPanel() {
            this.panel.setLayout(new GridLayout(1, 2, 10, 0));
            this.panel.add(this.getLeftPanel());
            this.panel.add(this.getRightPanel());
            try {
                List<BGModule> moduleList = ((ModuleService)ObjectTypeDirectory.this.getContext().getPort(ModuleService.class, 0)).moduleList();
                ClientUtils.buildList((JList)this.modules.getList(), moduleList);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.titleField.setText(((ObjectType)((Object)this.data)).getTitle());
            this.macrosField.setText(((ObjectType)((Object)this.data)).getNameMakros());
            this.commentTextArea.setText(((ObjectType)((Object)this.data)).getComment());
            this.hiddenCheckBox.setSelected(((ObjectType)((Object)this.data)).isHidden());
            this.modules.setListValues(Utils.toString(((ObjectType)((Object)this.data)).getModuleList()));
        }

        private JPanel getLeftPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.titleField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041c\u0430\u043a\u0440\u043e\u0441: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.macrosField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.commentTextArea, (int)400, (int)80), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.hiddenCheckBox, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getRightPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u0438: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.modules, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            String title = this.titleField.getText();
            if (Utils.isBlankString((String)title)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return false;
            }
            ((ObjectType)((Object)this.data)).setTitle(title);
            ((ObjectType)((Object)this.data)).setNameMakros(this.macrosField.getText());
            ((ObjectType)((Object)this.data)).setComment(this.commentTextArea.getText());
            ((ObjectType)((Object)this.data)).setHidden(this.hiddenCheckBox.isSelected());
            ((ObjectType)((Object)this.data)).setModuleList(this.modules.getListIds());
            try {
                ObjectTypeDirectory.this.getContractObjectService().objectTypeUpdate((ObjectType)((Object)this.data));
                ObjectTypeDirectory.this.setData();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }
}

