/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import ru.bitel.common.client.LookAndFeelUtils;

public class BGButton
extends JButton {
    private int columnWidth = 0;
    private int columns = 0;

    public BGButton() {
    }

    public BGButton(String text) {
        super(text);
    }

    public BGButton(String text, String actionCommand) {
        super(text);
        this.setActionCommand(actionCommand);
    }

    public BGButton(String text, String actionCommand, ActionListener l) {
        super(text);
        this.setActionCommand(actionCommand);
        this.addActionListener(l);
    }

    public BGButton(Action a) {
        super(a);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns > 0) {
            Insets insets = this.getInsets();
            size.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getPreferredSize();
        size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
        return size;
    }

    private int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int columns) {
        if (columns >= 0 && this.columns != columns) {
            this.columns = columns;
            this.invalidate();
        }
    }
}

