/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.pattern.editors;

import java.util.Iterator;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigBooleanEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigDynamicEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigListEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigMultiDynamicEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigNumberEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigStringEditor;
import ru.bitel.common.XMLUtils;

public class ConfigTitle {
    private String key;
    private String value;
    private String type;
    private Element el;
    private boolean isBold = false;

    public ConfigTitle(String value, Element el, boolean isBold) {
        this.key = el.getAttribute("key");
        this.value = value;
        this.type = el.getAttribute("type");
        this.el = el;
        this.isBold = isBold;
    }

    public ConfigTitle(String key, String value, Element el, boolean isBold) {
        this.key = key;
        this.value = value;
        this.el = el;
        this.type = el == null ? "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440" : el.getAttribute("type");
        this.isBold = isBold;
    }

    public String getRow() throws Exception {
        Iterator<Element> iterator;
        if (this.type.equals("list") && (iterator = XMLUtils.selectElements(this.el, "/list[@title='" + this.value + "']").iterator()).hasNext()) {
            Element g = iterator.next();
            return this.key + "=" + g.getAttribute("value");
        }
        return this.key + "=" + this.value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Element getEl() {
        return this.el;
    }

    public void setEl(Element el) {
        this.el = el;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public String getDefaultValue() {
        return this.getEl().getAttribute("default");
    }

    public String getValidText() {
        return this.getEl().getAttribute("valid");
    }

    public boolean isCorrect() {
        if (this.type.toLowerCase().equals("string")) {
            return ConfigStringEditor.checkValue(this.value, this.getValidText());
        }
        if (this.type.equals("number")) {
            return ConfigNumberEditor.checkValue(this.value, this.getValidText());
        }
        if (this.type.equals("dynamic")) {
            return ConfigDynamicEditor.checkValue(this.value, null);
        }
        if (this.type.equals("list")) {
            return ConfigListEditor.checkValue(this.value, this.getEl());
        }
        if (this.type.equals("boolean")) {
            return ConfigBooleanEditor.checkValueBool(this.value);
        }
        if (this.type.equals("doubleDynamic")) {
            return ConfigMultiDynamicEditor.checkValue(this.value, null);
        }
        if (this.type.equals("tripleDynamic")) {
            return ConfigMultiDynamicEditor.checkValue(this.value, null);
        }
        return false;
    }
}

