/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractData;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractNotification;
import ru.bitel.bgbilling.modules.mobile.common.bean.PushStatusType;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobilePushToken;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobilePushTokenLink;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileRequestPushToken;
import ru.bitel.bgbilling.modules.mobile.server.dao.MobileContractDataDao;
import ru.bitel.bgbilling.modules.mobile.server.dao.MobilePushTokenDao;
import ru.bitel.bgbilling.modules.mobile.server.dao.MobilePushTokenLinkDao;
import ru.bitel.bgbilling.modules.mobile.server.manager.FireMessage;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class MobileApi
extends BGLogger
implements AutoCloseable {
    private Connection con;
    private int mid;
    private String login;
    private String pswd;
    private String urlBase;
    private int pushType = 0;
    private MobileContractDataDao dataDao;
    private String androidUrl = null;
    private String androidKey = null;
    private boolean useAndroidAccountForiOSPush = true;
    private String iosUrl = null;
    private String iosKey = null;
    private String defTitle = null;
    private MobilePushTokenDao pushTokenDao;
    private MobilePushTokenLinkDao linkDao;

    public MobileApi(ParameterMap setup, Connection con, int moduleId) throws BGException {
        this.con = con;
        this.mid = moduleId;
        if (con == null) {
            throw new BGMessageException("Connection is NULL !");
        }
        this.pushType = setup.getInt("push.type", 0);
        if (this.pushType == 0) {
            this.login = setup.get("push.login", null);
            this.pswd = setup.get("push.pswd", null);
            this.urlBase = setup.get("push.url", "https://bgbpush.ru/mob/");
            if (Utils.isBlankString((String)this.login) || Utils.isBlankString((String)this.pswd) || Utils.isBlankString((String)this.urlBase)) {
                throw new BGMessageException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044e \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u043f\u0443\u0448 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439.");
            }
        } else {
            this.androidUrl = setup.get("push.myself.android.url", null);
            this.androidKey = setup.get("push.myself.android.key", null);
            this.useAndroidAccountForiOSPush = setup.getBoolean("push.myself.ios.use.android.account", true);
            this.iosUrl = setup.get("push.myself.ios.url", null);
            this.iosKey = setup.get("push.myself.ios.key", null);
            this.defTitle = setup.get("push.myself.title", "");
        }
    }

    private MobileContractDataDao getDataDao() {
        if (this.dataDao == null) {
            this.dataDao = new MobileContractDataDao(this.con, this.mid);
        }
        return this.dataDao;
    }

    private MobilePushTokenDao getPushTokenDao() {
        if (this.pushTokenDao == null) {
            this.pushTokenDao = new MobilePushTokenDao(this.con, this.mid);
        }
        return this.pushTokenDao;
    }

    private MobilePushTokenLinkDao getLinkDao() {
        if (this.linkDao == null) {
            this.linkDao = new MobilePushTokenLinkDao(this.con, this.mid);
        }
        return this.linkDao;
    }

    public void subscribeToPushNotification(MobileRequestPushToken pushToken) throws Exception {
        this.pushNotificationSubscribeUpdate(pushToken, true);
    }

    public void unsubscribeToPushNotification(MobileRequestPushToken pushToken) throws Exception {
        this.pushNotificationSubscribeUpdate(pushToken, false);
    }

    private void pushNotificationSubscribeUpdate(MobileRequestPushToken requestToken, boolean subscribe) throws Exception {
        try {
            int tokenId = -1;
            int statusAfterReject = PushStatusType.NOT_SUCCESS_DEVICE_REJECTED.getCode();
            if (this.pushType > 0) {
                MobilePushToken pushToken = this.getPushTokenDao().getByToken(requestToken.getToken(), requestToken.getType());
                if (subscribe) {
                    if (pushToken == null) {
                        pushToken = new MobilePushToken();
                        pushToken.setToken(requestToken.getToken());
                        pushToken.setType(requestToken.getType());
                    }
                    pushToken.setLastConfirmDate(new Date());
                    pushToken.setRejected(0);
                    this.getPushTokenDao().update((Object)pushToken);
                    tokenId = pushToken.getId();
                    MobilePushTokenLink link = this.getLinkDao().getToken(requestToken.getContractId(), pushToken.getId());
                    if (link == null) {
                        link = new MobilePushTokenLink();
                        link.setContractId(requestToken.getContractId());
                        link.setTokenId(pushToken.getId());
                        this.getLinkDao().update((Object)link);
                    }
                } else if (pushToken != null && pushToken.getId() > 0) {
                    pushToken.setRejected(2);
                    pushToken.setRejectedDate(new Date());
                    this.getPushTokenDao().update((Object)pushToken);
                    for (MobilePushTokenLink link : this.getLinkDao().getListByContractId(requestToken.getContractId())) {
                        MobilePushToken token = (MobilePushToken)this.getPushTokenDao().get(link.getTokenId());
                        if (token == null || token.isRejected()) continue;
                        statusAfterReject = PushStatusType.SUCCESS.getCode();
                    }
                }
            } else {
                HttpURLConnection conn = this.getConnection("token/" + (subscribe ? "updateToken/" : "unsubscribeToken"));
                ObjectMapper mapper = new ObjectMapper();
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                mapper.writeValue((Writer)wr, (Object)requestToken);
                int responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    this.getLogger().error("HTTP ERROR " + responseCode + " while subscribe push notification");
                    return;
                }
                try {
                    String answer = this.getResultRequest(conn);
                    if (subscribe) {
                        Map map = (Map)mapper.readValue(answer, (TypeReference)new TypeReference<Map<String, String>>(){});
                        tokenId = Utils.parseInt((String)((String)map.get("id")), (int)-1);
                    }
                    statusAfterReject = Utils.parseInt((String)answer, (int)PushStatusType.NOT_SUCCESS_DEVICE_REJECTED.getCode());
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            MobileContractData contractData = this.getDataDao().getContractData(requestToken.getContractId());
            if (contractData == null) {
                contractData = new MobileContractData();
                contractData.setContractId(requestToken.getContractId());
            }
            if (subscribe) {
                requestToken.setId(tokenId);
                contractData.setStatus(PushStatusType.SUCCESS);
                contractData.setLastConfirmDate(new Date());
            } else {
                contractData.setStatus(PushStatusType.getByCode((int)statusAfterReject));
            }
            this.getDataDao().update(contractData);
        }
        catch (IOException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeLink(int contractId, String pushToken) throws Exception {
        if (contractId < 1 || Utils.isBlankString((String)pushToken)) {
            throw new BGMessageException("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        }
        MobileContractData contractData = this.getDataDao().getContractData(contractId);
        PushStatusType newStatus = PushStatusType.NOT_SUCCESS_DEVICE_REJECTED;
        if (this.pushType > 0) {
            MobilePushToken mobilePushToken = this.getPushTokenDao().getByToken(pushToken, -1);
            if (mobilePushToken != null) {
                for (MobilePushTokenLink link : this.getLinkDao().getListByContractId(contractId)) {
                    if (link.getTokenId() != mobilePushToken.getId()) continue;
                    this.getLinkDao().delete(link.getId());
                }
                for (MobilePushTokenLink link : this.getLinkDao().getListByContractId(contractId)) {
                    MobilePushToken token = (MobilePushToken)this.getPushTokenDao().get(link.getTokenId());
                    if (token == null) {
                        this.getLinkDao().delete(link.getId());
                        continue;
                    }
                    if (token.isRejected()) continue;
                    newStatus = PushStatusType.SUCCESS;
                    break;
                }
            }
        } else {
            try {
                HttpURLConnection conn = this.getConnection("token/removeLink/");
                conn.setRequestProperty("token", pushToken);
                conn.setRequestProperty("contractId", "" + contractId);
                int responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    this.getLogger().error("HTTP ERROR " + responseCode + " while remove Link: contractId=" + contractId + "  token=" + pushToken);
                }
                int result = Utils.parseInt((String)this.getResultRequest(conn), (int)-99);
                if (result == -99) {
                    this.getLogger().error("Incorrect response on remove link");
                }
                newStatus = PushStatusType.getByCode((int)result);
            }
            catch (IOException ex) {
                this.logError(ex);
            }
        }
        if (newStatus != contractData.getStatus()) {
            contractData.setStatus(newStatus);
            this.getDataDao().update(contractData);
        }
    }

    public PushStatusType sendPushNotification(MobileContractNotification notification) throws BGException {
        try {
            PushStatusType status;
            int contractId = notification.getContractId();
            if (!this.checkPossibilitySending(contractId)) {
                return PushStatusType.NOT_SUCCESS_NOT_VALID_TOKEN;
            }
            if (notification.getText().length() > 1024) {
                return PushStatusType.NOT_SUCCESS_NOT_VALID_PARAMS;
            }
            if (this.pushType > 0) {
                status = this.sendFromSelf(notification);
            } else {
                HttpURLConnection conn = this.getConnection("push/sendNotification/");
                ObjectMapper mapper = new ObjectMapper();
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                mapper.writeValue((Writer)wr, (Object)notification);
                int responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    this.getLogger().error("HTTP ERROR " + responseCode + " while sending push notification");
                    return PushStatusType.NOT_SUCCESS_HTTP_ERROR;
                }
                try {
                    Map map = (Map)mapper.readValue(this.getResultRequest(conn), (TypeReference)new TypeReference<Map<String, String>>(){});
                    status = PushStatusType.getByCode((int)Utils.parseInt((String)((String)map.get("status")), (int)PushStatusType.NOT_DEFINED.getCode()));
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Status sending = " + status + "  cid - " + contractId);
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                    return PushStatusType.NOT_DEFINED;
                }
            }
            MobileContractData contractData = this.getDataDao().getContractData(contractId);
            contractData.setStatus(status);
            contractData.setCountNotification(contractData.getCountNotification() + 1);
            contractData.setLastSendDate(new Date());
            this.getDataDao().update(contractData);
            return status;
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    private PushStatusType sendFromSelf(MobileContractNotification notification) throws Exception {
        PushStatusType status = PushStatusType.NOT_SUCCESS_NOT_VALID_TOKEN;
        for (MobilePushTokenLink link : this.getLinkDao().getListByContractId(notification.getContractId())) {
            PushStatusType statusToken;
            MobilePushToken token = (MobilePushToken)this.getPushTokenDao().get(link.getTokenId());
            if (token == null) {
                this.getLinkDao().delete(link.getId());
                continue;
            }
            if (token.isRejected()) {
                if (status.getCode() >= 0) continue;
                status = PushStatusType.NOT_SUCCESS_DEVICE_REJECTED;
                continue;
            }
            if (token.getType() != 2 && token.getType() != 1 && token.getType() != 3) {
                this.getLogger().error("Incorrect type tokenId: " + token.getId());
                continue;
            }
            if (token.getType() == 2) {
                if (Utils.isBlankString((String)this.androidKey) || Utils.isBlankString((String)this.androidUrl)) {
                    throw new BGMessageException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u043f\u0443\u0448 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439.");
                }
                statusToken = this.pushAndroid(this.defTitle, notification, token.getToken());
            } else {
                statusToken = this.pushIos(this.defTitle, notification, token.getToken(), token.getType());
            }
            if (statusToken.getCode() > status.getCode()) {
                status = statusToken;
            }
            if (PushStatusType.statusIsReachable((PushStatusType)statusToken)) continue;
            token.setRejected(1);
            this.getPushTokenDao().update((Object)token);
        }
        return status;
    }

    private HttpURLConnection getConnection(String urlPath) throws IOException {
        URL url = new URL(this.urlBase + urlPath);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/json;  charset=UTF-8");
        String encoded = Base64.getEncoder().encodeToString((this.login + ":" + this.pswd).getBytes(StandardCharsets.UTF_8));
        conn.setRequestProperty("Authorization", "Basic " + encoded);
        return conn;
    }

    private PushStatusType pushAndroid(String title, MobileContractNotification notification, String token) {
        FireMessage f = new FireMessage(this.androidKey, this.androidUrl, title, notification, 2);
        String result = f.sendToToken(token);
        if ("SUCCESS".equals(result)) {
            return PushStatusType.SUCCESS;
        }
        this.getLogger().error("Android push, NOT SUCCESS. Status - " + result + " token = " + token);
        return PushStatusType.NOT_SUCCESS_INTERNAL_ERROR;
    }

    private PushStatusType pushIos(String title, MobileContractNotification notification, String token, int type) throws BGMessageException {
        String result = "";
        if (3 == type) {
            FireMessage f;
            String key = this.iosKey;
            String url = this.iosUrl;
            if (this.useAndroidAccountForiOSPush) {
                if (Utils.isBlankString((String)this.androidKey) || Utils.isBlankString((String)this.androidUrl)) {
                    throw new BGMessageException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u043f\u0443\u0448 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439.");
                }
                key = this.androidKey;
                url = this.androidUrl;
            }
            if ("SUCCESS".equals(result = (f = new FireMessage(key, url, title, notification, 3)).sendToToken(token))) {
                return PushStatusType.SUCCESS;
            }
        } else if (Utils.isBlankString((String)this.iosKey) || Utils.isBlankString((String)this.iosUrl)) {
            return PushStatusType.NOT_SUCCESS_NOT_VALID_PARAMS;
        }
        this.getLogger().error("IOS push, NOT SUCCESS. Status - " + result + " token = " + token);
        return PushStatusType.NOT_SUCCESS_INTERNAL_ERROR;
    }

    public PushStatusType sendPushNotification(int contractId, String text) throws BGException {
        MobileContractNotification notification = new MobileContractNotification();
        notification.setContractId(contractId);
        notification.setText(text);
        notification.setStorable(false);
        return this.sendPushNotification(notification);
    }

    public boolean checkPossibilitySending(int contractId) throws BGException {
        MobileContractData contractData = this.getDataDao().getContractData(contractId);
        return contractData != null && PushStatusType.statusIsReachable((PushStatusType)contractData.getStatus());
    }

    private String getResultRequest(HttpURLConnection conn) throws UnsupportedEncodingException, IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        StringBuilder builder = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            builder.append(inputLine);
        }
        in.close();
        return builder.toString();
    }

    @Override
    public void close() throws BGException {
        if (this.dataDao != null) {
            this.dataDao.close();
        }
    }
}

