/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforeRequestEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class QuickPayTransactionManager
extends MPSTransactionManager {
    private static final String TIMEPATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(.+)\\t(\\d+)\\t([\\d+: -T]+)\\t(\\d+\\.*\\d*)\\t(\\d+)$", 8);

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            MPSBeforeRequestEvent event = new MPSBeforeRequestEvent(moduleId, mpsRequest, mpsResponse);
            EventProcessor.getInstance().request((QueueEvent)event);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            mpsResponse.getParameters().put("request", mpsRequest);
            switch (mpsRequest.getAction()) {
                case 1: {
                    Contract contract = this.actionCheck(mpsRequest);
                    mpsResponse.setContract(contract);
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    break;
                }
                case 2: 
                case 10: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        Contract contract = this.actionCheck(mpsRequest);
                        this.checkTime(mpsRequest);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                        mpsResponse.setContract(contract);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    } else {
                        Contract contract = new ContractManager(con).getContractById(transaction.getContractId());
                        if (contract != null) {
                            mpsResponse.setContract(contract);
                            mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        }
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    break;
                }
                case 4: {
                    GregorianCalendar now = new GregorianCalendar();
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    if (transaction == null) {
                        mpsResponse.setResult(4);
                        mpsResponse.setMessage("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435  \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                        break;
                    }
                    ((Calendar)now).add(12, -10);
                    if (transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode()) && now.after(transaction.getLocalTime())) {
                        mpsResponse.setResult(9);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        break;
                    }
                    this.cancelTransaction(con, moduleId, mpsId, system, transaction);
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                    break;
                }
                case 3: {
                    GregorianCalendar now = new GregorianCalendar();
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    if (transaction == null) {
                        now.set(5, 1);
                        ((Calendar)now).add(2, -1);
                        transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    }
                    if (transaction == null) {
                        mpsResponse.setResult(6);
                        mpsResponse.setMessage("\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        break;
                    }
                    if (!transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(7);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                    } else {
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    break;
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        MPSRequest mpsRequest = new MPSRequest(con, moduleId, mpsId, request, system);
        String action = request.getParameter("action");
        if ("check".equals(action)) {
            mpsRequest.setAction(1);
            mpsRequest.setRawNumber(request.getParameter("number"));
            mpsRequest.setNumber(mpsRequest.getRawNumber());
            mpsRequest.setType(Utils.parseInt((String)request.getParameter("type"), (int)0));
        } else if ("payment".equals(action)) {
            mpsRequest.setAction(2);
            mpsRequest.setRawNumber(request.getParameter("number"));
            mpsRequest.setNumber(mpsRequest.getRawNumber());
            mpsRequest.setType(Utils.parseInt((String)request.getParameter("type"), (int)0));
            mpsRequest.setSum(Utils.parseBigDecimal((String)request.getParameter("amount"), (BigDecimal)BigDecimal.ZERO));
            mpsRequest.setTransId(request.getParameter("receipt"));
            mpsRequest.setTime(TimeUtils.parseDate((String)request.getParameter("date"), (String)TIMEPATTERN));
        } else if ("cancel".equals(action)) {
            mpsRequest.setAction(4);
            mpsRequest.setTransId(request.getParameter("receipt"));
        } else if ("status".equals(action)) {
            mpsRequest.setAction(3);
            mpsRequest.setTransId(request.getParameter("receipt"));
        }
        return mpsRequest;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(1);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(2);
                response.setMessage(ex.message);
                break;
            }
            case 5: {
                response.setResult(6);
                response.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                break;
            }
            case 6: {
                response.setResult(5);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(3);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(10);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(11);
                response.setMessage(ex.message);
                break;
            }
            case 4: {
                response.setResult(12);
                response.setMessage(ex.message);
                break;
            }
            case 12: {
                response.setResult(1);
                response.setMessage(ex.message);
                break;
            }
            case 15: {
                response.setResult(8);
                response.setMessage(ex.message);
                break;
            }
            case 16: {
                response.setResult(5);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = TRANSACTION_PATTERN.matcher(file);
        while (match.find()) {
            String number = match.group(1);
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setNumber(number).setRawNumber(number).setTime(TimeUtils.parseDate((String)match.group(3), (String)TIMEPATTERN)).setSum(Utils.parseBigDecimal((String)match.group(4), (BigDecimal)BigDecimal.ZERO))).setTransId(Utils.parseLong((String)match.group(5), (long)0L)).setStatus(TransactionStatus.PAYMENT_PAYED.getCode())).build();
            result.add(transaction);
        }
        return result;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element responseElement = XMLUtils.createElement((Document)doc, (String)"response");
        this.processResponseEvent(response, responseElement);
        XMLUtils.createElement((Element)responseElement, (String)"code").setTextContent(String.valueOf(response.getResult()));
        if (response.getAction() == 2 || response.getAction() == 4 || response.getAction() == 3) {
            if (response.getResult() == 0 || response.getResult() == 7 && response.getAction() == 3) {
                XMLUtils.createElement((Element)responseElement, (String)"authcode").setTextContent(String.valueOf(response.getId()));
            }
            XMLUtils.createElement((Element)responseElement, (String)"date").setTextContent(TimeUtils.format((Date)response.getLocalTime(), (String)TIMEPATTERN));
        }
        if (response.getMessage() != null) {
            XMLUtils.createElement((Element)responseElement, (String)"message").setTextContent(response.getMessage());
        }
        this.setResponseParameters(response, responseElement);
        return this.xmlSerialize(doc);
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest mpsRequest, Connection con) throws MPSException {
        switch (mpsRequest.getAction()) {
            case 1: {
                if (mpsRequest.getNumber() == null || mpsRequest.getNumber().length() <= 0) {
                    throw new MPSException(2);
                }
                if ((mpsRequest.getType() >= 0 || system.searchTypes.length <= 1) && mpsRequest.getType() < system.searchTypes.length) break;
                throw new MPSException(12, "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u0438\u0441\u043a\u0430");
            }
            case 2: {
                if (mpsRequest.getTransId() == null || this.parseBigInteger(mpsRequest.getTransId()).compareTo(BigInteger.ZERO) <= 0) {
                    throw new MPSException(15, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u0442\u043d\u043e\u0435/\u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438)");
                }
                if (mpsRequest.getTime() == null) {
                    throw new MPSException(16);
                }
                if (mpsRequest.getNumber() == null || mpsRequest.getNumber().length() <= 0) {
                    throw new MPSException(2);
                }
                if (mpsRequest.getType() < 0 && system.searchTypes.length > 1 || mpsRequest.getType() >= system.searchTypes.length) {
                    throw new MPSException(12, "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u0438\u0441\u043a\u0430");
                }
                if (mpsRequest.getSum() != null && (system.extDontCheckSum || mpsRequest.getSum().compareTo(BigDecimal.ZERO) > 0)) break;
                throw new MPSException(8, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
            }
            case 3: 
            case 4: {
                if (mpsRequest.getTransId() != null && this.parseBigInteger(mpsRequest.getTransId()).compareTo(BigInteger.ZERO) > 0) break;
                throw new MPSException(15, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u0442\u043d\u043e\u0435/\u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438)");
            }
        }
        super.checkValid(system, mpsRequest, con);
    }

    private class ResponseCode {
        protected static final int CODE_OK = 0;
        protected static final int CODE_ERROR_TYPE_ACTION = 1;
        protected static final int CODE_ERROR_PHONE = 2;
        protected static final int CODE_ERROR_SUMMA = 3;
        protected static final int CODE_ERROR_NUMBER = 4;
        protected static final String MESSAGE_ERROR_NUMBER = "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435  \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430";
        protected static final int CODE_ERROR_DATE = 5;
        protected static final int CODE_ERROR_PAY_NOT_FOUND = 6;
        protected static final String MESSAGE_ERROR_PAY_NOT_FOUND = "\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
        protected static final int CODE_ERROR_PAY_CANCEL = 7;
        protected static final String MESSAGE_ERROR_PAY_CANCEL = "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043e\u0442\u043c\u0435\u043d\u0435\u043d";
        protected static final int CODE_ERROR_PAY_UNDEFINED = 8;
        protected static final int CODE_ERROR_PAY_NOT_CANCEL = 9;
        protected static final String MESSAGE_ERROR_PAY_NOT_CANCEL = "\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u0435\u043d";

        private ResponseCode() {
        }
    }
}

