/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.pscb.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.pscb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.pscb.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "pscb_payment");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("transactionDate", "datetime");
        this.fields.put("sum", "sum");
    }

    public void searchTransactions(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws SQLException {
        ResultSet rs;
        int index;
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT p.*, c.title FROM " + this.tableName + " p");
        query.append(" LEFT JOIN contract c ON c.id=p.contractId");
        StringBuilder whereClause = new StringBuilder(" WHERE 1=1 ");
        if (contractId > 0) {
            whereClause.append("AND p.contractId=" + contractId + " ");
        }
        if (Utils.notBlankString((String)contractTitle)) {
            whereClause.append("AND c.title LIKE ? ");
        }
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            whereClause.append("AND p.status=?");
        }
        if (period != null) {
            if (period.getDateFrom() != null) {
                whereClause.append("AND p.datetime>=? ");
            }
            if (period.getDateTo() != null) {
                whereClause.append("AND p.datetime<? ");
            }
        }
        query.append((CharSequence)whereClause);
        if (sort != null) {
            query.append(this.getSQLOrder(sort, this.fields));
        }
        if (page != null) {
            query.append(page.sqlLimit());
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            index = 1;
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                ps.setString(index++, status);
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        query = new StringBuilder("SELECT SUM(p.sum) AS sum, COUNT(*) as count FROM " + this.tableName + " p");
        query.append(" LEFT JOIN contract c ON c.id=p.contractId");
        query.append((CharSequence)whereClause);
        ps = this.con.prepareStatement(query.toString());
        try {
            index = 1;
            if (Utils.notBlankString((String)contractTitle)) {
                ps.setString(index++, "%" + contractTitle + "%");
            }
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                ps.setString(index++, status);
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    BigDecimal sum;
                    if (page != null) {
                        page.setRecordCount(rs.getInt("count"));
                    }
                    if ((sum = rs.getBigDecimal("sum")) == null) continue;
                    searchResult.setSum(sum);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public Transaction getTransactionById(int transactionId) throws BGException {
        Transaction result = null;
        String query = "SELECT p.*, c.title FROM " + this.tableName + " p LEFT JOIN contract c ON c.id = p.contractId WHERE p.id=" + transactionId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "status=?, contractId=?, datetime=NOW(), sum=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setString(index++, transaction.getStatus());
            ps.setInt(index++, transaction.getContractId());
            ps.setBigDecimal(index++, transaction.getSum());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public void deleteTransactionById(int transactionId) throws SQLException {
        this.delete("id=?", new Object[]{transactionId});
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("p.id"))).setContractId(rs.getInt("p.contractId"))).setContractTitle(rs.getString("c.title"))).setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("p.datetime")))).setSum(rs.getBigDecimal("p.sum"))).setStatus(rs.getString("p.status"))).build();
    }
}

