/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.bill.common.bean.BillAccountsReceivable;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class BillAccountsReceivableManager
extends BGLogger {
    private int moduleId = 0;
    private Connection con = null;

    public BillAccountsReceivableManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
    }

    public void searchBillAccountsReceivable(SearchResult<BillAccountsReceivable> searchResult, LocalDate onDate) throws Exception {
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        String uuid = UUID.randomUUID().toString().replace('-', '_');
        String tableNameContractIdTmp = "bill_contract_" + uuid;
        String query = "CREATE TEMPORARY TABLE " + tableNameContractIdTmp + " SELECT id, title, comment FROM contract WHERE fc=1 AND date1<=? AND (date2 IS NULL OR date2>=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.executeUpdate();
        }
        String tableNamePaymentTmp = "bill_payment_" + uuid;
        query = "CREATE TEMPORARY TABLE " + tableNamePaymentTmp + " SELECT cid AS contract_id, sum(summa) AS payment_sum FROM contract_payment WHERE dt<=? AND cid IN ( SELECT id FROM " + tableNameContractIdTmp + " ) GROUP BY cid";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.executeUpdate();
        }
        String tableNameBillTmp = "bill_" + uuid;
        query = "CREATE TEMPORARY TABLE " + tableNameBillTmp + " SELECT cid AS contract_id, sum(summ) AS bill_sum FROM bill_data_" + this.moduleId + " WHERE create_dt<=? AND cid IN ( SELECT id FROM " + tableNameContractIdTmp + " ) GROUP BY cid";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.executeUpdate();
        }
        query = "SELECT c.*, (IFNULL(b.bill_sum, 0) - IFNULL(p.payment_sum, 0)) AS dsum FROM " + tableNameContractIdTmp + " AS c  LEFT JOIN " + tableNameBillTmp + " AS b ON c.id=b.contract_id LEFT JOIN " + tableNamePaymentTmp + " AS p ON c.id=p.contract_id HAVING dsum > 0 ORDER BY dsum desc " + page.sqlLimit();
        ps = this.con.prepareStatement(query);
        try (ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                list.add(new BillAccountsReceivable().setContractId(rs.getInt("id")).setContractTitle(rs.getString("title")).setContractComment(rs.getString("comment")).setSum(rs.getBigDecimal("dsum")));
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        HashMap<Integer, ArrayList<BillData>> billMap = new HashMap<Integer, ArrayList<BillData>>();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String contractIds = list.stream().map(a -> String.valueOf(a.getContractId())).collect(Collectors.joining(", "));
        query = "SELECT cid, create_dt, format_number, summ FROM bill_data_" + this.moduleId + " WHERE create_dt<=? AND create_dt>? AND cid IN ( " + contractIds + " ) ORDER BY cid, create_dt desc";
        try (Object ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate.minusMonths(12L)));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int contractId = rs.getInt("cid");
                    ArrayList<BillData> billDatas = (ArrayList<BillData>)billMap.get(contractId);
                    if (billDatas == null) {
                        billDatas = new ArrayList<BillData>();
                        billMap.put(contractId, billDatas);
                    }
                    billDatas.add(new BillData(rs.getDate("create_dt").toLocalDate(), rs.getString("format_number"), rs.getBigDecimal("summ")));
                }
            }
        }
        for (BillAccountsReceivable accountsReceivable : list) {
            List billDatas = (List)billMap.get(accountsReceivable.getContractId());
            if (billDatas == null || billDatas.isEmpty()) continue;
            BigDecimal s = accountsReceivable.getSum();
            ArrayList<BillData> dBills = new ArrayList<BillData>();
            for (BillData billData : billDatas) {
                dBills.add(billData);
                if ((s = s.subtract(billData.sum())).compareTo(BigDecimal.ZERO) >= 0) continue;
                break;
            }
            accountsReceivable.setDate(((BillData)dBills.get((int)(dBills.size() - 1))).createDate);
            accountsReceivable.setBills(dBills.stream().map(a -> "\u2116" + a.formatNumber + " \u043e\u0442 " + dateTimeFormatter.format(a.createDate)).collect(Collectors.joining("; ")));
        }
        query = "DROP TABLE IF EXISTS " + tableNameContractIdTmp + ", " + tableNamePaymentTmp + ", " + tableNameBillTmp;
        ps = this.con.prepareStatement(query);
        try {
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private record BillData(LocalDate createDate, String formatNumber, BigDecimal sum) {
    }
}

