/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Dealer;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.DealerService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class ServiceConfigManagerDealer
extends BGUPanel {
    private BGControlPanelPeriod period = new BGControlPanelPeriod();
    private JTextField title = new JTextField();
    private JTextArea comment = new JTextArea();
    private BGControlPanelPeriod periodFilter = new BGControlPanelPeriod();
    private JTextField titleFilter = new JTextField();
    private JPanel editor = new JPanel();
    private BGUTable table;
    private BGTableModel<Dealer> model = new BGTableModel<Dealer>("Dealer"){

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 230, 230, -1, "title", false);
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", String.class, 180, 180, -1, null, false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 350, 350, -1, "comment", false);
        }

        public Object getValue(Dealer val, int column) throws Exception {
            if (column == 2) {
                return TimeUtils.formatPeriod((Date)val.getDate1(), (Date)val.getDate2());
            }
            return super.getValue((Object)val, column);
        }
    };
    private Dealer id;

    public ServiceConfigManagerDealer() {
        this.table = new BGUTable(this.model);
        this.setLayout(new GridBagLayout());
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.editor.setLayout(new GridBagLayout());
        JPanel namePanel = new JPanel(new GridBagLayout());
        namePanel.setBorder((Border)new BGTitleBorder("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"));
        this.title.setMinimumSize(new Dimension(200, 25));
        this.title.setPreferredSize(new Dimension(200, 25));
        JPanel commentPanel = new JPanel(new GridBagLayout());
        this.comment.setLineWrap(true);
        this.comment.setWrapStyleWord(true);
        this.editor.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        jPanel1.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        this.titleFilter.setMinimumSize(new Dimension(220, 25));
        this.titleFilter.setPreferredSize(new Dimension(220, 25));
        this.titleFilter.setColumns(20);
        jPanel9.setBorder((Border)new BGTitleBorder("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"));
        BGButton bGButton1 = new BGButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        bGButton1.addActionListener(e -> this.performAction("refresh"));
        BGButton bGButton2 = new BGButton("\u0421\u0431\u0440\u043e\u0441");
        bGButton2.addActionListener(e -> {
            this.titleFilter.setText("");
            this.periodFilter.setDateCalendar1(null);
            this.periodFilter.setDateCalendar2(null);
        });
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        okCancelPanel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            if ("ok".equals(actionCommand)) {
                this.performAction("okCancel_Save");
            } else {
                this.editor.setVisible(false);
            }
        });
        ClientUtils.addOpenAction((Component)this.table, e -> this.performAction("edit"));
        this.add(jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add(jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        namePanel.add((Component)this.title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel1.add((Component)this.periodFilter, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)jPanel9, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel9.add((Component)this.titleFilter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel1.add((Component)bGButton1, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 5, 3, 5), 0, 0));
        jPanel1.add((Component)bGButton2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 5, 3, 5), 0, 0));
        commentPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)namePanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        commentPanel.setBorder((Border)new BGTitleBorder("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        this.editor.add((Component)commentPanel, new GridBagConstraints(3, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.period, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.add((Component)okCancelPanel, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.setVisible(false);
    }

    protected void jbInit() throws Exception {
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(((DealerService)((ClientContext)this.getContext()).getPort(DealerService.class)).dealerTable(this.titleFilter.getText().trim(), this.periodFilter.getDateFrom(), this.periodFilter.getDateTo()))));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.id = null;
            this.performAction("startEdit");
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.id = (Dealer)this.model.getSelectedRow();
            if (this.id != null) {
                this.performAction("startEdit");
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Dealer selectedDealer = (Dealer)this.model.getSelectedRow();
            if (selectedDealer != null && ClientUtils.confirmDelete((Object)"\u0434\u0438\u043b\u0435\u0440\u0430")) {
                ((DealerService)((ClientContext)this.getContext()).getPort(DealerService.class)).deleteDealer(selectedDealer.getId());
                this.performAction("refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("startEdit", "startEdit"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (ServiceConfigManagerDealer.this.id == null) {
                    ServiceConfigManagerDealer.this.title.setText("");
                    ServiceConfigManagerDealer.this.period.setDateCalendar1((Calendar)new GregorianCalendar());
                    ServiceConfigManagerDealer.this.period.setDateCalendar2(null);
                    ServiceConfigManagerDealer.this.comment.setText("");
                } else {
                    Dealer dealer = ((DealerService)((ClientContext)ServiceConfigManagerDealer.this.getContext()).getPort(DealerService.class)).get(ServiceConfigManagerDealer.this.id.getId());
                    ServiceConfigManagerDealer.this.title.setText(dealer.getTitle());
                    ServiceConfigManagerDealer.this.period.setDateFrom(dealer.getDate1());
                    ServiceConfigManagerDealer.this.period.setDateTo(dealer.getDate2());
                    ServiceConfigManagerDealer.this.comment.setText(dealer.getComment());
                }
                ServiceConfigManagerDealer.this.editor.setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("okCancel_Save", "okCancel_Save"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (Utils.isBlankString((String)ServiceConfigManagerDealer.this.title.getText())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                    return;
                }
                Dealer dealer = new Dealer();
                dealer.setId(ServiceConfigManagerDealer.this.id != null ? ServiceConfigManagerDealer.this.id.getId() : 0);
                dealer.setTitle(ServiceConfigManagerDealer.this.title.getText());
                dealer.setDate1(ServiceConfigManagerDealer.this.period.getDateFrom());
                dealer.setDate2(ServiceConfigManagerDealer.this.period.getDateTo());
                dealer.setComment(ServiceConfigManagerDealer.this.comment.getText());
                ((DealerService)((ClientContext)ServiceConfigManagerDealer.this.getContext()).getPort(DealerService.class)).update(dealer);
                ServiceConfigManagerDealer.this.editor.setVisible(false);
                ServiceConfigManagerDealer.this.performAction("refresh");
            }
        };
    }
}

