/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.io.IOException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.norde2.Norde2Con;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class NordE2ServiceActivator
extends DigitalTVServiceActivator {
    private Norde2Con con = null;

    private Norde2Con getConnection(int serverId, UserCard userCard) throws BGException {
        ParameterMap moduleSetup = this.getModuleSetup(userCard);
        ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
        Norde2Con newconnect = new Norde2Con(connectionSetup, serverId);
        try {
            if (this.con == null) {
                this.con = newconnect;
                this.con.connect();
            } else {
                this.con.tuneconnect(newconnect);
            }
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
        return this.con;
    }

    @Override
    public void destroy() {
        if (this.con != null) {
            try {
                this.con.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.con = null;
        }
    }

    public NordE2ServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        Norde2Con con = null;
        try {
            con = this.getConnection(0, card);
            con.cancelAllChannelAuthorization(card.getNumber());
            for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : this.getCardPacketCodePairList(cardPacketList, false, true)) {
                CardPacket cardPacket = pairCardPacketPacketCode.cardpacket;
                String packetCode = pairCardPacketPacketCode.packetCode;
                Date date1 = cardPacket.getDateFrom();
                Date date2 = null;
                if (cardPacket.getDateTo() != null) {
                    date2 = cardPacket.getDateTo();
                } else {
                    date2 = this.graduallySubscriptionManager.getDate(cardPacket.getId());
                    if (date2 == null) {
                        date2 = TimeUtils.nowPlusPeriod((int)5, (int)this.periodGraduallySubscription);
                    }
                }
                con.packageAuthorization(card.getNumber(), Integer.parseInt(packetCode), date1, date2);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardNumber) throws BGException {
        this.getLogger().info("Closing card " + cardNumber);
        Norde2Con con = null;
        try {
            con = this.getConnection(0, null);
            con.cancelAllChannelAuthorization(cardNumber);
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        this.getLogger().info("Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        Norde2Con con = null;
        try {
            con = this.getConnection(0, card);
            for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : this.getCardPacketCodePairList(cardPacketList, false, true)) {
                con.cancelPackageAuthorization(card.getNumber(), Integer.parseInt(pairCardPacketPacketCode.packetCode));
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) throws BGException {
        Norde2Con con = null;
        try {
            if (cardNumbers == null) {
                con = this.getConnection(0, null);
                if (ismail) {
                    con.sendEmailToAllTheUser(title, message);
                } else {
                    con.sendOSDToAllTheUsers(title, message);
                }
            } else {
                for (Long cardNumber : cardNumbers) {
                    UserCard userCard = this.userCardManager.getUserCard((long)cardNumber, new Date());
                    con = this.getConnection(0, userCard);
                    if (ismail) {
                        con.sendSingleUserEmail(cardNumber, title, message);
                        continue;
                    }
                    con.sentOSDToASingleUser(cardNumber, title, message);
                }
            }
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            this.getLogger().error("Exception sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        Norde2Con con = null;
        try {
            con = this.getConnection(0, card);
            con.enableSmartcard(cardNumber);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            this.getLogger().error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult deactivateImpl(long cardNumber) throws BGException {
        Norde2Con con = null;
        try {
            con = this.getConnection(0, null);
            con.stopSmartcard(cardNumber);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            this.getLogger().error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }
}

