/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.norde2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Norde2Con
extends BGLogger {
    private static final String PROTOCOL_VERSION = "0020";
    private static final int REQUEST_HEADER_LENTGH = 16;
    private static final int RESPONCE_HEADER_LENTGH = 12;
    private static final String CODE_SUCCESS = "S000";
    private static final String CODE_INVALIDREQUEST = "E100";
    private static final String CODE_INVALIDSMSID = "E101";
    private static final String CODE_ERRLENGTH = "E102";
    private static final String CODE_INVALIDCODE = "E103";
    private static final String CODE_INVALIDPARAMETER = "E104";
    private static final String CODE_INVALIDCARDNUMBER = "E201";
    private static final String CODE_OTHER = "E999";
    private String host;
    private int port;
    private int timeout;
    private int smsNumber;
    private int providerId;
    private String charset;
    private String providerName;
    private int emailDurationTime = 1;
    private int emailInterval;
    private String emailFrom = null;
    private int osdTimes = 1;
    private int osdInterval;
    private String osdFrom = null;
    private boolean emailEnable;
    private boolean osdEnable;
    private Socket socket;
    private Writer writer;
    private BufferedReader reader;
    private static final int LEFT_PADDING = 1;
    private static final int RIGHT_PADDING = 2;

    private static String D(int len, long value) {
        return String.format("%1$0" + len + "d", value);
    }

    private static String H(int len, int value) {
        return String.format("%1$0" + len + "X", value);
    }

    private static int H(String value) {
        return Integer.parseInt(value, 16);
    }

    private static String A(int len, String value, int pading) {
        if (value.length() == len) {
            return value;
        }
        if (value.length() < len) {
            StringBuilder sb = new StringBuilder(len);
            if (pading == 2) {
                sb.append(value);
            }
            for (int i = 0; i < len - value.length(); ++i) {
                sb.append(" ");
            }
            if (pading == 1) {
                sb.append(value);
            }
            return sb.toString();
        }
        return value.substring(0, len);
    }

    private static String YYYYMMDDHHMM(Date date) {
        return TimeUtils.format((Date)date, (String)"yyyyMMddHHmm");
    }

    private static String YYYYMMDD(Date date) {
        return TimeUtils.format((Date)date, (String)"yyyyMMdd");
    }

    private static String CARDNO(long cardNumber) {
        return String.format("%1$ 10d", cardNumber);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Norde2Con.D(4, 14L));
        System.out.println(Norde2Con.H(4, 26));
        System.out.println(Norde2Con.A(3, "DVB", 2));
        System.out.println(Norde2Con.A(2, "DVB", 2));
        System.out.println(Norde2Con.A(4, "DVB", 2));
        System.out.println(Norde2Con.YYYYMMDDHHMM(new Date()));
        System.out.println(Norde2Con.CARDNO(12345L));
        System.out.println(new Date(4000000000000L));
        Preferences p = new Preferences();
        p.set("host", "127.0.0.1");
        p.set("port", "80");
        Norde2Con con = new Norde2Con((ParameterMap)p, 0);
        con.connect();
        con.sentOSDToASingleUser(12345L, "\u0442\u0430\u0439\u0442\u043b", "\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442");
        con.disconnect();
    }

    public Norde2Con(ParameterMap preferences, int serverId) throws BGException {
        this.host = preferences.get("host", null);
        this.port = preferences.getInt("port", 7000);
        if (Utils.isEmptyString((String)this.host) || this.port <= 0) {
            throw new BGException("Host or port for server " + serverId + " undefined!");
        }
        this.timeout = preferences.getInt("timeout", 30000);
        this.smsNumber = preferences.getInt("smsNumber", 1);
        this.providerId = preferences.getInt("providerId", 1);
        this.charset = preferences.get("charset", "ISO8859-1");
        this.providerName = preferences.get("providerName", "BiTel");
        this.emailDurationTime = preferences.getInt("emailDurationTime", 1);
        this.emailInterval = preferences.getInt("emailInterval", 1);
        this.emailFrom = preferences.get("emailFrom", null);
        this.osdTimes = preferences.getInt("osdTimes", 1);
        this.osdInterval = preferences.getInt("osdInterval", 1);
        this.osdFrom = preferences.get("osdFrom", null);
        this.emailEnable = preferences.getBoolean("emailEnable", false);
        this.osdEnable = preferences.getBoolean("osdEnable", false);
    }

    public String sendRequest(String typeCode, String request) throws BGException, IOException {
        this.$trace("sendRequest, typeCode=%s, request=%s", typeCode, request);
        this.writer.write(PROTOCOL_VERSION);
        this.writer.write(Norde2Con.H(4, request.length() + 16));
        this.writer.write(Norde2Con.D(4, this.smsNumber));
        this.writer.write(Norde2Con.A(4, typeCode, 2));
        this.writer.write(request);
        this.writer.flush();
        char[] responseHeader = new char[12];
        Utils.readFullBuffer((Reader)this.reader, (char[])responseHeader);
        this.$trace("header: %s", new String(responseHeader));
        String hVersion = new String(responseHeader, 0, 4);
        int hLenght = Norde2Con.H(new String(responseHeader, 4, 4));
        String hTypeCode = new String(responseHeader, 8, 4);
        if (!PROTOCOL_VERSION.equals(hVersion)) {
            throw new BGException("response protocol version is " + hVersion + ", not 0020");
        }
        String body = null;
        if (hLenght > 12) {
            char[] responseBody = new char[hLenght - 12];
            Utils.readFullBuffer((Reader)this.reader, (char[])responseBody);
            body = new String(responseBody);
        }
        this.$trace("body: %s", body);
        if (CODE_SUCCESS.equals(hTypeCode) || Norde2Con.A(4, typeCode, 2).equals(hTypeCode)) {
            return body;
        }
        if (CODE_INVALIDREQUEST.equals(hTypeCode)) {
            throw new BGException("E100:Invalid request");
        }
        if (CODE_INVALIDSMSID.equals(hTypeCode)) {
            throw new BGException("E101:Invalid SMS ID");
        }
        if (CODE_ERRLENGTH.equals(hTypeCode)) {
            throw new BGException("E102:Error in request packet\u2019s length");
        }
        if (CODE_INVALIDCODE.equals(hTypeCode)) {
            throw new BGException("E103:Invalid code");
        }
        if (CODE_INVALIDPARAMETER.equals(hTypeCode)) {
            throw new BGException("E104:Invalid parameter");
        }
        if (CODE_INVALIDCARDNUMBER.equals(hTypeCode)) {
            throw new BGException("E201:Invalid smartcard number");
        }
        if (CODE_OTHER.equals(hTypeCode)) {
            throw new BGException("E999:" + body);
        }
        throw new BGException("Unknown error, TypeCode=" + hTypeCode + " ,packetbody=" + body);
    }

    public void connect() throws IOException, BGException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setSoTimeout(this.timeout);
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), this.charset));
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), this.charset));
        this.connectionTest();
    }

    public void disconnect() throws Exception {
        this.reader.close();
        this.reader = null;
        this.writer.close();
        this.writer = null;
        this.socket.close();
        this.socket = null;
    }

    public void tuneconnect(Norde2Con newconnect) throws IOException, BGException {
        if (!this.host.equals(newconnect.host) || this.port != newconnect.port) {
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u043f\u0435\u0440\u0435\u043d\u0430\u0441\u0442\u0440\u0430\u0438\u0432\u0430\u0442\u044c host \u0438 port");
        }
        if (this.timeout != newconnect.timeout) {
            this.socket.setSoTimeout(newconnect.timeout);
        }
        if (!this.charset.equals(newconnect.charset)) {
            this.writer = null;
            this.reader = null;
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), newconnect.charset));
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), newconnect.charset));
        }
        this.smsNumber = newconnect.smsNumber;
        this.providerId = newconnect.providerId;
        this.providerName = newconnect.providerName;
        this.emailDurationTime = newconnect.emailDurationTime;
        this.emailInterval = newconnect.emailInterval;
        this.emailFrom = newconnect.emailFrom;
        this.osdTimes = newconnect.osdTimes;
        this.osdInterval = newconnect.osdInterval;
        this.osdFrom = newconnect.osdFrom;
        this.emailEnable = newconnect.emailEnable;
        this.osdEnable = newconnect.osdEnable;
    }

    public void connectionTest() throws BGException, IOException {
        this.$trace("connectionTest", new Object[0]);
        this.sendRequest("0100", "");
    }

    public void packageAuthorization(long cardNumber, int packageId, Date startTime, Date endTime) throws BGException, IOException {
        this.$trace("packageAuthorization, cardNumber=%s, packageId=%s, startTime=%s, endTime=%s", cardNumber, packageId, startTime, endTime);
        StringBuilder request = new StringBuilder();
        request.append(Norde2Con.CARDNO(cardNumber));
        request.append(Norde2Con.D(4, packageId));
        request.append(Norde2Con.YYYYMMDD(startTime));
        request.append(Norde2Con.YYYYMMDD(endTime));
        this.sendRequest("0301", request.toString());
    }

    public void cancelPackageAuthorization(long cardNumber, int packageId) throws BGException, IOException {
        this.$trace("cancelPackageAuthorization, cardNumber=%s, packageId=%s", cardNumber, packageId);
        StringBuilder request = new StringBuilder();
        request.append(Norde2Con.CARDNO(cardNumber));
        request.append(Norde2Con.D(4, packageId));
        this.sendRequest("0302", request.toString());
    }

    public void sendSingleUserEmail(long cardNumber, String title, String message) throws BGException, IOException {
        this.$trace("sendSingleUserEmail, cardNumber=%s, title=%s, message=%s (emailEnable=%b)", cardNumber, title, message, this.emailEnable);
        if (this.emailEnable) {
            StringBuilder request = new StringBuilder();
            request.append(Norde2Con.YYYYMMDDHHMM(new Date()));
            request.append(Norde2Con.D(1, this.emailDurationTime));
            request.append(Norde2Con.D(4, this.emailInterval));
            request.append(Norde2Con.CARDNO(cardNumber));
            request.append(Norde2Con.A(10, title, 1));
            request.append(Norde2Con.A(20, this.emailFrom, 1));
            request.append(message);
            this.sendRequest("0403", request.toString());
        }
    }

    public void sendEmailToAllTheUser(String title, String message) throws BGException, IOException {
        this.$trace("sendEmailToAllTheUser, title=%s, message=%s (emailEnable=%b)", title, message, this.emailEnable);
        if (this.emailEnable) {
            StringBuilder request = new StringBuilder();
            request.append(Norde2Con.YYYYMMDDHHMM(new Date()));
            request.append(Norde2Con.D(1, this.emailDurationTime));
            request.append(Norde2Con.D(4, this.emailInterval));
            request.append(Norde2Con.A(10, title, 1));
            request.append(Norde2Con.A(20, this.emailFrom, 1));
            request.append(message);
            this.sendRequest("0404", request.toString());
        }
    }

    public void sentOSDToASingleUser(long cardNumber, String title, String message) throws BGException, IOException {
        this.$trace("sentOSDToASingleUser, cardNumber=%s, title=%s, message=%s (osdEnable=%b)", cardNumber, title, message, this.osdEnable);
        if (this.osdEnable) {
            StringBuilder request = new StringBuilder();
            request.append(Norde2Con.YYYYMMDDHHMM(new Date()));
            request.append(Norde2Con.D(4, this.osdTimes));
            request.append(Norde2Con.D(4, this.osdInterval));
            request.append(Norde2Con.CARDNO(cardNumber));
            request.append(Norde2Con.A(10, title, 1));
            request.append(Norde2Con.A(20, this.osdFrom, 1));
            request.append(message);
            this.sendRequest("0413", request.toString());
        }
    }

    public void sendOSDToAllTheUsers(String title, String message) throws BGException, IOException {
        this.$trace("sendOSDToAllTheUsers, title=%s, message=%s (osdEnable=%b)", title, message, this.osdEnable);
        if (this.osdEnable) {
            StringBuilder request = new StringBuilder();
            request.append(Norde2Con.YYYYMMDDHHMM(new Date()));
            request.append(Norde2Con.D(4, this.osdTimes));
            request.append(Norde2Con.D(4, this.osdInterval));
            request.append(Norde2Con.A(10, title, 1));
            request.append(Norde2Con.A(20, this.osdFrom, 1));
            request.append(message);
            this.sendRequest("0414", request.toString());
        }
    }

    public void cancelAllChannelAuthorization(long cardNumber) throws BGException, IOException {
        this.$trace("cancelAllChannelAuthorization, cardNumber=%s", cardNumber);
        StringBuilder request = new StringBuilder();
        request.append(Norde2Con.CARDNO(cardNumber));
        request.append(Norde2Con.D(1, this.providerId));
        this.sendRequest("0392", request.toString());
    }

    public void enableSmartcard(long cardNumber) throws BGException, IOException {
        this.$trace("enableSmartcard, cardNumber=%s", cardNumber);
        StringBuilder request = new StringBuilder();
        request.append(Norde2Con.CARDNO(cardNumber));
        request.append(Norde2Con.D(1, this.providerId));
        request.append(Norde2Con.A(30, this.providerName, 2));
        this.sendRequest("0201", request.toString());
    }

    public void stopSmartcard(long cardNumber) throws BGException, IOException {
        this.$trace("stopSmartcard, cardNumber=%s", cardNumber);
        StringBuilder request = new StringBuilder();
        request.append(Norde2Con.CARDNO(cardNumber));
        request.append(Norde2Con.D(1, this.providerId));
        this.sendRequest("0203", request.toString());
    }

    private void $trace(String format, Object ... args) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("Norde2Con: " + String.format(format, args));
        }
    }
}

