/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCallManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class RegisterProblemManager
extends BGLogger {
    private Connection con;

    public RegisterProblemManager(Connection con) {
        this.con = con;
    }

    public void updateProblem(RegisterProblem problem, int userId) {
        if (problem != null) {
            String query = null;
            PreparedStatement ps = null;
            try {
                int index = 1;
                if (problem.getId() < 0) {
                    query = "INSERT INTO register_problem SET open_dt=?, open_uid=?, status_dt=?, status_uid=?, close_dt=?, close_uid=?, status=?, urgency=?, comment=?, resolution=?, cat=?, gr=?";
                    ps = this.con.prepareStatement(query, 1);
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)problem.getOpenTime()));
                    ps.setInt(index++, problem.getOpenUserId());
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)problem.getStatusTime()));
                    ps.setInt(index++, problem.getStatusUserId());
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)problem.getCloseTime()));
                    ps.setInt(index++, problem.getCloseUserId());
                    ps.setInt(index++, problem.getStatus());
                    ps.setInt(index++, problem.getUrgency());
                    ps.setString(index++, problem.getComment());
                    ps.setString(index++, problem.getResolution());
                    ps.setInt(index++, problem.getCategoryId());
                    ps.setInt(index++, problem.getGroupId());
                } else {
                    query = "UPDATE register_problem SET status_dt=?, status_uid=?, close_dt=?, close_uid=?, status=?, urgency=?, comment=?, resolution=?, cat=?, gr=?, task_list=? WHERE id=? AND (status_dt<>? OR status_uid<>? OR close_dt<>? OR close_uid<>? OR status<>? OR urgency<>? OR comment<>? OR resolution<>? OR cat<>? OR gr<>? OR task_list<>?)";
                    ps = this.con.prepareStatement(query);
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)problem.getStatusTime()));
                    ps.setInt(index++, problem.getStatusUserId());
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)problem.getCloseTime()));
                    ps.setInt(index++, problem.getCloseUserId());
                    ps.setInt(index++, problem.getStatus());
                    ps.setInt(index++, problem.getUrgency());
                    ps.setString(index++, problem.getComment());
                    ps.setString(index++, problem.getResolution());
                    ps.setInt(index++, problem.getCategoryId());
                    ps.setInt(index++, problem.getGroupId());
                    ps.setString(index++, Utils.toString((Iterable)problem.getTasks()));
                    ps.setInt(index++, problem.getId());
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)problem.getStatusTime()));
                    ps.setInt(index++, problem.getStatusUserId());
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)problem.getCloseTime()));
                    ps.setInt(index++, problem.getCloseUserId());
                    ps.setInt(index++, problem.getStatus());
                    ps.setInt(index++, problem.getUrgency());
                    ps.setString(index++, problem.getComment());
                    ps.setString(index++, problem.getResolution());
                    ps.setInt(index++, problem.getCategoryId());
                    ps.setInt(index++, problem.getGroupId());
                    ps.setString(index++, Utils.toString((Iterable)problem.getTasks()));
                }
                if (ps.executeUpdate() > 0) {
                    if (problem.getId() < 0) {
                        problem.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                    }
                    this.updateProblemLog(problem, userId);
                }
                ps.close();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    private void updateProblemLog(RegisterProblem problem, int userId) throws Exception {
        if (problem != null) {
            String query = "INSERT INTO register_problem_log SET id=?, change_dt=?, change_uid=?, status_dt=?, status_uid=?, status=?, urgency=?, comment=?, resolution=?, cat=?, gr=?, exec=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, problem.getId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)new java.util.Date()));
                ps.setInt(index++, userId);
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)problem.getStatusTime()));
                ps.setInt(index++, problem.getStatusUserId());
                ps.setInt(index++, problem.getStatus());
                ps.setInt(index++, problem.getUrgency());
                ps.setString(index++, problem.getComment());
                ps.setString(index++, problem.getResolution());
                ps.setInt(index++, problem.getCategoryId());
                ps.setInt(index++, problem.getGroupId());
                ps.setString(index++, Utils.toString((Iterable)problem.getExecutors()));
                ps.executeUpdate();
            }
        }
    }

    public void clearProblemHistory(int id) throws Exception {
        String query = "DELETE FROM register_problem_log WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public List<RegisterProblem> getProblemHistory(int id) throws Exception {
        ArrayList<RegisterProblem> result = new ArrayList<RegisterProblem>();
        String sql = "SELECT * FROM register_problem_log WHERE id=? ORDER BY change_dt";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    RegisterProblem prob = new RegisterProblem();
                    prob.setId(rs.getInt("id"));
                    prob.setValue("changeTime", TimeUtils.format((java.util.Date)rs.getTimestamp("change_dt"), (String)"dd.MM.yyyy HH:mm:ss"));
                    prob.setValue("changeUid", rs.getString("change_uid"));
                    prob.setStatusTime((java.util.Date)rs.getTimestamp("status_dt"));
                    prob.setStatusUserId(rs.getInt("status_uid"));
                    prob.setStatus(rs.getInt("status"));
                    prob.setUrgency(rs.getInt("urgency"));
                    prob.setComment(rs.getString("comment"));
                    prob.setGroupId(rs.getInt("gr"));
                    prob.setCategoryId(rs.getInt("cat"));
                    prob.setResolution(rs.getString("resolution"));
                    prob.setExecutors(Utils.toList((String)rs.getString("exec")));
                    result.add(prob);
                }
            }
        }
        return result;
    }

    public RegisterProblem getHistoryEntry(int id, long time) throws Exception {
        String query = "SELECT * FROM register_problem_log WHERE id=? AND change_dt=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.setTimestamp(2, new Timestamp(time));
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    RegisterProblem prob = new RegisterProblem();
                    prob.setValue("changeTime", TimeUtils.convertSqlDateToDate((Date)rs.getDate("change_dt")));
                    prob.setValue("changeUid", rs.getString("change_uid"));
                    prob.setStatusTime(TimeUtils.convertSqlDateToDate((Date)rs.getDate("status_dt")));
                    prob.setStatusUserId(rs.getInt("status_uid"));
                    prob.setStatus(rs.getInt("status"));
                    prob.setUrgency(rs.getInt("urgency"));
                    prob.setComment(rs.getString("comment"));
                    prob.setGroupId(rs.getInt("gr"));
                    prob.setCategoryId(rs.getInt("cat"));
                    prob.setResolution(rs.getString("resolution"));
                    prob.setExecutors(Utils.toList((String)rs.getString("exec")));
                    RegisterProblem registerProblem = prob;
                    return registerProblem;
                }
            }
        }
        return null;
    }

    public void updateProblemExecutors(RegisterProblem registerProblem, String groupExecutors) throws Exception {
        Object query = null;
        PreparedStatement ps = null;
        List executors = registerProblem.getExecutors();
        if (executors != null) {
            if (Utils.notEmptyString((String)groupExecutors)) {
                query = "DELETE FROM register_problem_executor WHERE rid=? AND eid IN ( " + groupExecutors + " )";
                ps = this.con.prepareStatement((String)query);
                ps.setInt(1, registerProblem.getId());
                ps.executeUpdate();
            }
            query = "INSERT INTO register_problem_executor ( rid, eid ) VALUES( ?, ? )";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, registerProblem.getId());
            for (String eid : executors) {
                ps.setString(2, eid);
                ps.executeUpdate();
            }
            ps.close();
        }
    }

    public void deleteProblem(int id) throws Exception {
        String query = "DELETE FROM register_problem WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        query = "DELETE FROM register_problem_executor WHERE rid=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public RegisterProblem getProblemByID(int id) throws Exception {
        RegisterProblem result = null;
        String query = "SELECT * FROM register_problem WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ArrayList<RegisterProblem> list = new ArrayList<RegisterProblem>();
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = new RegisterProblem();
                    this.setRegisterProblemData(rs, result);
                    list.add(result);
                }
            }
            this.loadExecutorList(list);
            this.loadRegisterCall(list);
        }
        return result;
    }

    public List<RegisterProblem> getNotClosedProblems() throws Exception {
        ArrayList<RegisterProblem> result = new ArrayList<RegisterProblem>();
        String query = "SELECT * FROM register_problem WHERE status IN ( 0, 1 )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    RegisterProblem ri = new RegisterProblem();
                    this.setRegisterProblemData(rs, ri);
                    result.add(ri);
                }
            }
            this.loadExecutorList(result);
            this.loadRegisterCall(result);
        }
        return result;
    }

    public void searchList(SearchResult<RegisterProblem> searchResult, Period[] periods) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List result = searchResult.getList();
            Period openPeriod = periods[0];
            Period currentStatusPeriod = periods[1];
            Period closePeriod = periods[2];
            String code = searchResult.getAttribute("code");
            String group = searchResult.getAttribute("group");
            String sort1 = searchResult.getAttribute("sort1");
            String sort2 = searchResult.getAttribute("sort2");
            String status = searchResult.getAttribute("status");
            String comment = searchResult.getAttribute("comment");
            String executor = searchResult.getAttribute("executor");
            int openDateFilterMode = Utils.parseInt((String)searchResult.getAttribute("open_date_mode"));
            int acceptDateFilterMode = Utils.parseInt((String)searchResult.getAttribute("status_date_mode"));
            int closeDateFilterMode = Utils.parseInt((String)searchResult.getAttribute("close_date_mode"));
            StringBuilder where = new StringBuilder();
            StringBuilder dateFilter = new StringBuilder();
            where.append(" WHERE true");
            if (Utils.notBlankString((String)status)) {
                where.append(" AND status IN ( ");
                where.append(status);
                where.append(" ) ");
            }
            if (Utils.notBlankString((String)group)) {
                where.append(" AND gr IN ( ");
                where.append(group);
                where.append(")");
            }
            if (!Utils.isEmptyString((String)code)) {
                where.append(" AND id LIKE '");
                where.append(code);
                where.append("%'");
            }
            if (Utils.notBlankString((String)comment)) {
                where.append(" AND comment LIKE '%");
                where.append(comment);
                where.append("%'");
            }
            if (openDateFilterMode != 0) {
                dateFilter.append(" ( open_dt IS NOT NULL ");
                if (openPeriod.getDateFrom() != null) {
                    dateFilter.append(" AND open_dt>='");
                    dateFilter.append(TimeUtils.format((java.util.Date)openPeriod.getDateFrom(), (String)"yyyy-MM-dd"));
                    dateFilter.append("'");
                }
                if (openPeriod.getDateTo() != null) {
                    dateFilter.append(" AND open_dt<'");
                    dateFilter.append(TimeUtils.format((java.util.Date)TimeUtils.getNextDay((java.util.Date)openPeriod.getDateTo()), (String)"yyyy-MM-dd"));
                    dateFilter.append("'");
                }
                dateFilter.append(" ) ");
            }
            if (acceptDateFilterMode != 0) {
                if (dateFilter.length() != 0) {
                    if (acceptDateFilterMode == 1) {
                        dateFilter.append(" AND");
                    } else {
                        dateFilter.append(" OR");
                    }
                }
                dateFilter.append(" ( status_dt IS NOT NULL ");
                if (currentStatusPeriod.getDateFrom() != null) {
                    dateFilter.append(" AND status_dt>='");
                    dateFilter.append(TimeUtils.format((java.util.Date)currentStatusPeriod.getDateFrom(), (String)"yyyy-MM-dd"));
                    dateFilter.append("'");
                }
                if (currentStatusPeriod.getDateTo() != null) {
                    dateFilter.append(" AND status_dt<'");
                    dateFilter.append(TimeUtils.format((java.util.Date)TimeUtils.getNextDay((java.util.Date)currentStatusPeriod.getDateTo()), (String)"yyyy-MM-dd"));
                    dateFilter.append("'");
                }
                dateFilter.append(" ) ");
            }
            if (closeDateFilterMode != 0) {
                if (dateFilter.length() != 0) {
                    if (closeDateFilterMode == 1) {
                        dateFilter.append(" AND");
                    } else {
                        dateFilter.append(" OR");
                    }
                }
                dateFilter.append(" ( close_dt IS NOT NULL ");
                if (closePeriod.getDateFrom() != null) {
                    dateFilter.append(" AND close_dt>='");
                    dateFilter.append(TimeUtils.format((java.util.Date)closePeriod.getDateFrom(), (String)"yyyy-MM-dd"));
                    dateFilter.append("'");
                }
                if (closePeriod.getDateTo() != null) {
                    dateFilter.append(" AND close_dt<'");
                    dateFilter.append(TimeUtils.format((java.util.Date)TimeUtils.getNextDay((java.util.Date)closePeriod.getDateTo()), (String)"yyyy-MM-dd"));
                    dateFilter.append("'");
                }
                dateFilter.append(" ) ");
            }
            if (dateFilter.length() > 0) {
                where.append(" AND ( ");
                where.append(dateFilter.toString());
                where.append(" ) ");
            }
            Object joinPart = "";
            if (Utils.notBlankString((String)executor)) {
                joinPart = " INNER JOIN register_problem_executor AS rpe ON register_problem.id=rpe.rid AND rpe.eid IN ( " + executor + " )";
            }
            StringBuilder sort = new StringBuilder();
            if (Utils.notBlankString((String)sort1)) {
                sort.append(sort1);
            }
            if (Utils.notBlankString((String)sort2)) {
                if (sort.length() > 0) {
                    sort.append(", ");
                }
                sort.append(sort2);
            }
            try {
                StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM register_problem ");
                query.append((String)joinPart);
                query.append((CharSequence)where);
                if (sort.length() > 0) {
                    query.append(" ORDER BY ");
                    query.append((CharSequence)sort);
                }
                if (page != null) {
                    query.append(page.sqlLimit());
                }
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    RegisterProblem item = new RegisterProblem();
                    this.setRegisterProblemData(rs, item);
                    result.add(item);
                }
                rs.close();
                ps.close();
                this.loadExecutorList(result);
                this.loadRegisterCall(result);
                query = new StringBuilder("SELECT COUNT(*) FROM register_problem ").append((String)joinPart).append((CharSequence)where);
                Statement st = this.con.createStatement();
                rs = st.executeQuery(query.toString());
                while (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                }
                rs.close();
                st.close();
                if (page.getPageSize() > 0) {
                    int maxPage = page.getPageCount();
                    if (maxPage == 0) {
                        maxPage = 1;
                    }
                    if (page.getPageIndex() > maxPage) {
                        page.setPageIndex(maxPage);
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    @Deprecated
    public List<RegisterProblem> getActiveProblemList(int period) {
        ArrayList<RegisterProblem> result = new ArrayList<RegisterProblem>();
        try {
            String query = "SELECT * FROM register_problem WHERE isNull( close_dt ) AND open_dt>DATE_SUB( now(), INTERVAL ? DAY ) ORDER BY open_dt DESC";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, period);
            ResultSet rs = ps.executeQuery();
            RegisterProblem item = null;
            while (rs.next()) {
                item = new RegisterProblem();
                this.setRegisterProblemData(rs, item);
                result.add(item);
            }
            rs.close();
            ps.close();
            this.loadExecutorList(result);
            this.loadRegisterCall(result);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public List<RegisterProblem> getActiveProblemListForContract(int contractId) throws BGException {
        ArrayList<RegisterProblem> result = new ArrayList<RegisterProblem>();
        if (contractId < 1) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 -contractId");
        }
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT p.* FROM register_call AS c LEFT JOIN register_problem AS p ON c.rpid=p.id WHERE c.cid=? AND isNull( p.close_dt )");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            RegisterProblem item = null;
            while (rs.next()) {
                item = new RegisterProblem();
                this.setRegisterProblemData(rs, item);
                result.add(item);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public List<RegisterProblem> getActiveProblemList(int periodInDays, List<Integer> statusList, List<Integer> groupIdList, List<Integer> urgencyList, int limit) {
        ArrayList<RegisterProblem> result = new ArrayList<RegisterProblem>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM register_problem WHERE isNull( close_dt )");
            if (periodInDays > -1) {
                query.append(" AND open_dt>DATE_SUB( now(), INTERVAL ");
                query.append(periodInDays);
                query.append(" DAY )");
            }
            if (statusList != null && !statusList.isEmpty()) {
                query.append(" AND status IN ( " + Utils.toString(statusList) + " )");
            }
            if (groupIdList != null && !groupIdList.isEmpty()) {
                query.append(" AND gr IN ( " + Utils.toString(groupIdList) + " )");
            }
            if (urgencyList != null && !urgencyList.isEmpty()) {
                query.append(" AND urgency IN ( " + Utils.toString(urgencyList) + " )");
            }
            query.append(" ORDER BY open_dt DESC");
            if (limit > 0) {
                query.append(" LIMIT ").append(limit);
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            RegisterProblem item = null;
            while (rs.next()) {
                item = new RegisterProblem();
                this.setRegisterProblemData(rs, item);
                result.add(item);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public void loadRegisterCall(List<RegisterProblem> registerProblemList) throws Exception {
        Map<Integer, List<RegisterCall>> map = new RegisterCallManager(this.con).getProblemCallList(this.getRegisterProblemIds(registerProblemList));
        for (RegisterProblem registerProblem : registerProblemList) {
            registerProblem.setCalls(map.get(registerProblem.getId()));
        }
    }

    public void loadExecutorList(List<RegisterProblem> registerProblemList) {
        if (registerProblemList != null) {
            HashMap<Integer, ArrayList<String>> executorMap = new HashMap<Integer, ArrayList<String>>();
            List<Integer> registerProblemIds = this.getRegisterProblemIds(registerProblemList);
            StringBuilder ids = new StringBuilder("0");
            for (Integer registerProblemId : registerProblemIds) {
                ids.append(", ");
                ids.append(registerProblemId);
            }
            try {
                String query = "SELECT rid, eid FROM register_problem_executor WHERE rid IN ( " + ids.toString() + " )";
                PreparedStatement ps = this.con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Integer registerProblemId = rs.getInt(1);
                    ArrayList<String> executorList = (ArrayList<String>)executorMap.get(registerProblemId);
                    if (executorList == null) {
                        executorList = new ArrayList<String>();
                        executorMap.put(registerProblemId, executorList);
                    }
                    executorList.add(rs.getString(2));
                }
                rs.close();
                ps.close();
            }
            catch (SQLException ex) {
                this.logError(ex);
            }
            for (RegisterProblem registerProblem : registerProblemList) {
                registerProblem.setExecutors((List)executorMap.get(registerProblem.getId()));
            }
        }
    }

    public List<Integer> getRegisterProblemIds(List<RegisterProblem> registerProblemList) {
        ArrayList<Integer> registerProblemIds = new ArrayList<Integer>();
        if (registerProblemList != null) {
            registerProblemIds = new ArrayList();
            for (RegisterProblem registerProblem : registerProblemList) {
                registerProblemIds.add(registerProblem.getId());
            }
        }
        return registerProblemIds;
    }

    private void setRegisterProblemData(ResultSet rs, RegisterProblem ri) throws SQLException {
        ri.setId(rs.getInt("id"));
        ri.setOpenTime((java.util.Date)rs.getTimestamp("open_dt"));
        ri.setOpenUserId(rs.getInt("open_uid"));
        ri.setStatusTime((java.util.Date)rs.getTimestamp("status_dt"));
        ri.setStatusUserId(rs.getInt("status_uid"));
        ri.setCloseTime((java.util.Date)rs.getTimestamp("close_dt"));
        ri.setCloseUserId(rs.getInt("close_uid"));
        ri.setStatus(rs.getInt("status"));
        ri.setUrgency(rs.getInt("urgency"));
        ri.setComment(rs.getString("comment"));
        ri.setGroupId(rs.getInt("gr"));
        ri.setResolution(rs.getString("resolution"));
        ri.setCategoryId(rs.getInt("cat"));
        ri.setTasks(Utils.toList((String)rs.getString("task_list")));
    }

    public HashMap<Integer, String> getSubjectsMap() throws Exception {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        String query = "SELECT id, title FROM register_subject";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.put(rs.getInt(1), rs.getString(2));
            }
        }
        return result;
    }

    public void addGroup(int registerItemID, int groupID) throws Exception {
        String query = "INSERT INTO register_problem_group ( riid, gid ) VALUES ( ?, ? )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, registerItemID);
            ps.setInt(2, groupID);
            ps.executeUpdate();
        }
    }

    public List<String> getProblemUsedGroups(int registerItemID) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String query = "SELECT t2.title FROM register_problem_group AS t1, register_group AS t2 WHERE t1.gid=t2.id AND t1.riid=? ORDER BY t1.id";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, registerItemID);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        return result;
    }

    public static Map<Integer, String> getStatusMap(String values) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        if (values != null) {
            StringTokenizer st = new StringTokenizer(values, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int pos = token.indexOf(58);
                if (pos <= -1) continue;
                try {
                    int id = Integer.parseInt(token.substring(0, pos));
                    map.put(id, token.substring(pos + 1));
                }
                catch (Exception exception) {}
            }
        }
        return map;
    }

    public static List<IdTitle> getStatusList(String values) {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        if (values != null) {
            StringTokenizer st = new StringTokenizer(values, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int pos = token.indexOf(58);
                if (pos <= -1) continue;
                try {
                    IdTitle listItem = new IdTitle();
                    listItem.setId(Integer.parseInt(token.substring(0, pos)));
                    listItem.setTitle(token.substring(pos + 1));
                    list.add(listItem);
                }
                catch (Exception exception) {}
            }
        }
        return list;
    }
}

