/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ru.bitel.bgbilling.plugins.im.client.PluginClientListener;
import ru.bitel.bgbilling.plugins.im.client.RosterTree;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNode;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeEntry;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeRoot;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.bgbilling.plugins.im.common.IMUtils;
import ru.bitel.bgbilling.plugins.im.common.IRosterItem;
import ru.bitel.bgbilling.plugins.im.common.RosterEntryItem;
import ru.bitel.bgbilling.plugins.im.common.RosterGroupItem;

public class RosterTreeNodeGroup
extends RosterTreeNode
implements Comparable<RosterTreeNodeGroup> {
    private String name;
    private int availableEntryCount;
    private int entryCount;

    public RosterTreeNodeGroup(RosterTree tree) {
        super(tree);
    }

    @Override
    public String getToolTipText() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.name);
        if (this.availableEntryCount != -1 && this.entryCount != -1) {
            sb.append(" (").append(this.availableEntryCount).append("/").append(this.entryCount).append(")");
        }
        return sb.toString();
    }

    @Override
    public void loadNode(IRosterItem groupI) {
        RosterGroupItem group = (RosterGroupItem)groupI;
        this.name = group.name;
        this.availableEntryCount = group.AvailableEntryCount;
        this.entryCount = group.EntryCount;
        for (RosterEntryItem entryEl : group.getRosterEntryItems()) {
            this.insertEntryToGroup(entryEl);
        }
    }

    public RosterTreeNodeEntry insertEntryToGroup(RosterEntryItem entry) {
        RosterTreeNodeEntry newEntryNode = new RosterTreeNodeEntry(this.tree);
        newEntryNode.loadNode((IRosterItem)entry);
        this.tree.getEntryMap().put(newEntryNode.getJid(), newEntryNode);
        String nFrom = IMUtils.getPureJID((String)newEntryNode.getJid());
        this.tree.getEntry2groupMap().put(nFrom, this);
        if (newEntryNode.getName() != null) {
            this.tree.getEntry2nameMap().put(nFrom, newEntryNode.getName());
        }
        this.insertEntryToGroup(newEntryNode);
        return newEntryNode;
    }

    public void insertEntryToGroup(RosterTreeNodeEntry entry) {
        if (this.isNodeChild(entry)) {
            this.remove(entry);
        }
        if (this.children == null) {
            this.add(entry);
        } else {
            ArrayList list = new ArrayList();
            this.children.stream().forEach(e -> list.add(new RosterTreeNodeEntry((RosterTree)((Object)e))));
            int index = Collections.binarySearch(list, entry);
            this.insert(entry, index >= 0 ? index : -index - 1);
        }
    }

    @Override
    public JLabel getView() {
        JLabel view = new JLabel();
        view.setPreferredSize(new Dimension(800, 20));
        view.setIcon(null);
        view.setText(this.getToolTipText());
        return view;
    }

    public void deleteEntryFromGroup(String jid) {
        ArrayList<String> todel = new ArrayList<String>();
        for (Map.Entry<String, RosterTreeNodeEntry> entry : this.tree.getEntryMap().entrySet()) {
            if (!entry.getKey().startsWith(jid)) continue;
            entry.getValue().removeFromParent();
            todel.add(entry.getKey());
            RosterTreeNodeRoot r = (RosterTreeNodeRoot)this.getParent();
            --this.entryCount;
            r.setEntryCount(r.getEntryCount() - 1);
            if (entry.getValue().getStatus() == IMConstants.STATUS.OFFLINE) continue;
            --this.availableEntryCount;
            r.setAvailableEntryCount(r.getAvailableEntryCount() - 1);
        }
        for (String s : todel) {
            this.tree.getEntryMap().remove(s);
        }
    }

    public void changeEntryFromGroup(RosterEntryItem el) {
        String from = el.from;
        RosterTreeNodeEntry rtn = this.tree.getEntryMap().get(from);
        RosterTreeNodeRoot nodeRoot = (RosterTreeNodeRoot)this.getParent();
        if (rtn != null) {
            IMConstants.STATUS oldStatus = rtn.getStatus();
            rtn.loadNode((IRosterItem)el);
            this.insertEntryToGroup(rtn);
            if (oldStatus == IMConstants.STATUS.OFFLINE && rtn.getStatus() != IMConstants.STATUS.OFFLINE) {
                ++this.availableEntryCount;
                nodeRoot.setAvailableEntryCount(nodeRoot.getAvailableEntryCount() + 1);
            } else if (oldStatus != IMConstants.STATUS.OFFLINE && rtn.getStatus() == IMConstants.STATUS.OFFLINE) {
                --this.availableEntryCount;
                nodeRoot.setAvailableEntryCount(nodeRoot.getAvailableEntryCount() - 1);
            }
        } else {
            this.insertEntryToGroup(el);
            ++this.entryCount;
            nodeRoot.setEntryCount(nodeRoot.getEntryCount() + 1);
            ++this.availableEntryCount;
            nodeRoot.setAvailableEntryCount(nodeRoot.getAvailableEntryCount() + 1);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getJson() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{");
        if (this.name != null) {
            sb.append("'name':'").append(this.name).append("',");
        }
        sb.append("'entry':[");
        if (this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof RosterTreeNodeEntry)) continue;
                sb.append(((RosterTreeNodeEntry)e).getJson()).append(",");
            }
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public String toString() {
        return "[group:name=" + this.name + "]";
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menuPopup = new JPopupMenu();
        JMenuItem renameGroupItem = new JMenuItem("\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443...");
        renameGroupItem.setActionCommand("renameGroupItem");
        renameGroupItem.addActionListener(e -> PluginClientListener.imManager.renameGroupDialog(this.name));
        JMenuItem removeGroupItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443");
        removeGroupItem.setActionCommand("removeGroupItem");
        removeGroupItem.addActionListener(e -> PluginClientListener.imManager.removeGroupDialog(this.name));
        if (IMConstants.isReservedGroupName((String)this.name)) {
            renameGroupItem.setEnabled(false);
            removeGroupItem.setEnabled(false);
        }
        menuPopup.add(renameGroupItem);
        menuPopup.add(removeGroupItem);
        return menuPopup;
    }

    @Override
    public int compareTo(RosterTreeNodeGroup o) {
        if (!IMConstants.isReservedGroupName((String)this.getName()) && IMConstants.isReservedGroupName((String)o.getName())) {
            return -1;
        }
        if (IMConstants.isReservedGroupName((String)this.getName()) && !IMConstants.isReservedGroupName((String)o.getName())) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }
}

