/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client.editor;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.contract.editor.GateRuleHistoryPanel;
import ru.bitel.bgbilling.modules.ipn.client.editor.ContractRuleEditorPanel;
import ru.bitel.bgbilling.modules.ipn.client.editor.TreePanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ManadContractRuleEditor
extends ContractRuleEditorPanel {
    protected BGComboBox<ComboBoxItem> ruleType_CB = new BGComboBox();
    protected JTextArea rule_TA = new JTextArea();
    protected TreePanel treeScroll;
    protected JCheckBox ruleFilter = new JCheckBox();
    protected GateRuleHistoryPanel ruleTypeHistoryPanel = new GateRuleHistoryPanel();
    protected JPanel controlPanel = new JPanel(new GridBagLayout());
    protected String ruleData;

    public ManadContractRuleEditor() {
        this.jbInit();
    }

    protected void jbInit() {
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        JTabbedPane pane = new JTabbedPane();
        pane.add((Component)this.controlPanel, "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435");
        pane.add((Component)((Object)this.ruleTypeHistoryPanel), "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u043e\u0432 \u043f\u0440\u0430\u0432\u0438\u043b");
        this.initControlPanel();
        this.setLayout(new GridBagLayout());
        this.add(pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    protected void initControlPanel() {
        this.treeScroll = new TreePanel(this);
        this.treeScroll.setMinimumSize(new Dimension(300, 100));
        this.treeScroll.setPreferredSize(new Dimension(400, 100));
        this.treeScroll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ManadContractRuleEditor.this.updateCommands();
            }
        });
        this.controlPanel.add((Component)this.createRulePanel(), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.controlPanel.add((Component)((Object)this.treeScroll), new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.controlPanel.add((Component)this.getCommandPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.ruleType_CB.addActionListener(e -> this.updateCommands());
    }

    protected JPanel createRulePanel() {
        this.ruleFilter.setSelected(true);
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this.ruleType_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.ruleFilter, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u0444\u0438\u043b\u044c\u0442\u0440"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        topPanel.setBorder((Border)new BGTitleBorder(" \u0422\u0438\u043f \u043f\u0440\u0430\u0432\u0438\u043b\u0430 "));
        this.ruleFilter.addChangeListener(e -> this.trySetData());
        return topPanel;
    }

    protected JPanel getCommandPanel() {
        JPanel rulePanel = new JPanel(new GridBagLayout());
        rulePanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u0430\u043d\u0434\u044b "));
        JScrollPane ruleScroll = new JScrollPane(this.rule_TA);
        rulePanel.add((Component)ruleScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return rulePanel;
    }

    public void setData() throws Exception {
        this.ruleType_CB.removeAllItems();
        this.treeScroll.setData();
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        if (this.ruleFilter.isSelected()) {
            req.setAction("RuleTypeList");
            req.setAttribute("gtid", this.gateTypeId);
        } else {
            req.setAction("RuleTypeTable");
        }
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            if (this.ruleFilter.isSelected()) {
                ClientUtils.buildComboBox(this.ruleType_CB, (Node)XMLUtils.getElement((Document)doc, (String)"list"), (String)"");
            } else {
                Element table = XMLUtils.getElement((Document)doc, (String)"table");
                Node data = table.getChildNodes().item(0);
                ClientUtils.buildComboBox(this.ruleType_CB, (Node)data, (String)"");
            }
        }
        this.ruleType_CB.insertItemAt((Object)new ComboBoxItem((Object)"0", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435"), 0);
        if (!"0".equals(this.id)) {
            req = new Request();
            req.setModule(this.module);
            req.setAction("GetContractRule");
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.id);
            doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element rule = XMLUtils.getElement((Document)doc, (String)"rule");
                String ruleType = rule.getAttribute("rtid");
                this.setRuleData(this.getRule(ClientUtils.linesToString((Element)rule)));
                boolean found = false;
                for (int i = 0; i < this.ruleType_CB.getItemCount(); ++i) {
                    ComboBoxItem item = (ComboBoxItem)this.ruleType_CB.getItemAt(i);
                    if (!((String)item.getObject()).equals(ruleType)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    req = new Request();
                    req.setModule(this.module);
                    req.setAction("GetRuleType");
                    req.setModuleId(this.getModuleId());
                    req.setAttribute("id", ruleType);
                    doc = this.getDocument(req);
                    if (ClientUtils.checkStatus((Document)doc)) {
                        Element ruleTypeEl = XMLUtils.getElement((Document)doc, (String)"rule_type");
                        this.ruleType_CB.addItem((Object)new ComboBoxItem((Object)ruleType, ruleTypeEl.getAttribute("title")));
                    }
                }
                ClientUtils.setComboBoxSelection(this.ruleType_CB, (Object)ruleType);
            }
        } else {
            ClientUtils.setComboBoxSelection(this.ruleType_CB, (Object)"0");
        }
        this.setDataToTreeView();
        this.updateCommands();
        try {
            this.ruleTypeHistoryPanel.setData();
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void setDataToTreeView() {
        String ruleType = ClientUtils.getIdFromComboBox(this.ruleType_CB);
        if (ruleType == null || ruleType.equals("0")) {
            this.rule_TA.setText(this.ruleData);
        } else {
            this.treeScroll.setRule(this.ruleData);
        }
    }

    protected void updateCommands() {
        String ruleType = ClientUtils.getIdFromComboBox(this.ruleType_CB);
        if (ruleType != null && !ruleType.equals("0")) {
            this.updateCommandText(this.getGenerateAction(), this.rule_TA, ruleType, this.gateTypeId, this.treeScroll.getRule());
            this.switchToTypeMode();
        } else {
            this.switchToUserMode();
        }
        this.updateUI();
    }

    protected void updateCommandText(String action, JTextArea window, String ruleType) {
        this.updateCommandText(action, window, ruleType, this.gateTypeId, this.treeScroll.getRule());
    }

    protected void updateCommandText(String action, JTextArea window, String ruleType, String gateTypeId, String data) {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction(action);
        req.setModuleId(this.getModuleId());
        req.setAttribute("rtid", ruleType);
        req.setAttribute("address_list", data);
        req.setContractId(this.getContractId());
        req.setAttribute("gtid", gateTypeId);
        req.setAttribute("cid", this.getContractId());
        this.addGenerateParams(req);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            window.setText(ClientUtils.linesToString((Element)XMLUtils.getElement((Document)doc, (String)"rule")));
        }
        this.switchToTypeMode();
        this.updateUI();
    }

    protected void switchToTypeMode() {
        this.rule_TA.setEditable(false);
        this.rule_TA.setEnabled(false);
        this.treeScroll.setVisible(true);
    }

    protected void switchToUserMode() {
        this.rule_TA.setEditable(true);
        this.rule_TA.setEnabled(true);
        this.treeScroll.setVisible(false);
    }

    protected void stopEdit(boolean save) {
        if (save) {
            String ruleType = ClientUtils.getIdFromComboBox(this.ruleType_CB);
            String rule = "";
            rule = ruleType == null || ruleType.equals("0") ? this.rule_TA.getText() : this.treeScroll.getRule();
            Request req = new Request();
            req.setModule(this.module);
            req.setAction(this.getUpdateAction());
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.id);
            req.setContractId(this.getContractId());
            req.setAttribute("fwid", this.gateId);
            req.setAttribute("rtid", ruleType);
            rule = this.addUpdateParams(rule);
            if (rule == null) {
                return;
            }
            req.setAttribute("rule", rule);
            if (ClientUtils.checkStatus((Document)this.getDocument(req))) {
                this.contractGates.showGates();
            }
        } else {
            this.contractGates.showGates();
        }
    }

    protected String getUpdateAction() {
        return "UpdateContractRule";
    }

    protected String getRule(String rule) {
        return rule;
    }

    protected String addUpdateParams(String rule) {
        return rule;
    }

    protected String getGenerateAction() {
        return "GenerateRule";
    }

    protected void addGenerateParams(Request req) {
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.treeScroll.init(module, mid);
    }

    public void setContractId(int id) {
        super.setContractId(id);
        this.treeScroll.setContractId(id);
    }

    @Override
    public void setGateId(String gateId) {
        super.setGateId(gateId);
        this.ruleTypeHistoryPanel.setGateId(Utils.parseInt((String)gateId));
    }

    protected void setRuleData(String ruleData) {
        this.ruleData = ruleData;
    }
}

