/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.range;

import java.util.Calendar;
import java.util.Date;
import ru.bitel.common.TimeUtils;

public final class TrafficRangeKey {
    long treeNodeId;
    long key;

    public static final int getMode(long key) {
        return (int)(key >> 56);
    }

    public static final int getType(long key) {
        return (int)(key >> 52 & 0xFL);
    }

    public static final long getId(long key) {
        return (int)(key & 0xFFFFFFFFFFFFFFL);
    }

    public static long getKey(int mode, int type, int accountingPeriodId, int contractTariffOptionId, Calendar time) {
        long key = 0L;
        assert (type >= 0 && type <= 15);
        switch (mode) {
            case 1: {
                key |= (long)accountingPeriodId;
                key |= 0x100000000000000L;
                break;
            }
            case 2: {
                key |= (long)time.get(2);
                key |= (long)time.get(1) << 16;
                key |= 0x200000000000000L;
                break;
            }
            case 3: {
                key |= (long)time.get(6);
                key |= (long)time.get(1) << 24;
                key |= 0x300000000000000L;
                break;
            }
            case 4: {
                long hour = time.getTimeInMillis() / 3600000L;
                key |= hour;
                key |= 0x400000000000000L;
                break;
            }
            case 5: {
                key |= (long)contractTariffOptionId;
                key |= 0x500000000000000L;
                break;
            }
            case 11: {
                key |= (long)accountingPeriodId;
                key |= 0xB00000000000000L;
                break;
            }
            case 12: {
                key |= (long)time.get(2);
                key |= (long)time.get(1) << 16;
                key |= 0xC00000000000000L;
                break;
            }
            case 13: {
                key |= (long)time.get(6);
                key |= (long)time.get(1) << 24;
                key |= 0xD00000000000000L;
                break;
            }
            case 14: {
                long hour = time.getTimeInMillis() / 3600000L;
                key |= hour;
                key |= 0xE00000000000000L;
                break;
            }
            case 15: {
                key |= (long)contractTariffOptionId;
                key |= 0xF00000000000000L;
                break;
            }
        }
        return key |= (long)type << 52;
    }

    public static final Calendar getTime(long key, Calendar time) {
        int mode = TrafficRangeKey.getMode(key);
        switch (mode) {
            case 2: 
            case 12: {
                int month = (int)(key & 0xFFFFL);
                int year = (int)(key >> 16 & 0xFFFFL);
                TimeUtils.clear_HOUR_MIN_MIL_SEC(time);
                time.set(5, 1);
                time.set(2, 0);
                time.set(1, year);
                time.set(2, month);
                return time;
            }
            case 3: 
            case 13: {
                int dayOfYear = (int)(key & 0xFFFFL);
                int year = (int)(key >> 24 & 0xFFFFL);
                TimeUtils.clear_HOUR_MIN_MIL_SEC(time);
                time.set(5, 1);
                time.set(2, 0);
                time.set(1, year);
                time.set(6, dayOfYear);
                return time;
            }
            case 4: 
            case 14: {
                long hour = key & 0xFFFFFFFFFFFFL;
                time.setTimeInMillis(hour * 3600000L);
                return time;
            }
        }
        return null;
    }

    public static final int getHourOfDay(long key, Calendar time) {
        int mode = TrafficRangeKey.getMode(key);
        switch (mode) {
            case 4: {
                long hour = key & 0xFFFFFFFFFFFFL;
                time.setTimeInMillis(hour * 3600000L);
                return time.get(11);
            }
        }
        return -1;
    }

    public TrafficRangeKey() {
    }

    public TrafficRangeKey(long treeNodeId, long key) {
        this.treeNodeId = treeNodeId;
        this.key = key;
    }

    public TrafficRangeKey(long treeNodeId, int mode, int type, int accountingPeriodId, int contractTariffOptionId, Calendar time) {
        this.setKey(treeNodeId, mode, type, accountingPeriodId, contractTariffOptionId, time);
    }

    public void setKey(long treeNodeId, long key) {
        this.treeNodeId = treeNodeId;
        this.key = key;
    }

    public void setKey(long treeNodeId, int mode, int type, int accountingPeriodId, int contractTariffOptionId, Calendar time) {
        this.treeNodeId = treeNodeId;
        this.key = TrafficRangeKey.getKey(mode, type, accountingPeriodId, contractTariffOptionId, time);
    }

    public int hashCode() {
        return 31 * (31 + (int)(this.key ^ this.key >>> 32)) + (int)(this.treeNodeId ^ this.treeNodeId >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        TrafficRangeKey other = (TrafficRangeKey)obj;
        return this.treeNodeId == other.treeNodeId && this.key == other.key;
    }

    public String toString() {
        return "RangeKey[" + this.treeNodeId + ":" + TrafficRangeKey.getMode(this.key) + ":" + TrafficRangeKey.getId(this.key) + "]";
    }

    public static void main(String[] args) {
        System.out.println(new Date(65535000L));
        long l = 0xFFFFFFFFFFFFFFFL;
        l = l / 1000L / 60L / 60L;
        System.out.println(Long.toHexString(l |= 0x500000000000000L));
    }

    public long getTreeNodeId() {
        return this.treeNodeId;
    }

    public long getKey() {
        return this.key;
    }
}

