/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.table;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.events.StartElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.AbstractBGTableModelXML;

public class BGTableModelXML
extends AbstractBGTableModelXML {
    List<List<Object>> rows = new ArrayList<List<Object>>();

    public BGTableModelXML(Node moduleDoc, ResourceBundle rb, String tableId) throws Exception {
        super(moduleDoc, rb, tableId);
    }

    public BGTableModelXML(Node moduleDoc, String baseName, String id) throws Exception {
        super(moduleDoc, baseName, id);
    }

    public void setData(Node node) throws Exception {
        this.setData(node, "/data/table");
    }

    public void setData(Node node, String path) throws Exception {
        this.rows.clear();
        int columnCount = this.columns.size();
        for (Element e : XMLUtils.selectElements(node, path + "/data/row")) {
            ArrayList<Object> row = new ArrayList<Object>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                AbstractBGTableModelXML.Col col = (AbstractBGTableModelXML.Col)this.columns.get(i);
                row.add(col.getValue(e));
            }
            this.rows.add(row);
        }
        this.fireTableDataChanged();
    }

    public void setData(XMLUtils.BGXMLEventReader reader, String path) {
        this.rows.clear();
        int columnCount = this.columns.size();
        for (StartElement e : reader.iterable(path)) {
            ArrayList<Object> row = new ArrayList<Object>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                AbstractBGTableModelXML.Col col = (AbstractBGTableModelXML.Col)this.columns.get(i);
                row.add(col.getValue(e));
            }
            this.rows.add(row);
        }
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex).get(columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        List<Object> row = this.rows.get(rowIndex);
        if (row == null) {
            row = new ArrayList<Object>();
            this.rows.set(rowIndex, row);
        }
        row.set(columnIndex, value);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public boolean isColumnHidden(int column) {
        return ((AbstractBGTableModelXML.Col)this.columns.get((int)column)).hidden;
    }

    @Override
    public boolean isColumnVisible(int column) {
        return ((AbstractBGTableModelXML.Col)this.columns.get((int)column)).visible;
    }

    @Override
    public void setColumnVisible(int column, boolean value) {
        ((AbstractBGTableModelXML.Col)this.columns.get((int)column)).visible = value;
    }

    @Override
    public void hideColumns() {
    }
}

