/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginBase;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;

public class ModulePluginMap {
    private final Logger logger = LogManager.getLogger();
    private static ModulePluginMap instance;
    private HashMap<String, String> modulesAndPlugins = new HashMap();

    public static ModulePluginMap getInstance(Connection connection) {
        if (instance == null) {
            instance = new ModulePluginMap(connection);
        }
        return instance;
    }

    public static ModulePluginMap getInstance() throws BGException {
        if (instance == null) {
            throw new BGException("ModulePluginMap not initializate!");
        }
        return instance;
    }

    private ModulePluginMap(Connection connection) {
        this.load(connection);
    }

    public void load(Connection connection) {
        this.modulesAndPlugins.clear();
        this.modulesAndPlugins.put("0", "\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
        this.loadModules(connection);
        this.loadPlugins();
    }

    private void loadModules(Connection connection) {
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery("SELECT id, title FROM module");){
            while (rs.next()) {
                this.modulesAndPlugins.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex);
        }
    }

    private void loadPlugins() {
        for (BGPluginBase bGPluginBase : BGPluginManagerServer.getManager().getPluginsMap().values()) {
            if (!(bGPluginBase instanceof BGPluginServer)) continue;
            this.modulesAndPlugins.put("p" + ((BGPluginServer)bGPluginBase).getPluginUID(), "\u041f\u043b\u0430\u0433\u0438\u043d " + bGPluginBase.getName());
        }
    }

    public String get(String key) {
        return this.modulesAndPlugins.get(key);
    }
}

