/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.task;

import java.time.LocalDateTime;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CheckMNPStatusTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        this.getLogger().info("\u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 MNP");
        try {
            ServerContext context = (ServerContext)ServerContext.get();
            MegafonApiClient megafonApiClient = new MegafonApiClient(this.moduleId);
            MegafonContractService megafonContractService = (MegafonContractService)context.getService(MegafonContractService.class, this.moduleId);
            List products = megafonContractService.getContractProductList(null, -1, MegafonContractProductStatus.ACTIVE).getList();
            for (MegafonContractProduct contractProduct : products) {
                if (Utils.isBlankString((String)contractProduct.getMnpProcessNumber())) continue;
                try {
                    this.checkMNPStatus(megafonContractService, megafonApiClient, contractProduct);
                }
                catch (Exception e) {
                    this.logError(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 MNP. contractProductId=%s, cid=%s", contractProduct.getId(), contractProduct.getContractId()), e);
                }
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void checkMNPStatus(MegafonContractService megafonContractService, MegafonApiClient megafonApiClient, MegafonContractProduct contractProduct) throws Exception {
        if (Utils.notBlankString((String)contractProduct.getAdditionalMsisdn()) && Utils.isBlankString((String)contractProduct.getMnpProcessNumber())) {
            throw new BGException(String.format("\u041d\u0435\u0442 mnpProcessNumber \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430! contractProductId=%s, cid=%s", contractProduct.getId(), contractProduct.getContractId()));
        }
        if (Utils.notBlankString((String)contractProduct.getMnpProcessNumber()) && Utils.isBlankString((String)contractProduct.getAdditionalMsisdn())) {
            throw new BGException(String.format("\u041d\u0435\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430! contractProductId=%s, cid=%s", contractProduct.getId(), contractProduct.getContractId()));
        }
        this.getLogger().info("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 MNP \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430: msisdn={}, additionalMsisdn={}, cid={}, mnpProcessNumber={}", new Object[]{contractProduct.getMsisdn(), contractProduct.getAdditionalMsisdn(), contractProduct.getContractId(), contractProduct.getMnpProcessNumber()});
        JSONObject status = megafonApiClient.getOrderInfo(Utils.parseLong((String)contractProduct.getMnpProcessNumber())).optJSONObject("status");
        int statusCode = status.optInt("orderStatusId");
        String code = status.optString("code");
        String comment = contractProduct.getMnpOrderComment() + "\n\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438: " + TimeUtils.format((LocalDateTime)LocalDateTime.now(), (String)"dd.MM.yyyy HH:mm:ss") + ", \u0441\u0442\u0430\u0442\u0443\u0441=" + code + ", \u043a\u043e\u0434=" + statusCode + ", \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435=" + status.optString("name");
        contractProduct.setMnpOrderComment(comment);
        if ("DONE".equals(code) && statusCode == 3) {
            this.getLogger().info("MNP \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d. msisdn={}, cid={}", (Object)contractProduct.getMsisdn(), (Object)contractProduct.getContractId());
            contractProduct.setAdditionalMsisdn("");
            contractProduct.setMnpProcessNumber("");
        }
        megafonContractService.contractProductUpdate(contractProduct);
    }

    public String getDescription() {
        return "\u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 MNP";
    }
}

