/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ServiceLink {
    public static final int OUTGOING_PACKET = 1;
    public static final int INCOMING_PACKET = 2;
    public static final int ANY_IFACE = -1;
    private int id;
    private int planId;
    private int pos;
    private Calendar date1;
    private Calendar date2;
    private int sourceId;
    private int iface;
    private int direct;
    private long addr1;
    private long addr2;
    private int port1;
    private int port2;
    public int serviceId;
    private String comment;
    private int diffServ;
    private int diffServMask;
    private String diffServString;

    public int getId() {
        return this.id;
    }

    @Deprecated
    public int getID() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Deprecated
    public void setID(int id) {
        this.id = id;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public Calendar getDate1() {
        return this.date1;
    }

    public void setDate1(Calendar date1) {
        this.date1 = date1;
    }

    public Calendar getDate2() {
        return this.date2;
    }

    public void setDate2(Calendar date2) {
        this.date2 = date2;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    @Deprecated
    public int getSourceID() {
        return this.sourceId;
    }

    public void setSourceId(int sourceId) {
        this.sourceId = sourceId;
    }

    @Deprecated
    public void setSourceID(int sourceId) {
        this.sourceId = sourceId;
    }

    public int getDirect() {
        return this.direct;
    }

    public void setDirect(int direct) {
        this.direct = direct;
    }

    public long getAddr1() {
        return this.addr1;
    }

    public void setAddr1(long addr1) {
        this.addr1 = addr1;
    }

    public long getAddr2() {
        return this.addr2;
    }

    public void setAddr2(long addr2) {
        this.addr2 = addr2;
    }

    public int getPort1() {
        return this.port1;
    }

    public void setPort1(int port1) {
        this.port1 = port1;
    }

    public int getPort2() {
        return this.port2;
    }

    public void setPort2(int port2) {
        this.port2 = port2;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    @Deprecated
    public int getServiceID() {
        return this.serviceId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    @Deprecated
    public void setServiceID(int serviceId) {
        this.serviceId = serviceId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDiffServString() {
        return this.diffServString;
    }

    public void setDiffServString(String diffServString) {
        this.diffServString = diffServString;
        this.updateDiffServ(diffServString);
    }

    private void updateDiffServ(String diffServ) {
        try {
            diffServ = diffServ.replaceAll("\\.", "");
            this.diffServ = Integer.parseInt(diffServ.replaceAll("x", "0"), 2);
            this.diffServMask = Integer.parseInt(diffServ.replaceAll("[01]", "1").replaceAll("x", "0"), 2);
        }
        catch (Exception e) {
            this.diffServ = -1;
            this.diffServMask = 0;
        }
    }

    public int getDiffServ() {
        return this.diffServ;
    }

    public int getDiffServMask() {
        return this.diffServMask;
    }

    public boolean isCoinside(int direct, long addr, int port, int iface, int diffServ) {
        if (this.iface != -1 && this.iface != iface) {
            return false;
        }
        if (this.direct != 0 && this.direct != direct) {
            return false;
        }
        if (this.addr1 != 0L && this.addr1 > addr || this.addr2 != 0L && this.addr2 < addr) {
            return false;
        }
        if (this.diffServ != -1 && (diffServ & this.diffServMask) != this.diffServ) {
            return false;
        }
        return (this.port1 == 0 || this.port1 <= port) && (this.port2 == 0 || this.port2 >= port);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(50);
        switch (this.direct) {
            case 1: {
                result.append("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439");
                break;
            }
            case 2: {
                result.append("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439");
                break;
            }
            default: {
                result.append("\u041b\u044e\u0431\u043e\u0439");
            }
        }
        if (this.addr1 != 0L || this.addr2 != 0L) {
            result.append(" ");
            result.append(IPUtils.convertLongIpToString((long)this.addr1));
            result.append(" - ");
            result.append(IPUtils.convertLongIpToString((long)this.addr2));
        }
        if (this.port1 != 0 || this.port2 != 0) {
            result.append(" [");
            result.append(this.port1);
            result.append(" - ");
            result.append(this.port2);
            result.append(" ]");
        }
        return result.toString();
    }

    public int getIface() {
        return this.iface;
    }

    public void setIface(int iface) {
        this.iface = iface;
    }

    public String serializeToString() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", String.valueOf(this.id));
        data.put("pos", String.valueOf(this.pos));
        data.put("date1", TimeUtils.format((Calendar)this.date1, (String)"dd.MM.yyyy"));
        data.put("date2", TimeUtils.format((Calendar)this.date2, (String)"dd.MM.yyyy"));
        data.put("source", String.valueOf(this.sourceId));
        data.put("iface", String.valueOf(this.iface));
        data.put("direct", String.valueOf(this.direct));
        data.put("addr1", String.valueOf(this.addr1));
        data.put("addr2", String.valueOf(this.addr2));
        data.put("port1", String.valueOf(this.port1));
        data.put("port2", String.valueOf(this.port2));
        data.put("sid", String.valueOf(this.serviceId));
        data.put("comment", this.comment);
        data.put("diffServ", this.diffServString);
        return Utils.pairHashToString(data);
    }

    public void loadFromString(String data) {
        Map dataMap = Utils.stringToPairsHash((String)data);
        this.pos = Utils.parseInt((String)((String)dataMap.get("pos")));
        this.date1 = TimeUtils.parseCalendar((String)((String)dataMap.get("date1")), (String)"dd.MM.yyyy");
        this.date2 = TimeUtils.parseCalendar((String)((String)dataMap.get("date2")), (String)"dd.MM.yyyy");
        this.sourceId = Utils.parseInt((String)((String)dataMap.get("source")));
        this.iface = Utils.parseInt((String)((String)dataMap.get("iface")));
        this.direct = Utils.parseInt((String)((String)dataMap.get("direct")));
        this.addr1 = Utils.parseLong((String)((String)dataMap.get("addr1")));
        this.addr2 = Utils.parseLong((String)((String)dataMap.get("addr2")));
        this.port1 = Utils.parseInt((String)((String)dataMap.get("port1")));
        this.port2 = Utils.parseInt((String)((String)dataMap.get("port2")));
        this.serviceId = Utils.parseInt((String)((String)dataMap.get("sid")));
        this.comment = Utils.maskNull((String)((String)dataMap.get("comment")));
        this.diffServString = Utils.maskNull((String)((String)dataMap.get("diffServ")));
        this.updateDiffServ(this.diffServString);
    }

    public int getPlanId() {
        return this.planId;
    }

    public void setPlanId(int planId) {
        this.planId = planId;
    }
}

