/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import bitel.billing.server.admin.bean.AddressHouse;
import bitel.billing.server.admin.bean.AddressItem;
import bitel.billing.server.admin.bean.AddressManager;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.QuarterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;

public class ActionSearchAddressDirectory
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        String mode = this.getParameter("mode", null);
        if (mode != null) {
            Element directory = this.createElement(this.rootNode, "directory");
            Element table = this.createElement(directory, "table");
            Element data = this.createElement(table, "data");
            AddressManager addressManager = new AddressManager(this.con);
            if ("street".equals(mode = mode.toLowerCase().trim()) || "quarter".equals(mode)) {
                if ("street".equals(mode)) {
                    try (StreetDao streetDao = new StreetDao(this.con);){
                        SearchResult searchResult = new SearchResult();
                        searchResult.setPage(this.getPage());
                        streetDao.searchStreetList((SearchResult<Street>)searchResult, this.getIntParameter("cityId", -1), this.getMask("searchStreet"));
                        searchResult.getList().forEach(a -> this.toXml(data, a.getId(), a.getCity().getId(), a.getTitle()));
                        this.setPageAttribute(table, searchResult.getPage());
                    }
                } else if ("quarter".equals(mode)) {
                    try (QuarterDao quarterDao = new QuarterDao(this.con);){
                        SearchResult searchResult = new SearchResult();
                        searchResult.setPage(this.getPage());
                        quarterDao.searchQuarterList((SearchResult<Quarter>)searchResult, this.getIntParameter("cityId", -1), this.getMask("searchQuarter"));
                        searchResult.getList().forEach(a -> this.toXml(data, a.getId(), a.getCity().getId(), a.getTitle()));
                        this.setPageAttribute(table, searchResult.getPage());
                    }
                }
            } else if ("house".equals(mode)) {
                int areaId = this.getIntParameter("areaId", -1);
                int quarterId = this.getIntParameter("quarterId", -1);
                int streetId = this.getIntParameter("streetId", -1);
                SearchResult searchResult = new SearchResult();
                searchResult.setPage(this.getPage());
                addressManager.searchHouseList((SearchResult<AddressHouse>)searchResult, areaId, quarterId, streetId, this.getParameter("searchHouse"), true, true, true);
                for (AddressHouse addressHouse : searchResult.getList()) {
                    Element row = this.createElement(data, "row");
                    row.setAttribute("id", String.valueOf(addressHouse.getId()));
                    row.setAttribute("area_id", String.valueOf(addressHouse.getAreaId()));
                    row.setAttribute("quarter_id", String.valueOf(addressHouse.getQuarterId()));
                    row.setAttribute("street_id", String.valueOf(addressHouse.getStreetId()));
                    row.setAttribute("house", addressHouse.getHouseFrac());
                    row.setAttribute("dt", TimeUtils.format((Date)addressHouse.getDate(), (String)"dd.MM.yyyy"));
                    row.setAttribute("comment", addressHouse.getComment());
                    AddressItem addressItem = null;
                    int submode = this.getIntParameter("submode", 0);
                    addressItem = submode == 1 ? addressHouse.getAddressQuarter() : (submode == 2 ? addressHouse.getAddressArea() : addressHouse.getAddressStreet());
                    row.setAttribute("item_title", "-");
                    row.setAttribute("city_title", "-");
                    row.setAttribute("country_title", "-");
                    if (addressItem == null) continue;
                    row.setAttribute("item_title", addressItem.getTitle());
                    row.setAttribute("item_id", String.valueOf(addressItem.getId()));
                    City city = addressItem.getCity();
                    if (city == null) continue;
                    row.setAttribute("city_title", city.getTitle());
                    row.setAttribute("city_id", String.valueOf(city.getId()));
                    Country country = city.getCountry();
                    if (country == null) continue;
                    row.setAttribute("country_title", country.getTitle());
                    row.setAttribute("country_id", String.valueOf(country.getId()));
                }
                this.setPageAttribute(table, searchResult.getPage());
            }
        } else {
            throw new BGMessageException("Parameter \"mode\" - not found!");
        }
    }

    private String getMask(String name) {
        StringBuilder mask = new StringBuilder();
        String searchText = this.getParameter(name);
        String searchMode = this.getParameter(name + "Mode");
        if (searchText != null && !searchText.isEmpty()) {
            if (searchMode == null || "subs".equals(searchMode) || "end".equals(searchMode)) {
                mask.append('%');
            }
            mask.append(searchText);
            if (searchMode == null || "subs".equals(searchMode) || "start".equals(searchMode)) {
                mask.append('%');
            }
        }
        return mask.toString();
    }

    private void toXml(Element data, int id, int cityId, String title) {
        Element row = this.createElement(data, "row");
        row.setAttribute("id", String.valueOf(id));
        row.setAttribute("city_id", String.valueOf(cityId));
        row.setAttribute("title", title);
    }
}

