/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.script.common.bean.GlobalScriptLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class GlobalScriptLogDao
extends AbstractDao<GlobalScriptLog> {
    public static final String prefixNameTable = "log_gscript_process";

    public GlobalScriptLogDao(Connection con, String tableName) {
        super(con, -1, tableName);
    }

    public List<String> getScriptLogTitleList(Period period) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        if (ServerUtils.tableExists(this.con, this.tableName)) {
            String query = "SELECT DISTINCT title FROM " + this.tableName + " WHERE TO_DAYS(time)>=TO_DAYS('" + TimeUtils.formatSQLDate((Date)period.getDateFrom());
            query = query + (String)(period.getDateTo() != null ? "') AND TO_DAYS(time)<=TO_DAYS('" + TimeUtils.formatSQLDate((Date)period.getDateTo()) : "");
            query = query + "') ORDER BY time ";
            try (PreparedStatement ps = this.con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        return result;
    }

    public List<GlobalScriptLog> getScriptLogList(Period period, String title, Page page) throws SQLException {
        ArrayList<GlobalScriptLog> result = new ArrayList<GlobalScriptLog>();
        if (period == null || period.getDateFrom() == null) {
            return result;
        }
        if (ServerUtils.tableExists(this.con, this.tableName)) {
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE TO_DAYS(time)>=TO_DAYS('" + TimeUtils.formatSQLDate((Date)period.getDateFrom()) + "')";
            if (period.getDateTo() != null) {
                query = query + " AND TO_DAYS(time)<=TO_DAYS('" + TimeUtils.formatSQLDate((Date)period.getDateTo()) + "')";
            }
            if (title != null) {
                query = query + " AND title=?";
            }
            query = query + " ORDER BY time DESC ";
            if (page != null && page.getPageSize() > 0) {
                query = query + page.sqlLimit();
            }
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                if (title != null) {
                    ps.setString(1, title);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(this.getFromRS(rs));
                    }
                }
            }
            if (page != null && page.getPageSize() > 0) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
        }
        return result;
    }

    public String writeLog(String functionName, String out, String err, String ex, Calendar finishTime) throws SQLException {
        this.checkTable(this.tableName);
        GregorianCalendar now = new GregorianCalendar();
        StringBuilder report = new StringBuilder(out.length() + err.length() + ex.length() + 200);
        report.append("GENERATE_TIME: " + TimeUtils.format((Calendar)finishTime, (String)"dd.MM.yy HH:mm:ss"));
        report.append("\nEXECUTION_STOP_TIME: " + TimeUtils.format((Calendar)now, (String)"dd.MM.yy HH:mm:ss"));
        report.append("\nPROCESS_TIME: " + (now.getTimeInMillis() - finishTime.getTimeInMillis()));
        report.append("\n\nOUT:\n" + out);
        if (Utils.notBlankString((String)err)) {
            report.append("\n\nERROR:\n" + err);
        }
        if (Utils.notBlankString((String)ex)) {
            report.append("\n\nEXCEPTIONS:\n" + ex);
        }
        if (Utils.notBlankString((String)ex) || Utils.notBlankString((String)err)) {
            String key = "bgbs.global.script.error";
            AlarmSender.sendAlarm("bgbs.global.script.error", 0L, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0433\u043e BGBS \u0441\u043a\u0440\u0438\u043f\u0442\u0430", report.toString());
        }
        if (!ServerUtils.tableExists(this.con, this.tableName)) {
            String query = "CREATE TABLE " + this.tableName + "( `id` int(11) NOT NULL AUTO_INCREMENT, time DATETIME NOT NULL,  title VARCHAR(250) NOT NULL,  data LONGTEXT NOT NULL, PRIMARY KEY (`id`) )";
            ServerUtils.checkAndCreatePeriodicTableName(this.con, this.tableName, query);
        }
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET time=?, title=?, data=?");){
            ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp((Calendar)now));
            ps.setString(2, functionName);
            ps.setString(3, report.toString());
            ps.executeUpdate();
        }
        return report.toString();
    }

    protected GlobalScriptLog getFromRS(ResultSet rs) throws SQLException {
        return new GlobalScriptLog().setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("time"))).setTitle(rs.getString("title")).setData(rs.getString("data"));
    }

    private void checkTable(String nt) throws SQLException {
        if (nt.indexOf(prefixNameTable) == -1) {
            throw new SQLException("\u041d\u0435 \u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b!");
        }
    }

    protected void updateImpl(GlobalScriptLog b) throws SQLException {
    }
}

