/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostObject;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostObjectDao
extends AbstractDao<ForpostObject> {
    private final String TABLE_FORPOST_ACCOUNT;
    private final String TABLE_FORPOST_ACCOUNT_CONTRACT;

    public ForpostObjectDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_object");
        this.TABLE_FORPOST_ACCOUNT = "smarthouse_forpost_account_" + moduleId;
        this.TABLE_FORPOST_ACCOUNT_CONTRACT = "smarthouse_forpost_account_contract_" + moduleId;
    }

    public List<ForpostObject> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    protected ForpostObject getFromRS(ResultSet rs) throws SQLException, BGException {
        ForpostObject result = new ForpostObject();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setAccountId(rs.getInt("account_id"));
        result.setAddress(rs.getString("address"));
        result.setData(rs.getString("data"));
        return result;
    }

    protected void updateImpl(ForpostObject forpostObject) throws BGException {
        if (forpostObject != null) {
            try {
                int parameterIndex = 1;
                boolean insert = forpostObject.getId() < 1;
                String sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET id=?, account_id=?, name=?, address=?, data=?" + (insert ? "" : " WHERE id=?");
                PreparedStatement ps = this.con.prepareStatement(sql);
                ps.setInt(parameterIndex++, forpostObject.getId());
                ps.setInt(parameterIndex++, forpostObject.getAccountId());
                ps.setString(parameterIndex++, forpostObject.getName());
                ps.setString(parameterIndex++, forpostObject.getAddress());
                ps.setString(parameterIndex++, forpostObject.getData());
                if (!insert) {
                    ps.setInt(parameterIndex++, forpostObject.getId());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(ps.toString());
                }
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void deleteForpostObject(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");){
            ps.setInt(1, id);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostObjects(SearchResult<ForpostTMCAO<ForpostObject>> searchResult) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS o.*, a.name AS accountName, c.id AS contractId, c.title AS contractTitle FROM " + this.tableName + " AS o LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT + " AS a ON a.id=o.account_id LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT_CONTRACT + " AS ac ON ac.account_id=o.account_id LEFT JOIN contract AS c ON c.id=ac.contract_id " + (page != null ? page.sqlLimit() : ""), 1);){
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ForpostTMCAO tableModelRow = new ForpostTMCAO();
                tableModelRow.setContractId(rs.getInt("contractId"));
                tableModelRow.setContractTitle(rs.getString("contractTitle"));
                tableModelRow.setAccountName(rs.getString("accountName"));
                tableModelRow.setObject((Object)this.getFromRS(rs));
                list.add(tableModelRow);
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    public void searchForpostAccountObjects(SearchResult<ForpostObject> searchResult, int accountId) throws BGException {
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + (accountId > 0 ? " WHERE account_id=? " : ""));){
            if (accountId > 0) {
                ps.setInt(1, accountId);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    public void doSync(int accountId, ForpostObject[] objects) throws BGException {
        if (objects == null) {
            return;
        }
        long now = System.currentTimeMillis();
        String sqlField = "account_id=?, name=?, address=?, data=?, sync_datetime=?";
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField);
             PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>? AND account_id=?");){
            for (ForpostObject forpostObject : objects) {
                int parameterIndex = 1;
                psInsert.setInt(parameterIndex++, forpostObject.getId());
                psInsert.setInt(parameterIndex++, accountId);
                psInsert.setString(parameterIndex++, forpostObject.getName());
                psInsert.setString(parameterIndex++, forpostObject.getAddress());
                psInsert.setString(parameterIndex++, forpostObject.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setInt(parameterIndex++, accountId);
                psInsert.setString(parameterIndex++, forpostObject.getName());
                psInsert.setString(parameterIndex++, forpostObject.getAddress());
                psInsert.setString(parameterIndex++, forpostObject.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
            }
            psDelete.setLong(1, now);
            psDelete.setInt(2, accountId);
            psDelete.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostObject getForpostObject(int id) throws BGException {
        try {
            return (ForpostObject)this.getById(id);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

