/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.services.ServiceConfig;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFrame;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.ClosedTabs;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.common.client.GroupParent;

public class BGTabPanel
extends BGPanel
implements GroupParent,
AbstractTabPanel {
    protected String tabID = null;
    protected String tabTitle = null;
    protected Icon tabIcon = null;
    protected String tabTip = null;
    private Map<String, Object> attributeMap = null;

    public BGTabPanel(String tabID, String tabTitle) {
        this.tabID = tabID;
        this.tabTitle = tabTitle;
        this.getInputMap().setParent(BGClientBase.getFrame().getTabbedPane().getInputMap(2));
        this.getActionMap().setParent(BGClientBase.getFrame().getTabbedPane().getActionMap());
    }

    @Override
    public void setTabId(String tabID) {
        this.tabID = tabID;
    }

    @Override
    public String getTabId() {
        return this.tabID;
    }

    @Override
    public void setTabTitle(String tabTitle) {
        this.tabTitle = tabTitle;
        if (this.getParent() != null) {
            ((BGTabbedPane)this.getParent()).setTabTitle(this, tabTitle);
        }
    }

    public void setTabIcon(Icon tabIcon) {
        this.tabIcon = tabIcon;
        if (this.getParent() instanceof BGTabbedPane) {
            ((BGTabbedPane)this.getParent()).setTabIcon(this, tabIcon);
        }
    }

    @Override
    public String getTabTitle() {
        return this.tabTitle;
    }

    @Override
    public boolean onClosing() {
        ClosedTabs.getInstance().put(this);
        return true;
    }

    public void onOpening() {
    }

    public void closeTab() {
        ((BGTabbedPane)this.getParent()).removeTab(this);
    }

    public Icon getTabIcon() {
        return this.tabIcon;
    }

    public String getTabTip() {
        return this.tabTip;
    }

    public void setAttribute(String key, Object value) {
        if (key != null && value != null) {
            if (this.attributeMap == null) {
                this.attributeMap = new HashMap<String, Object>();
            }
            this.attributeMap.put(key, value);
        }
    }

    public void removeAttribute(String key) {
        if (key != null && this.attributeMap != null) {
            this.attributeMap.remove(key);
        }
    }

    public Object getAttribute(String key) {
        return this.attributeMap != null && key != null ? this.attributeMap.get(key) : null;
    }

    public BGTabPanel getCopyTabPanel(String tabTitle) {
        BGTabPanel tabPanel = null;
        try {
            if (this instanceof ServiceConfig) {
                tabPanel = (BGTabPanel)this.getClass().getConstructor(Integer.TYPE, String.class).newInstance(((ServiceConfig)this).getModuleId(), ((ServiceConfig)this).getRbName());
                ((ServiceConfig)tabPanel).setData();
            } else if (this instanceof ContractEditor) {
                tabPanel = (BGTabPanel)this.getClass().getConstructor(Integer.TYPE).newInstance(((ContractEditor)this).getContractId());
            } else if (this instanceof BGTabPanel) {
                try {
                    tabPanel = (BGTabPanel)this.getClass().getConstructor(JFrame.class).newInstance(BGClientBase.getFrame());
                }
                catch (Exception ex) {
                    tabPanel = (BGTabPanel)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            } else {
                tabPanel = (BGTabPanel)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            tabPanel.setTabTitle(tabTitle);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        if (tabPanel == null) {
            try {
                tabPanel = (BGTabPanel)this.getClass().getConstructor(String.class, String.class).newInstance(this.tabID, tabTitle);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        return tabPanel;
    }
}

