<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output encoding="UTF-8" method="html" indent="yes"/>
  
 <xsl:template match="/data">
	<xsl:choose>
		<xsl:when test="@status = 'ok'">
			<xsl:choose>
				<xsl:when test="@action = 'Init'"><xsl:call-template name="Find"/></xsl:when>
				<xsl:when test="@action = 'ContractFind'"><xsl:call-template name="Contract"/></xsl:when>
				<xsl:when test="@action = 'PaymentListPrint'">	<xsl:call-template name="paymentsTablePrint">
		<xsl:with-param name="itogo" select="'true'"/>
	</xsl:call-template></xsl:when>
				<xsl:when test="@action = 'PaymentList'"><xsl:call-template name="Payments"/></xsl:when>
				<xsl:when test="@action = 'PaymentAdd'"><xsl:call-template name="PaymentAdded"/></xsl:when>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="@error_code = '9'">
					<xsl:call-template name="toomuchresults"></xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="error"><xsl:with-param name="error" select="@error_code"/></xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
  </xsl:template>


<xsl:template name="error">	
	<xsl:param name="error"/>
	
	<table border="0" cellpadding="3" cellspacing="0" align="center" width="100%" height="100%" >
		<tr height="100%">
			<!-- td align="center" class="er ror" valign="center"><xsl:value-of select="/data/text()"/></td -->
			<td>				
				<div class="errorMessage">
					<xsl:value-of select="/data/text()"/>
				</div>
			</td>
		</tr>
		<tr>
			<td width="100%" valign="bottom" align="right">
				<form action="javascript:getBack()">
					<input class="butt" type="submit" value="Назад"/>
				</form>
			</td>
		</tr>
	</table>
</xsl:template>


<xsl:template name="toomuchresults">
	<xsl:param name="error"/>
	
	<xsl:choose>
		<xsl:when test="count(/data/contract) &lt;= 0">
			<xsl:call-template name="error"><xsl:with-param name="error" select="$error"/></xsl:call-template>
		</xsl:when>
		
		<xsl:otherwise>
			<table border="0" cellpadding="3" cellspacing="0" align="center" width="100%" height="100%">
				<tr>
					<td align="center"><h2>Результаты поиска</h2></td>
				</tr>
				<tr height="100%"><td width="100%" valign="top">
					<table class="table_show" align="center" width="100%" cellpadding="5" cellspacing="1">
						<tr>
							<td class="tdtitle">Договор</td>
							<td class="tdtitle">Комментарий</td>
							<td class="tdtitle">Баланс</td>
							<td class="tdtitle">&#xA0;</td>
						</tr>
						<xsl:for-each select="/data/contract">
							<tr>
								<td width="30%"><xsl:call-template name="set_background"/><xsl:value-of select="@title"/></td>
								<td width="60%"><xsl:call-template name="set_background"/><xsl:value-of select="@comment"/></td>
								<td align="center"><xsl:call-template name="set_background"/><xsl:value-of select="@balance"/></td>
								<td nowrap="nowrap"><xsl:call-template name="set_background"/>
									<button class="w">
										<xsl:attribute name="onClick">createPayment('<xsl:value-of select="@id"/>','<xsl:value-of select="@title"/>','<xsl:value-of select="@comment"/>','<xsl:value-of select="@balance"/>','<xsl:value-of select="@firm_id"/>',
										'<xsl:if test="tariffs/@show=1"><xsl:for-each select="tariffs/tariff"><xsl:if test="position()!=1">,</xsl:if><xsl:value-of select="@title"/></xsl:for-each></xsl:if>','<xsl:value-of select="tariffs/@show"/>')</xsl:attribute>
										Выбрать
									</button>
								</td>
							</tr>
						</xsl:for-each>
					</table>				
				</td></tr>				
				<tr>
					<td  valign="bottom" align="right"><button class="w" onclick="getBack()">Уточнить фильтр</button></td>
				</tr>
			</table>			
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="Find">
	<form action="javascript:submit('ContractFind', newPayment);" name="ContractFind">
	<table border="0" cellpadding="3" cellspacing="0" align="center" width="100%" height="100%" >
	  <tr>
		<td align="center" colspan="2" class="title" height="40" valign="top">Поиск договора</td>
	  </tr>
	  <xsl:for-each select="find_modes/mode">
		<tr>
			<xsl:choose>
				<xsl:when test="@name = 'kernel_address'">
					<xsl:call-template name="find_address"><xsl:with-param name="id" select="@id"/><xsl:with-param name="title" select="@title"/></xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="find_login"><xsl:with-param name="name" select="concat(param/@name,'_',@id)"/><xsl:with-param name="title" select="@title"/></xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	  </xsl:for-each>	 
	  <tr>
	  	<td colspan="2" align="right" height="100%" valign="bottom">
			<input class="butt" type="submit" value="Найти" style="width:100px"/>
		</td>
	  </tr>
	</table>
	</form>
</xsl:template>

<xsl:template name="find_address">
	<xsl:param name="title"/>
	<xsl:param name="id"/>
	
	<td class="th"><xsl:value-of select="$title"/></td>
	<td>
	<table cellpadding="0" cellspacing="0">
		<tr>
			<td width="30%">
				<div id="hint" class="hint"/>
				<select id="citySelect" style="width:100%" onChange="onCityChange(this);">
					<xsl:call-template name="cities"/>
				</select>
			</td>
			<td width="70%">
				<div id="hint" class="hint"/>
				<select id="streetSelect" style="width:100%">
					<xsl:attribute name="name"><xsl:value-of select="concat('address_street_',$id)"/></xsl:attribute>
					<xsl:call-template name="streets"/>
				</select>
			</td>
			<td style="padding-left: 5px;">д.</td>
			<td style="padding-left:2px; padding-right:2px"><input type="text" size="5"><xsl:attribute name="name"><xsl:value-of select="concat('address_house_frac_',$id)"/></xsl:attribute></input></td>
			<td style="padding-left: 5px;">кв.</td>
			<td style="padding-left:2px;"><input type="text" size="3"><xsl:attribute name="name"><xsl:value-of select="concat('address_flat_',$id)"/></xsl:attribute></input></td>
		</tr>
	</table>
	</td>
</xsl:template>

<xsl:template name="cities">
	<xsl:for-each select="//data/address_list/cities/item">
		<option>
			<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
			<xsl:value-of select="@title"/>
		</option>
	</xsl:for-each>
</xsl:template>

<xsl:template name="streets">
	<xsl:for-each select="//data/address_list/streets/item">
		<option>
			<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
			<xsl:value-of select="@title"/>
		</option>
	</xsl:for-each>
</xsl:template>

<xsl:template name="find_login">
	<xsl:param name="name"/>
	<xsl:param name="title"/>
	<td class="th" nowrap="nowrap"><xsl:value-of select="$title"/></td>
	<td style="width: 90%"><input type="text" style="width: 100%" align="left"><xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute></input></td>
</xsl:template>

<xsl:template name="Contract">
	<form action="javascript:submit('PaymentAdd');" name="PaymentAdd">
		<input type="hidden" name="cid"><xsl:attribute name="value"><xsl:value-of select="contract/@id"/></xsl:attribute></input>
		<input type="hidden" name="trans"><xsl:attribute name="value"><xsl:value-of select="//data/@trans"/></xsl:attribute></input>
		<!--  input type="hidden" name="comment"><xsl:attribute name="value"><xsl:value-of select="//data/@comment"/></xsl:attribute></input -->
	    
	    <table border="0" cellpadding="3" cellspacing="0" width="100%" height="100%">
		<tr>
			<td align="center"><h2>Проведение платежа</h2></td>
		</tr>
		<tr height="100%">
			<td width="100%" align="center" valign="top" style="font-size: 10pt; font-weight: bold;">
				<table width="60%" border="0" cellpadding="5" cellspacing="1" class="table_show">
					<tr>
						<td class="td2"><b>Договор:</b></td>
						<td class="td2"><xsl:value-of select="contract/@title"/> (<xsl:value-of select="contract/@comment"/>) </td>
					</tr>
					<xsl:if test="contract/tariffs/@show=1">
						<tr>
							<td class="td3"><b>Тарифные планы:</b></td>
							<td class="td3">
								<xsl:for-each select="contract/tariffs/tariff">
									<xsl:if test="position() != 1">, </xsl:if>
									<xsl:value-of select="@title"/>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td class="td2"><b>Баланс:</b></td>
						<td class="td2"><xsl:value-of select="contract/@balance"/></td>
					</tr>
					<tr>
						<td class="td3"><b>Сумма:</b></td>
						<td class="td3"><input style="width:100%" type="text" name="summ" size="30"/></td>
					</tr>
					<tr>
						<td class="td2"><b>Тип платежа:</b></td>
						<td class="td2">
							<select name="pt" style="width:100%">
								<xsl:for-each select="//data/types/type">
									<option>
										<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
										<xsl:value-of select="@title"/>
									</option>
								</xsl:for-each>
							</select>
						</td>
					</tr>
					<tr>
						<td class="td3"><b>Комментарий</b></td>
						<td class="td3">
						<textarea name="comment" style="width:100%" rows="5"/></td>
					</tr>
				</table>
			</td>
		</tr>		
		<tr>
			<td align="right" width="100%" valign="bottom">
				<input type="submit" value="OK" class="butt"/>&#160;
				<input class="butt" type="button" value="Отмена">
					<xsl:attribute name="onClick">getBack()</xsl:attribute>
				</input>				
			</td>
		</tr>
		</table>	
	</form>	
</xsl:template>



<xsl:template name="Payments">

<div style="width:100%; height:100%; vertical-align:text-top; padding-top:10px">

<table class="table_show" cellpadding="5" cellspacing="1" align="center" width="100%">
    <tr>
		<td class="tdtitle" nowrap="1">Период с</td>
        <td class="tdtitle" id="date1" width="70"  onClick="editDate(1)" style="cursor:pointer"><xsl:value-of select="@date1"/></td>
        <td class="tdtitle">по</td>
        <td class="tdtitle" id="date2" width="70"  onClick="editDate(2)" style="cursor:pointer"><xsl:value-of select="@date2"/></td>
        <td class="tdtitle">Договор</td>
        <td class="tdtitle"><input id="contractTitle" type="text" size="8" value="{@contract}"/></td>
		<td class="tdtitle"><div class="link" onClick="paymentList(-1)">Вывести</div></td>
		<td class="tdtitle"><div class="link" onClick="paymentListPrint()">Печать</div></td>
		<td class="tdtitle"><div class="link" onClick="paymentListExport()">Экспорт</div></td>
		<td class="tdtitle" width="100%">&#xA0;</td>
<!--        <td class="tdtitle">Страница</td>-->
        <td class="tdtitle"><button id="firstPage"><xsl:attribute name="onClick">paymentList(<xsl:value-of select="@firstPage"/>)</xsl:attribute>&lt;&lt;</button></td>
        <td class="tdtitle"><button id="prevPage"><xsl:attribute name="onClick">paymentList(<xsl:value-of select="@prevPage"/>)</xsl:attribute>&lt;</button></td>
        <td class="tdtitle"  id="currentPage" nowrap="nowrap"><xsl:value-of select="@current_page"/></td>
        <td class="tdtitle"><button id="nextPage"><xsl:attribute name="onClick">paymentList(<xsl:value-of select="@nextPage"/>)</xsl:attribute>&gt;</button></td>
        <td class="tdtitle"><button id="lastPage"><xsl:attribute name="onClick">paymentList(<xsl:value-of select="@lastPage"/>)</xsl:attribute>&gt;&gt;</button></td>
    </tr>
</table><p/>

	<xsl:call-template name="paymentsTable">
		<xsl:with-param name="itogo" select="'true'"/>
	</xsl:call-template>
</div>	
</xsl:template>

<xsl:template name="PaymentAdded">
	<table border="0" cellpadding="3" cellspacing="0" width="100%" height="100%">
		<tr>
			<td align="center"><h2>Платеж проведен!</h2></td>
		</tr>
		<tr height="100%">
			<td align="center" class="txtb" width="100%"><xsl:value-of select="contract/@title"/> (<xsl:value-of select="contract/@comment"/>) текущий баланс <xsl:value-of select="contract/@balance"/></td>
		</tr>
		<tr>
			<td align="right" valign="bottom">
				<button>
					<xsl:attribute name="onClick">newSearch()</xsl:attribute>
					Новый платеж
				</button>&#160;
				<button class="w100">
					<xsl:attribute name="onClick">lastPaymentList()</xsl:attribute>
					Отчет
				</button>			
			</td>
		</tr>
	</table>
	
</xsl:template>


<xsl:template name="paymentsTable">
	<xsl:param name="itogo"/>
	<table class="table_show" cellpadding="5" cellspacing="1" align="center" width="100%">
		<thead>
			<tr>
				<td class="tdtitle" nowrap="1" align="center"># транзакции</td>
				<td class="tdtitle" align="center">дата</td>
				<td class="tdtitle" align="center">договор</td>
				<td class="tdtitle" align="center">коммент. договора</td>
				<td class="tdtitle hideable" align="center">коммент. платежа</td>
				<td class="tdtitle" align="center">сумма</td>
				<td class="tdtitle" align="center">&#xA0;</td>
			</tr>
		</thead>
		<tbody>
		<xsl:for-each select="/data/payments/payment">
			<tr>
				<td nowrap="nowrap"><xsl:call-template name="set_background"/><xsl:value-of select="@trans"/></td>
				<td nowrap="nowrap"><xsl:call-template name="set_background"/><xsl:value-of select="@date"/></td>
				<td nowrap="nowrap"><xsl:call-template name="set_background"/><xsl:value-of select="@contract"/></td>
				<td width="50%" ><xsl:call-template name="set_background"/><xsl:value-of select="@contract_comment"/></td>
				<td width="50%" class="hideable" ><xsl:call-template name="set_background"/><xsl:if test="@comment = ''">&#xA0;</xsl:if><xsl:value-of select="@comment"/></td>
				<td><xsl:call-template name="set_background"/><xsl:value-of select="@summ"/></td>
				<td>
					<xsl:call-template name="set_background"/>
									
					<xsl:choose>
					<xsl:when test="@status = 1">
						<div class="link"><xsl:attribute name="onclick">canselPayment(<xsl:value-of select="@cid"/>,<xsl:value-of select="@id"/>)</xsl:attribute>Отменить</div>
					</xsl:when>
					<xsl:otherwise>
						<font color="#666666">Отменен</font>
					</xsl:otherwise>
					</xsl:choose>				
				</td>
			</tr>
		</xsl:for-each>
		</tbody>
		<xsl:if test="$itogo">
		<tfoot>
			<tr>
				<td colspan="7" class="td2" align="right"><div class="txtred"><b>Всего платежей: </b> <xsl:value-of select="//data/payments/@number"/>,<b> на сумму: </b> <xsl:value-of select="//data/payments/@total"/></div></td>
			</tr>
		</tfoot>
		</xsl:if>
	</table>
</xsl:template>

<xsl:template name="paymentsTablePrint">
	<xsl:param name="itogo"/>
<!--	<html>
		<head>
			<title>BGBilling. Отчет по платежам c <xsl:value-of select="//data/@from"/> по <xsl:value-of select="//data/@until"/></title>
			<link href="stl.css" rel="stylesheet" type="text/css"/>
		</head>
	<body> -->
	<table class="table_show" cellpadding="5" cellspacing="0" align="center" width="100%">
		<thead>
			<tr>
				<td class="tdtitle" nowrap="1" align="center"># транзакции</td>
				<td class="tdtitle" align="center">дата</td>
				<td class="tdtitle" align="center">договор</td>
				<td class="tdtitle" align="center">коммент. договора</td>
				<td class="tdtitle hideable" align="center">коммент. платежа</td>
				<td class="tdtitle" align="center">сумма</td>
			</tr>
		</thead>
		<tbody>
		<xsl:for-each select="/data/payments/payment">
			<tr>
				<td nowrap="nowrap" align="center"><xsl:call-template name="set_background"/><xsl:value-of select="@trans"/></td>
				<td nowrap="nowrap" align="center"><xsl:call-template name="set_background"/><xsl:value-of select="@date"/></td>
				<td align="center"><xsl:call-template name="set_background"/><xsl:value-of select="@contract"/></td>
				<td align="center"><xsl:call-template name="set_background"/><xsl:value-of select="@contract_comment"/></td>
				<td class="center hideable"><xsl:call-template name="set_background"/><xsl:if test="@comment = ''">&#xA0;</xsl:if><xsl:value-of select="@comment"/></td>
				<td align="center"><xsl:call-template name="set_background"/><xsl:value-of select="@summ"/></td>
			</tr>
		</xsl:for-each>
		</tbody>
		<xsl:if test="$itogo">
		<tfoot>
			<tr>
				<td colspan="6" class="td2" align="right"><div class="txtred"><b>Всего платежей: </b> <xsl:value-of select="//data/payments/@number"/>,<b> на сумму: </b> <xsl:value-of select="//data/payments/@total"/></div></td>
			</tr>
		</tfoot>
		</xsl:if>
	</table>
<!--	</body>
	</html> -->
</xsl:template>

<xsl:template name="set_background">
	<xsl:choose>
		<xsl:when test="position() mod 2 = 0">
			<xsl:attribute name="class">td3</xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="class">td2</xsl:attribute>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="//calendar">
	<div id="calendar"  class="calendar" onmouseout="calendarOut()" onmouseover="calendarIn()">
		<table border="0" cellpadding="1" cellspacing="0" align="center">
			<thead>
				<tr>
					<td class="thc" style="cursor:default" height="23px"><div onclick="prevMonth()">&lt;</div></td>
					<td class="thc" colspan="5" style="cursor:default"><div  id="month" onclick="setDate(this)"></div></td>
					<td class="thc" style="cursor:default"><div onclick="nextMonth()">&gt;</div></td>
				</tr>
				<tr>
					<td class="thc" style="cursor:default">Пн</td>
					<td class="thc" style="cursor:default">Вт</td>
					<td class="thc" style="cursor:default">Ср</td>
					<td class="thc" style="cursor:default">Чт</td>
					<td class="thc" style="cursor:default">Пт</td>
					<td class="thc" style="cursor:default">Сб</td>
					<td class="thc" style="cursor:default">Вс</td>
				</tr>
			</thead>
			<tbody>
				<xsl:call-template name="week"><xsl:with-param name="count" select="0"/></xsl:call-template>
			</tbody>
		</table>		
	</div>
</xsl:template>

<xsl:template name="week">
	<xsl:param name="count"/>
		<tr>
			<xsl:call-template name="day"><xsl:with-param name="count" select="0"/></xsl:call-template>
		</tr>
	<xsl:variable name="count2" select="$count + 1"/>
	<xsl:if test="$count2 &lt; 6">
		<xsl:call-template name="week"><xsl:with-param name="count" select="$count2"/></xsl:call-template>
	</xsl:if>
</xsl:template>

<xsl:template name="day">
	<xsl:param name="count"/>
		<td>
		<div align="center" onclick="setDate(this)" onmouseover="lightOn(this)" onmouseout="lightOff(this)">
		</div>
		</td>
	<xsl:variable name="count2" select="$count + 1"/>
	<xsl:if test="$count2 &lt; 7">
		<xsl:call-template name="day"><xsl:with-param name="count" select="$count2"/></xsl:call-template>
	</xsl:if>
</xsl:template>


</xsl:stylesheet>
