/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.enaza.server.action.pub;

import bitel.billing.server.ActionBase;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaAccessToken;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaAccessTokenDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionEnaza
extends ActionBase {
    private static final String ENCODING = "utf-8";

    public void doAction() throws Exception {
        String shopId = this.getParameter("shop_id");
        String redirectUri = this.getParameter("redirect_uri");
        String redirectUriErr = this.getParameter("redirect_uri_err");
        String mode = this.getParameter("mode");
        String state = this.getParameter("state");
        String hash = this.getParameter("hash");
        String secret = this.moduleSetup.get("enaza.password", "123456");
        if (Utils.getDigest((String)(shopId + redirectUri + redirectUriErr + mode + state + secret), (String)ENCODING).toLowerCase().equals(hash)) {
            String contractTitle = this.getParameter("contractTitle");
            if (contractTitle != null) {
                String password = this.getParameter("password");
                ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());
                Contract contract = contractDao.getByTitle(contractTitle);
                contractDao.close();
                if (contract != null && contract.getPassword().equals(password)) {
                    if (new ContractModuleManager(this.con).getContractModuleSet(contract.getId()).contains(this.mid) && TimeUtils.dateInRange((Date)new Date(), (Date)contract.getDateFrom(), (Date)contract.getDateTo()) && !contract.isHidden()) {
                        ContractStatus contractStatus = new ContractStatusDao(this.con).getStatus(contract.getId(), LocalDate.now());
                        String statusActiveIds = this.moduleSetup.get("enaza3.contract.status.active.ids", null);
                        Set statusIds = Utils.toIntegerSet((String)statusActiveIds);
                        if (contractStatus == null || statusIds.contains(contractStatus.getStatus())) {
                            EnazaAccessTokenDao enazaAccessTokenDao = new EnazaAccessTokenDao(this.con, this.mid);
                            EnazaAccessToken enazaAccessToken = enazaAccessTokenDao.getEnazaAccessTokenByContractId(contract.getId());
                            if (enazaAccessToken == null) {
                                enazaAccessToken = new EnazaAccessToken();
                                enazaAccessToken.setContractId(contract.getId());
                            }
                            GregorianCalendar codeExpire = new GregorianCalendar();
                            ((Calendar)codeExpire).add(12, this.moduleSetup.getInt("enaza3.code.expire", 5));
                            enazaAccessToken.setCode(enazaAccessToken.generate());
                            enazaAccessToken.setCodeExpire(codeExpire.getTime());
                            enazaAccessTokenDao.update((Object)enazaAccessToken);
                            hash = Utils.getDigest((String)(enazaAccessToken.getCode() + state + secret), (String)ENCODING).toLowerCase();
                            StringBuilder url = new StringBuilder(redirectUri).append("?code=").append(URLEncoder.encode(enazaAccessToken.getCode(), ENCODING)).append("&state=").append(URLEncoder.encode(state, ENCODING)).append("&hash=").append(URLEncoder.encode(hash, ENCODING));
                            this.response.sendRedirect(url.toString());
                        } else {
                            this.sendError(redirectUriErr, state, secret, "invalid_agreement", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442/\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 [statusActiveIds=" + statusActiveIds + "; contractStatus=" + (Serializable)(contractStatus == null ? "?" : Integer.valueOf(contractStatus.getStatus())) + "]");
                        }
                    } else {
                        this.sendError(redirectUriErr, state, secret, "access_denied", "\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u0438/\u0438\u043b\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438/\u0438\u043b\u0438 \u0441\u043a\u0440\u044b\u0442\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                    }
                } else {
                    this.sendError(redirectUriErr, state, secret, "access_denied", "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043b\u043e\u0433\u0438\u043d \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c");
                }
            } else {
                this.request.setAttribute("contentType", (Object)"jsp");
                this.request.setAttribute("action", (Object)this.request.getParameter("action"));
                this.request.setAttribute("module", (Object)this.request.getParameter("module"));
                this.request.setAttribute("mid", (Object)this.request.getParameter("mid"));
                this.dataMap.put("shop_id", shopId);
                this.dataMap.put("redirect_uri", redirectUri);
                this.dataMap.put("redirect_uri_err", redirectUriErr);
                this.dataMap.put("mode", mode);
                this.dataMap.put("state", state);
                this.dataMap.put("hash", hash);
                this.request.setAttribute("page", (Object)"enaza/login.jsp");
            }
        } else {
            this.sendError(redirectUriErr, state, secret, "invalid_request", "\u041e\u0448\u0438\u0431\u043a\u0438 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435");
        }
    }

    private void sendError(String redirectUriErr, String state, String secret, String error, String errorDescription) throws IOException {
        String hash = Utils.getDigest((String)(error + errorDescription + state + secret), (String)ENCODING).toLowerCase();
        StringBuilder url = new StringBuilder(redirectUriErr).append("?error=").append(error).append("&error_description=").append(URLEncoder.encode(errorDescription, ENCODING)).append("&state=").append(URLEncoder.encode(state, ENCODING)).append("&hash=").append(URLEncoder.encode(hash, ENCODING));
        this.response.sendRedirect(url.toString());
    }
}

