/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ManagedBeanInfoManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceMap;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceType;
import ru.bitel.bgbilling.modules.tv.server.bean.TvDeviceDao;
import ru.bitel.bgbilling.modules.tv.server.event.TvReloadLocalEvent;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class TvDeviceRuntimeMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private final int moduleId;
    private ManagedBeanInfoManager<Object> beanInfoManager;
    private final boolean loadSaScripts;
    private volatile Map<Integer, TvDeviceRuntime> idMap;
    private Setup setup;
    private int rootDeviceId;

    public TvDeviceRuntimeMap(Setup setup, int moduleId, int rootDeviceId, boolean loadSaScripts) throws BGException {
        this.setup = setup;
        this.moduleId = moduleId;
        this.rootDeviceId = rootDeviceId;
        this.loadSaScripts = loadSaScripts;
        this.setup = setup;
        TvDeviceMap.getInstance((int)moduleId);
        EventProcessor.getInstance().addListener((EventListener)this, TvReloadLocalEvent.class, moduleId, null);
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof TvReloadLocalEvent) {
            this.load(ctx.getConnection());
        }
    }

    public TvDeviceRuntime get(Integer id) {
        return this.idMap.get(id);
    }

    public TvDeviceRuntime getAndLockSa(Integer id) {
        TvDeviceRuntime result = this.idMap.get(id);
        result.saInstances.lock();
        for (int i = 0; !(i >= 100 || result.saInstances != null && result.saInstances.isAlive()); ++i) {
            result.saInstances.unlock();
            result = this.idMap.get(id);
            result.saInstances.lock();
        }
        if (result.saInstances == null) {
            throw new IllegalStateException("saInstances == null");
        }
        if (!result.saInstances.isAlive()) {
            throw new IllegalStateException("saInstances == null");
        }
        return result;
    }

    public Collection<TvDeviceRuntime> values() {
        return this.idMap.values();
    }

    public Map<Integer, TvDeviceRuntime> getMap() {
        return this.idMap;
    }

    public synchronized void load(Connection con) throws BGException {
        logger.info("(Re)loading TvDeviceRuntimeMap");
        this.beanInfoManager = new ManagedBeanInfoManager();
        HashMap<Integer, TvDeviceRuntime> idMap = new HashMap<Integer, TvDeviceRuntime>();
        try (TvDeviceDao tvDeviceDao = new TvDeviceDao(con, this.moduleId, 0);){
            Object rootDevice = null;
            try {
                rootDevice = (TvDevice)tvDeviceDao.node(null, this.rootDeviceId, false);
            }
            catch (BGException e) {
                logger.error("Error rootDevice load.");
                throw e;
            }
            if (rootDevice == null) {
                throw new BGException("Not found rootDevice with id = " + this.rootDeviceId);
            }
            TvDeviceMap deviceMap = TvDeviceMap.getInstance((int)this.moduleId);
            this.loadDevice(this.setup, this.moduleId, deviceMap, idMap, tvDeviceDao, (TvDevice)rootDevice, null, this.loadSaScripts);
        }
        HashMap<String, ArrayList<TvDeviceRuntime>> identifierMap = new HashMap<String, ArrayList<TvDeviceRuntime>>();
        for (TvDeviceRuntime deviceRuntime : idMap.values()) {
            String identifier = deviceRuntime.tvDevice.getIdentifier();
            if (!Utils.notBlankString((String)identifier)) continue;
            ArrayList<TvDeviceRuntime> list = (ArrayList<TvDeviceRuntime>)identifierMap.get(identifier);
            if (list == null) {
                list = new ArrayList<TvDeviceRuntime>(2);
                identifierMap.put(identifier, list);
            }
            list.add(deviceRuntime);
        }
        final Map<Integer, TvDeviceRuntime> oldMap = this.idMap;
        this.idMap = idMap;
        if (oldMap != null) {
            new Thread("deviceRntm-destroy"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    for (TvDeviceRuntime deviceRuntime : oldMap.values()) {
                        deviceRuntime.saInstances.lock();
                        deviceRuntime.saInstances.unlock();
                    }
                    for (TvDeviceRuntime deviceRuntime : oldMap.values()) {
                        deviceRuntime.saInstances.lock();
                        try {
                            deviceRuntime.saInstances.destroy();
                        }
                        finally {
                            deviceRuntime.saInstances.unlock();
                        }
                    }
                }
            }.start();
        }
    }

    private void loadDevice(Setup setup, int moduleId, TvDeviceMap deviceMap, Map<Integer, TvDeviceRuntime> map, TvDeviceDao tvDeviceDao, TvDevice tvDevice, TvDeviceRuntime parentInstance, boolean initScripts) throws BGException {
        TvDeviceMap.TvDeviceMapItem item = deviceMap.get(tvDevice.getId());
        TvDeviceRuntime instance = new TvDeviceRuntime(setup, moduleId, tvDevice, (TvDeviceType)tvDevice.getDeviceType(), parentInstance, item.getDescendantIds(), item.getConfig(), this.beanInfoManager, initScripts);
        map.put(tvDevice.getId(), instance);
        List children = tvDevice.getChildren();
        if (children != null && children.size() > 0) {
            for (TvDevice child : children) {
                this.loadDevice(setup, moduleId, deviceMap, map, tvDeviceDao, child, instance, initScripts);
            }
        }
    }

    public Map<String, TvDeviceRuntime> getDescendantMap(TvDeviceRuntime parent) {
        Map<String, TvDeviceRuntime> descendantMap = parent.descendantMap;
        if (descendantMap == null) {
            descendantMap = new HashMap<String, TvDeviceRuntime>();
            for (Integer id : parent.descendantIds) {
                TvDeviceRuntime child = this.get(id);
                if (child == null) continue;
                String identifier = child.tvDevice.getIdentifier();
                if (identifier != null) {
                    descendantMap.put(identifier.toLowerCase(), child);
                    continue;
                }
                logger.error("Identifier is null");
            }
            parent.descendantMap = descendantMap;
        }
        return descendantMap;
    }
}

