/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptServiceCost;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContext;

public class PacketCountFilterTariffTreeNode
extends ModuleServiceTariffTreeNode<CerbercryptTariffContext, CerbercryptServiceCost, CerbercryptTariffRequest> {
    private static final int LESS = 1;
    private static final int LESS_OR_EQ = 2;
    private static final int EQ = 3;
    private static final int MORE_OR_EQ = 4;
    private static final int MORE = 5;
    private int packetCount = -1;
    private int compare = -1;
    private boolean exclude_discount_ignore = false;
    private boolean only_current_packet = false;
    private boolean on_contract_total = false;

    public PacketCountFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.packetCount = parameterMap.getInt("packet_count", 1);
        String compare = parameterMap.get("compare");
        if ("<".equals(compare)) {
            this.compare = 1;
        } else if ("<=".equals(compare)) {
            this.compare = 2;
        } else if ("=".equals(compare)) {
            this.compare = 3;
        } else if (">=".equals(compare)) {
            this.compare = 4;
        } else if (">".equals(compare)) {
            this.compare = 5;
        }
        this.exclude_discount_ignore = parameterMap.getBoolean("exclude_discount_ignore", false);
        this.only_current_packet = parameterMap.getBoolean("only_current_packet", false);
        this.on_contract_total = parameterMap.getBoolean("on_contract_total", false);
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, CerbercryptTariffRequest tariffRequest, TariffTreeNodeHolder holder, CerbercryptTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        int packetCount = tariffRequest.getPacketCount();
        int packetMinus = tariffRequest.getPacketMinus();
        if (this.on_contract_total) {
            if (this.only_current_packet) {
                packetCount = tariffRequest.getPacketCountOnContractCurrent();
                packetMinus = tariffRequest.getPacketMinusOnContractCurrent();
            } else {
                packetCount = tariffRequest.getPacketCountOnContract();
                packetMinus = tariffRequest.getPacketMinusOnContract();
            }
        }
        if (this.exclude_discount_ignore) {
            packetCount -= packetMinus;
        }
        if (packetCount >= 0) {
            boolean check = false;
            switch (this.compare) {
                case 1: {
                    check = packetCount < this.packetCount;
                    break;
                }
                case 2: {
                    check = packetCount <= this.packetCount;
                    break;
                }
                case 3: {
                    check = packetCount == this.packetCount;
                    break;
                }
                case 4: {
                    check = packetCount >= this.packetCount;
                    break;
                }
                case 5: {
                    boolean bl = check = packetCount > this.packetCount;
                }
            }
            if (check) {
                this.executeChildren(parentTreeNodeId, tariffRequest, holder, tariffContext, treeContext, workerContext);
            }
        }
        return 1;
    }
}

