/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.action;

import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.dialup.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.dialup.server.bean.CalculatePeriod;
import ru.bitel.bgbilling.modules.dialup.server.bean.CalculatePeriodManager;
import ru.bitel.common.TimeUtils;

public class ActionPeriod
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", 0);
        if (this.cid <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        boolean secondCalculatePeriod = this.moduleSetup.getBoolean("second.calculate.period", false);
        CalculatePeriodManager man = new CalculatePeriodManager(this.con, this.mid);
        if (id > 0) {
            CalculatePeriod period = man.getPeriod(this.cid, id);
            Element periodEl = this.createElement(this.rootNode, "period");
            periodEl.setAttribute("id", String.valueOf(period.getId()));
            periodEl.setAttribute("cid", String.valueOf(period.getCid()));
            periodEl.setAttribute("start", TimeUtils.formatDate((Calendar)period.getStart()));
            periodEl.setAttribute("end", TimeUtils.formatDate((Calendar)period.getEnd()));
        } else {
            List<CalculatePeriod> periodList = man.getPeriodList(this.cid);
            Element table = this.createElement(this.rootNode, "table");
            Element data = this.createElement(table, "data");
            Element row = null;
            for (CalculatePeriod period : periodList) {
                row = this.createElement(data, "row");
                row.setAttribute("id", String.valueOf(period.getId()));
                row.setAttribute("cid", String.valueOf(period.getCid()));
                if (secondCalculatePeriod) {
                    row.setAttribute("start", TimeUtils.format((Calendar)period.getStart(), (String)"dd.MM.yyyy HH:mm:ss"));
                    row.setAttribute("end", TimeUtils.format((Calendar)period.getEnd(), (String)"dd.MM.yyyy HH:mm:ss"));
                    continue;
                }
                row.setAttribute("start", TimeUtils.formatDate((Calendar)period.getStart()));
                row.setAttribute("end", TimeUtils.formatDate((Calendar)period.getEnd()));
            }
        }
    }
}

