/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.ipn.server.bean.Zone;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ZoneManager {
    private Connection con;
    private String tableName;

    public ZoneManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "ipn_zone_" + mid;
    }

    public List<Zone> getZoneList() {
        ArrayList<Zone> result = new ArrayList<Zone>();
        result.addAll(this.getPredefineZones());
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getZoneFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Zone getZone(int id) {
        Zone result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=" + id;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getZoneFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, Zone> getZoneMap() {
        HashMap<Integer, Zone> result = new HashMap<Integer, Zone>();
        for (Zone zone : this.getPredefineZones()) {
            result.put(zone.getId(), zone);
        }
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Zone zone = this.getZoneFromRs(rs);
                result.put(zone.getId(), zone);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateZone(Zone zone) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (zone.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (title) VALUES (?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET title=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(2, zone.getId());
            }
            ps.setString(1, zone.getTitle());
            ps.executeUpdate();
            if (zone.getId() <= 0) {
                zone.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteZone(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Zone> getPredefineZones() {
        ArrayList<Zone> result = new ArrayList<Zone>();
        result.add(new Zone(-1, "\u041d\u0435\u0442 \u0437\u043e\u043d\u044b"));
        result.add(new Zone(-2, "\u0421\u0432\u043e\u044f \u0437\u043e\u043d\u0430"));
        result.add(new Zone(-3, "\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u0437\u043e\u043d\u0430"));
        return result;
    }

    private Zone getZoneFromRs(ResultSet rs) throws SQLException {
        Zone result = new Zone();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        return result;
    }
}

