/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocSendLog;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentSendMode;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class BillDocSendLogDao
extends AbstractDao<BillDocSendLog> {
    public BillDocSendLogDao(Connection con, int moduleId) {
        super(con, moduleId, "bill_doc_send_log");
    }

    protected BillDocSendLog getFromRS(ResultSet rs) throws SQLException {
        return new BillDocSendLog().setId(rs.getString("id")).setDocumentType(DocumentType.valueOf((String)rs.getString("doc_type"))).setDocumentId(rs.getInt("doc_id")).setSendTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("send_time"))).setSendMode(DocumentSendMode.valueOf((String)rs.getString("send_mode"))).setSendAddress(rs.getString("send_address")).setSendStatus(rs.getString("send_status")).setSendStatusMessage(rs.getString("send_status_message")).setSendUserId(rs.getInt("send_user_id"));
    }

    protected void updateImpl(BillDocSendLog billDocSendLog) throws SQLException {
        Objects.requireNonNull(billDocSendLog);
        boolean update = billDocSendLog.getId() != null;
        String querySet = "doc_type=?, doc_id=?, send_time=?, send_mode=?, send_address=?, send_status=?, send_status_message=?, send_user_id=?";
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET " + querySet + (update ? " WHERE id=?" : ", id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (!update) {
                billDocSendLog.setId(Utils.randomUUIDv7().toString());
            }
            int index = 1;
            ps.setString(index++, billDocSendLog.getDocumentType().name());
            ps.setInt(index++, billDocSendLog.getDocumentId());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)billDocSendLog.getSendTime()));
            ps.setString(index++, billDocSendLog.getSendMode().name());
            ps.setString(index++, billDocSendLog.getSendAddress());
            ps.setString(index++, billDocSendLog.getSendStatus());
            ps.setString(index++, billDocSendLog.getSendStatusMessage());
            ps.setInt(index++, billDocSendLog.getSendUserId());
            ps.setString(index++, billDocSendLog.getId());
            ps.executeUpdate();
        }
    }
}

