/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc.atolonlinev4;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.json.JSONTokener;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.BGFiscConnectException;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckFiscalData;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.function.ThrowingConsumer;

public class AtolOnlineV4Fiscalizator
extends Fiscalizator {
    protected String addr = null;
    protected String groupcode = null;
    private String login = null;
    private String password = null;
    private int timeout = -1;
    private volatile String token = null;
    protected static Logger logger = LogManager.getLogger();
    protected String company_email = null;
    protected String company_inn = null;
    protected String company_payment_address = null;
    private static String OPERATION_SELL = "sell";
    private static String OPERATION_SELL_REFUND = "sell_refund";
    private static String OPERATION_SELL_CORRECTION = "sell_correction";
    private static String OPERATION_SELL_REFUND_CORRECTION = "sell_refund_correction";

    public AtolOnlineV4Fiscalizator(Printer printer) throws BGException {
        super(printer);
        ParameterMap config = printer.getConfig();
        this.addr = config.get("addr", "addr-not-specified");
        if (this.addr.endsWith("/")) {
            this.addr = this.addr.substring(0, this.addr.length() - 1);
        }
        this.groupcode = config.get("groupcode", "groupcode-not-specified");
        this.login = config.get("login", "login-not-specified");
        this.password = config.get("pass", "");
        this.timeout = config.getInt("timeout", this.timeout);
        this.company_email = config.get("company.email", "");
        this.company_inn = config.get("company.inn", "");
        this.company_payment_address = config.get("company.payment_address", "");
    }

    protected BigDecimal vat_calc(BigDecimal sum, String vat_type) throws BGMessageException {
        switch (vat_type) {
            default: {
                throw new BGMessageException(vat_type + " \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 vat");
            }
            case "none": {
                return CashCheckUtils.vatCalc(sum, 1000999);
            }
            case "vat0": {
                return CashCheckUtils.vatCalc(sum, 1000000);
            }
            case "vat10": {
                return CashCheckUtils.vatCalc(sum, 1000010);
            }
            case "vat110": {
                return CashCheckUtils.vatCalc(sum, 1000110);
            }
            case "vat20": {
                return CashCheckUtils.vatCalc(sum, 1000020);
            }
            case "vat120": {
                return CashCheckUtils.vatCalc(sum, 1000120);
            }
            case "vat5": {
                return CashCheckUtils.vatCalc(sum, 1000005);
            }
            case "vat105": {
                return CashCheckUtils.vatCalc(sum, 1000105);
            }
            case "vat7": {
                return CashCheckUtils.vatCalc(sum, 1000007);
            }
            case "vat107": 
        }
        return CashCheckUtils.vatCalc(sum, 1000107);
    }

    protected String vat_convert(Integer vat) {
        if (vat == null) {
            return null;
        }
        switch (vat) {
            default: {
                return "none";
            }
            case 0: 
            case 1000000: {
                return "vat0";
            }
            case 10: 
            case 1000010: {
                return "vat10";
            }
            case 18: 
            case 1000018: {
                return "vat18";
            }
            case 110: 
            case 1000110: {
                return "vat110";
            }
            case 118: 
            case 1000118: {
                return "vat118";
            }
            case 20: 
            case 1000020: {
                return "vat20";
            }
            case 120: 
            case 1000120: {
                return "vat120";
            }
            case 1000005: {
                return "vat5";
            }
            case 1000105: {
                return "vat105";
            }
            case 1000007: {
                return "vat7";
            }
            case 1000107: 
        }
        return "vat107";
    }

    protected int payment_type_convert(Integer payment_type) {
        if (payment_type == null) {
            return 1;
        }
        switch (payment_type) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
        }
        return payment_type;
    }

    protected static String payMethod_convert(Integer payMethod) {
        if (payMethod == null) {
            return null;
        }
        switch (payMethod) {
            default: {
                return null;
            }
            case 1: 
            case 1214001: {
                return "full_prepayment";
            }
            case 2: 
            case 1214002: {
                return "prepayment";
            }
            case 3: 
            case 1214003: {
                return "advance";
            }
            case 4: 
            case 1214004: {
                return "full_payment";
            }
            case 5: 
            case 1214005: {
                return "partial_payment";
            }
            case 6: 
            case 1214006: {
                return "credit";
            }
            case 7: 
            case 1214007: 
        }
        return "credit_payment";
    }

    private static String payObject_convert(Integer payObject) {
        if (payObject == null) {
            return null;
        }
        switch (payObject) {
            default: {
                return null;
            }
            case 1: 
            case 1212001: {
                return "commodity";
            }
            case 3: 
            case 1212003: {
                return "job";
            }
            case 4: 
            case 1212004: {
                return "service";
            }
            case 10: 
            case 1212010: {
                return "payment";
            }
            case 11: 
            case 1212011: {
                return "agent_commission";
            }
            case 13: 
            case 1212013: 
        }
        return "another";
    }

    public CheckPrintResult operation(String operation, final Check check) throws BGException {
        JSONObject data;
        logger.debug("get operation " + operation + "...");
        String token = this.getToken();
        final Date documentDate = check.getDocumentDate() != null ? check.getDocumentDate() : new Date();
        final String external_id = check.getDocumentId();
        if (external_id == null) {
            throw new BGMessageException("\u0412 \u0441\u043a\u0440\u0438\u043f\u0442\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0447\u0435\u043a\u0430 documentId");
        }
        String customerAddr = check.getCustomerEmail();
        if (customerAddr == null) {
            throw new BGMessageException("\u0412 \u0441\u043a\u0440\u0438\u043f\u0442\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d customerEmail");
        }
        final String email = customerAddr.contains("@") ? customerAddr : null;
        final String phone = !customerAddr.contains("@") ? customerAddr.replace(" ", "") : null;
        final String vat_type_total = this.vat_convert(check.getTax());
        final int payments_type = this.payment_type_convert(check.getPaymentType());
        final String payMethodTotal = AtolOnlineV4Fiscalizator.payMethod_convert(check.getPayMethod());
        final String payObjectTotal = AtolOnlineV4Fiscalizator.payObject_convert(check.getPayObject());
        String url = this.addr + "/" + this.groupcode + "/" + operation;
        JSONObject reply = this.doJsonRequest("POST", url, data = new JSONObject((Map)new HashMap<String, Object>(){
            {
                this.put("timestamp", TimeUtils.format((Date)documentDate, (String)"dd.MM.yyyy HH:mm:ss"));
                this.put("external_id", external_id);
                this.put("receipt", new HashMap<String, Object>(){
                    {
                        Long attr_internet;
                        this.put("client", new HashMap<String, Object>(){
                            {
                                if (email != null) {
                                    this.put("email", email);
                                }
                                if (phone != null) {
                                    this.put("phone", phone);
                                }
                            }
                        });
                        this.put("company", new HashMap<String, Object>(){
                            {
                                this.put("email", AtolOnlineV4Fiscalizator.this.company_email);
                                this.put("inn", AtolOnlineV4Fiscalizator.this.company_inn);
                                this.put("payment_address", AtolOnlineV4Fiscalizator.this.company_payment_address);
                            }
                        });
                        this.put("items", new ArrayList<HashMap<String, Object>>(){
                            {
                                for (final Check.CheckLine line : check.getLines()) {
                                    if (line.summa == null) continue;
                                    final String payMethod = line.payMethod != null ? AtolOnlineV4Fiscalizator.payMethod_convert(line.payMethod) : payMethodTotal;
                                    final String payObject = line.payObject != null ? AtolOnlineV4Fiscalizator.payObject_convert(line.payObject) : payObjectTotal;
                                    final String vat_type = line.tax != null ? AtolOnlineV4Fiscalizator.this.vat_convert(line.tax) : vat_type_total;
                                    this.add(new HashMap<String, Object>(){
                                        {
                                            this.put("name", line.text);
                                            this.put("price", line.summa);
                                            this.put("quantity", 1);
                                            this.put("sum", line.summa);
                                            if (payMethod != null) {
                                                this.put("payment_method", payMethod);
                                            }
                                            if (payObject != null) {
                                                this.put("payment_object", payObject);
                                            } else {
                                                this.put("payment_object", "service");
                                            }
                                            this.put("vat", new HashMap<String, Object>(){
                                                {
                                                    this.put("type", vat_type);
                                                    this.put("sum", AtolOnlineV4Fiscalizator.this.vat_calc(line.summa, vat_type));
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        });
                        this.put("payments", new ArrayList<HashMap<String, Object>>(){
                            {
                                this.add(new HashMap<String, Object>(){
                                    {
                                        this.put("type", payments_type);
                                        this.put("sum", check.getPaymentsum());
                                    }
                                });
                            }
                        });
                        this.put("total", check.getPaymentsum());
                        if (check.getCashierName() != null) {
                            this.put("cashier", check.getCashierName());
                        }
                        if ((attr_internet = (Long)check.getCustomTags().get(1125)) != null) {
                            this.put("internet", attr_internet == 1L);
                        }
                    }
                });
            }
        }), token, true);
        if (!reply.has("uuid")) {
            throw new BGException("protocol error: no uuid field in response");
        }
        String uuid = reply.getString("uuid");
        return CheckPrintResult.async(uuid);
    }

    public CheckPrintResult _operation(String operation, Check check) throws BGException {
        if (check.getCheckType() != null) {
            String newoperation = null;
            switch (check.getCheckType()) {
                case PAYMENT: {
                    newoperation = OPERATION_SELL;
                    break;
                }
                case PAYMENTREFUND: {
                    newoperation = OPERATION_SELL_REFUND;
                    break;
                }
                case PAYMENTCORRECTION: {
                    newoperation = OPERATION_SELL_CORRECTION;
                    throw new BGException("checkType=PAYMENTCORRECTION \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u044d\u0442\u043e\u043c \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0435");
                }
                case PAYMENTREFUNDCORRECTION: {
                    newoperation = OPERATION_SELL_REFUND_CORRECTION;
                    throw new BGException("checkType=PAYMENTREFUNDCORRECTION \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u044d\u0442\u043e\u043c \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0435");
                }
            }
            if (!operation.equals(newoperation)) {
                logger.debug("overwrite check type from " + operation + " to " + newoperation);
                operation = newoperation;
            }
        }
        return this.operation(operation, check);
    }

    @Override
    public CheckPrintResult check(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        return this._operation(OPERATION_SELL, check);
    }

    @Override
    public CheckPrintResult checkreturn(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        return this._operation(OPERATION_SELL_REFUND, check);
    }

    private static CashCheckUtils.HttpReply doHttpRequest(String method, String url, String body, final String token, int timeout) throws BGException, BGFiscConnectException {
        HashMap<String, String> requestProperties = new HashMap<String, String>(){
            {
                this.put("Content-type", "application/json; charset=utf-8");
                if (token != null) {
                    this.put("Token", token);
                }
            }
        };
        return CashCheckUtils.doHttpRequest(method, url, body, (Map<String, String>)requestProperties, timeout, logger);
    }

    private String formatErrorText(JSONObject error, Integer httpCode) {
        String error_id = error.has("error_id") && !error.isNull("error_id") ? error.getString("error_id") : "[none]";
        int code = error.getInt("code");
        String text = error.getString("text");
        String type = error.getString("type");
        String http = httpCode != null ? httpCode.toString() : "-";
        return String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0410\u0422\u041e\u041b-\u041e\u043d\u043b\u0430\u0439\u043d: %s\n\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e: code: %s, type: %s, http: %s, id: %s", text, code, type, http, error_id);
    }

    protected JSONObject doJsonRequest(String method, String url, JSONObject data, String token, boolean throwException) throws BGException, BGFiscConnectException {
        String body = null;
        if (data != null) {
            try {
                body = data.toString(0);
            }
            catch (Exception e) {
                throw new BGException("error dump json to request: " + e.getMessage(), (Throwable)e);
            }
        }
        CashCheckUtils.HttpReply reply = AtolOnlineV4Fiscalizator.doHttpRequest(method, url, body, token, this.timeout);
        JSONObject fullresponse = null;
        try {
            JSONTokener tokener = new JSONTokener(reply.body);
            fullresponse = (JSONObject)tokener.nextValue();
        }
        catch (Exception e) {
            if (reply.code == 200) {
                throw new BGException("error parse json from http-200 response: " + e.getMessage(), (Throwable)e);
            }
            String msg = reply.body.length() <= 200 ? reply.body : reply.body.substring(0, 100) + " ... " + reply.body.substring(reply.body.length() - 100);
            throw new BGException("error response: http-" + reply.code + ": " + msg, (Throwable)e);
        }
        if (throwException && fullresponse.has("error") && !fullresponse.isNull("error")) {
            try {
                JSONObject error = fullresponse.getJSONObject("error");
                throw new BGMessageException(this.formatErrorText(error, reply.code));
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException("error parse error-message from response: " + e.getMessage(), (Throwable)e);
            }
        }
        return fullresponse;
    }

    protected String getToken() throws BGException {
        if (this.token == null) {
            logger.debug("get token...");
            String url = this.addr + "/getToken";
            JSONObject data = new JSONObject((Map)new HashMap<String, Object>(){
                {
                    this.put("login", AtolOnlineV4Fiscalizator.this.login);
                    this.put("pass", AtolOnlineV4Fiscalizator.this.password);
                }
            });
            JSONObject reply = this.doJsonRequest("POST", url, data, null, true);
            if (!reply.has("token")) {
                throw new BGException("protocol error: no token field in response");
            }
            this.token = reply.getString("token");
        }
        return this.token;
    }

    @Override
    public String status(String pass) throws BGException {
        this.getToken();
        return "ok";
    }

    @Override
    public String name(String pass) throws BGException {
        return "\u0410\u0422\u041e\u041b-\u041e\u043d\u043b\u0430\u0439\u043d";
    }

    @Override
    public String getFiscalizatorStatus() throws BGException {
        return "\u0410\u0434\u0440\u0435\u0441: " + this.addr + "\n\u041a\u043e\u0434 \u0433\u0440\u0443\u043f\u043f\u044b: " + this.groupcode;
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    public Fiscalizator.CheckResult report(String uuid) throws BGException {
        String status;
        logger.debug("get report " + uuid + "...");
        String token = this.getToken();
        String url = this.addr + "/" + this.groupcode + "/report/" + uuid;
        JSONObject reply = this.doJsonRequest("GET", url, null, token, false);
        if (!reply.has("status")) {
            throw new BGException("protocol error: no \"status\" field in report-response");
        }
        switch (status = reply.getString("status")) {
            case "done": {
                if (!reply.has("payload") || reply.isNull("payload")) {
                    throw new BGException("protocol error: no \"payload\" field with \"status:done\" in report-response");
                }
                JSONObject payloadJson = reply.getJSONObject("payload");
                return Fiscalizator.CheckResult.ok(uuid, this.fiscalDataConvert(payloadJson));
            }
            case "fail": {
                if (!reply.has("error") || reply.isNull("error")) {
                    throw new BGException("protocol error: no \"error\" field with \"status:fail\" in report-response");
                }
                JSONObject errorJson = reply.getJSONObject("error");
                String errorText = this.formatErrorText(errorJson, null);
                return Fiscalizator.CheckResult.error(uuid, errorText);
            }
            case "wait": {
                return Fiscalizator.CheckResult.wait(uuid);
            }
        }
        throw new BGException("protocol error: error value \"status\" field in report-response: \"" + status + "\"");
    }

    private CheckFiscalData fiscalDataConvert(JSONObject payloadJson) {
        CheckFiscalData cfd = new CheckFiscalData();
        cfd.time(payloadJson.optString("receipt_datetime", null), "dd.MM.yyyy HH:mm:ss");
        cfd.total = payloadJson.optBigDecimal("total", null);
        cfd.fn = payloadJson.optString("fn_number", null);
        cfd.fd = payloadJson.optString("fiscal_document_number", null);
        cfd.fp = payloadJson.optString("fiscal_document_attribute", null);
        cfd.ofd_receipt_url = payloadJson.optString("ofd_receipt_url", null);
        cfd.ofd_inn = payloadJson.optString("ofd_inn", null);
        cfd.fillAttrs(payloadJson.toMap(), "receipt_datetime", "total", "fn_number", "fiscal_document_number", "fiscal_document_attribute", "ofd_receipt_url", "ofd_inn");
        return cfd;
    }

    @Override
    public void checkPending(List<String> pendingIds, long timeout, ThrowingConsumer<Fiscalizator.CheckResult> eachResult) throws BGException {
        for (String pendingId : pendingIds) {
            eachResult.accept((Object)this.report(pendingId));
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException e) {
                throw new BGException("InterruptedException");
            }
        }
    }
}

