/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class ListValueDirectory
extends BGPanel
implements ActionListener {
    private BGUList<BGUListItem> paramList = new BGUList();
    private BGUList<BGUListItem> valuesList = new BGUList();
    private ContractObjectService contractObjectService;

    public ListValueDirectory() {
        this.jbInit();
        ClientUtils.addShowCodeListener(this.valuesList);
    }

    private void jbInit() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons((ActionListener)this);
        toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        JPanel paramViewer = new JPanel(new GridBagLayout());
        paramViewer.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        paramViewer.add((Component)new JScrollPane((Component)this.valuesList), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGSplitPaneNoBorder mainSplit = new BGSplitPaneNoBorder(0, (Component)this.getParamPanel(), (Component)paramViewer, 500L);
        this.setLayout(new GridBagLayout());
        this.add((Component)mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.paramList.setSelectionMode(0);
        this.paramList.getSelectionModel().addListSelectionListener(a -> {
            if (!a.getValueIsAdjusting()) {
                this.showValues();
            }
        });
        BGSwingUtilites.handleLDMouseClicked(this.valuesList, e -> this.actionPerformed(new ActionEvent(this, 0, "editItem")));
    }

    private JPanel getParamPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.paramList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setData() throws Exception {
        this.paramList.setData(this.getContractObjectService().getListParameters().stream().map(a -> new BGUListItem((IdTitle)a)).toList());
    }

    private void showValues() {
        this.paramList.optSelectedValue().ifPresentOrElse(item -> {
            try {
                this.valuesList.setData(this.getContractObjectService().getValuesForListParameter(item.getId()).stream().map(a -> new BGUListItem((IdTitle)a)).toList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }, () -> this.valuesList.setData(Collections.emptyList()));
    }

    private void deleteValue() {
        int valueId = this.valuesList.optSelectedValue().map(a -> a.getId()).orElse(-1);
        if (valueId > 0 && ClientUtils.confirmDelete((Object)"\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435")) {
            try {
                this.getContractObjectService().deleteListParameterValue(valueId);
                this.showValues();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            if (command.equals("newItem")) {
                this.paramList.optSelectedValue().ifPresentOrElse(a -> new ListValueEditor("\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430", new ListValue(0, "").setParamId(a.getId())).open(), () -> ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440"));
            }
            if (command.equals("editItem")) {
                this.valuesList.optSelectedValue().ifPresentOrElse(item -> new ListValueEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430", new ListValue(item.getId(), item.getTitle())).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!"));
            } else if (command.equals("deleteItem")) {
                this.deleteValue();
            }
        }
    }

    private ContractObjectService getContractObjectService() {
        if (this.contractObjectService == null) {
            this.contractObjectService = (ContractObjectService)this.getContext().getWebService(ContractObjectService.class, 0);
        }
        return this.contractObjectService;
    }

    class ListValueEditor
    extends BGEditorDialog<ListValue> {
        private BGTextField valueTitle_TF;

        public ListValueEditor(String title, ListValue data) {
            super(title, (Object)data);
            this.valueTitle_TF = new BGTextField(40);
        }

        public void doDialogPanel() {
            this.addFieldV("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435: ", (JComponent)this.valueTitle_TF);
            this.valueTitle_TF.setText(((ListValue)((Object)this.data)).getTitle());
        }

        public boolean doApply() throws Exception {
            int paramId = ListValueDirectory.this.paramList.optSelectedValue().map(a -> a.getId()).orElse(-1);
            if (paramId < 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440!");
                return false;
            }
            String title = this.valueTitle_TF.getText();
            if (Utils.isBlankString((String)title)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return false;
            }
            try {
                ListValue value = new ListValue(((ListValue)((Object)this.data)).getId(), title).setParamId(paramId);
                ListValueDirectory.this.getContractObjectService().updateListParameterValue(value);
                ListValueDirectory.this.showValues();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }
}

