/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class PacketManager {
    private Connection con;
    private int mid;

    public PacketManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public void updatePacket(Packet packet) throws BGException {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (packet.getId() <= 0) {
                query = "INSERT INTO packet_" + this.mid + " (title, sid, can_web_open, can_web_close, virtual_cinema, depends, unacceptable, free, pcode, comment, server_code) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE packet_" + this.mid + " SET title=?, sid=?, can_web_open=?, can_web_close=?, virtual_cinema=?, depends=?, unacceptable=?, free=?, pcode=?, comment=?, server_code=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(12, packet.getId());
            }
            ps.setString(1, packet.getTitle());
            ps.setInt(2, packet.getServiceId());
            ps.setBoolean(3, packet.isCanWebOpen());
            ps.setBoolean(4, packet.isCanWebClose());
            ps.setBoolean(5, packet.isVirtualCinema());
            ps.setString(6, Utils.toString((Iterable)packet.getDepends()));
            ps.setString(7, Utils.toString((Iterable)packet.getUnacceptable()));
            ps.setBoolean(8, packet.getFree());
            ps.setString(9, Utils.notBlankString((String)packet.getPacketCode()) ? packet.getPacketCode().trim() : null);
            ps.setString(10, packet.getComment());
            ps.setString(11, Utils.notBlankString((String)packet.getPacketServerCode()) ? packet.getPacketServerCode().trim() : null);
            ps.executeUpdate();
            if (packet.getId() <= 0) {
                packet.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<Packet> getPacketList() throws BGException {
        ArrayList<Packet> result = new ArrayList<Packet>();
        try {
            String query = "SELECT * FROM packet_" + this.mid + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Packet packet = new Packet();
                result.add(packet);
                PacketManager.loadPacketFromRS(rs, packet);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<Packet> getPacketList(boolean cinema) throws BGException {
        ArrayList<Packet> result = new ArrayList<Packet>();
        try {
            String query = "SELECT * FROM packet_" + this.mid + " WHERE virtual_cinema=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setBoolean(1, cinema);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Packet packet = new Packet();
                result.add(packet);
                PacketManager.loadPacketFromRS(rs, packet);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public Map<Integer, Packet> getPacketMap() throws BGException {
        HashMap<Integer, Packet> result = new HashMap<Integer, Packet>(10);
        try {
            String query = "SELECT * FROM packet_" + this.mid;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Packet packet = new Packet();
                PacketManager.loadPacketFromRS(rs, packet);
                result.put(packet.getId(), packet);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public Packet getPacketById(int id) throws BGException {
        Packet result = null;
        try {
            String query = "SELECT * FROM packet_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Packet();
                PacketManager.loadPacketFromRS(rs, result);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void deletePacket(int id) throws BGException {
        try {
            String query = "DELETE FROM packet_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private static void loadPacketFromRS(ResultSet rs, Packet packet) throws SQLException {
        packet.setId(rs.getInt("id"));
        packet.setTitle(rs.getString("title"));
        packet.setServiceId(rs.getInt("sid"));
        packet.setCanWebOpen(rs.getBoolean("can_web_open"));
        packet.setCanWebClose(rs.getBoolean("can_web_close"));
        packet.setVirtualCinema(rs.getBoolean("virtual_cinema"));
        packet.setFree(rs.getBoolean("free"));
        packet.setDepends(Utils.toIntegerList((String)rs.getString("depends")));
        packet.setUnacceptable(Utils.toIntegerList((String)rs.getString("unacceptable")));
        packet.setPacketCode(rs.getString("pcode"));
        packet.setComment(rs.getString("comment"));
        packet.setPacketServerCode(rs.getString("server_code"));
    }
}

