/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.bean;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.ReportUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginManager;
import ru.bitel.bgbilling.modules.dialup.server.bean.TrafficShowConfig;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public final class DialUpReportUtils
extends ReportUtils {
    public DialUpReportUtils(Connection con, int mid, Preferences moduleSetup) {
        super(con, mid, moduleSetup);
        this.loginManager = new DialUpLoginManager(con, mid);
    }

    public void addSessions(ResultSet rs, Element data) {
        try {
            TrafficShowConfig tc = new TrafficShowConfig(this.moduleSetup.get("traffics", null));
            if (rs != null) {
                while (rs.next()) {
                    Element element = data.getOwnerDocument().createElement("row");
                    data.appendChild(element);
                    element.setAttribute("id", rs.getString("id"));
                    element.setAttribute("login", rs.getString("login_name"));
                    element.setAttribute("log_id", rs.getString("lr"));
                    Timestamp session_start = rs.getTimestamp("session_start");
                    Timestamp session_stop = rs.getTimestamp("session_stop");
                    String traffics = this.getSessionTraffics(tc, rs);
                    element.setAttribute("session_start", TimeUtils.formatFullDate((Date)session_start));
                    element.setAttribute("session_stop", TimeUtils.formatFullDate((Date)session_stop));
                    element.setAttribute("session_time", Utils.formatSessionTime((int)rs.getInt("session_time")));
                    element.setAttribute("session_cost", Utils.formatSessionCost((float)rs.getFloat("session_cost")));
                    element.setAttribute("from_to", rs.getString("from_number") + " / " + rs.getString("to_number"));
                    element.setAttribute("traffics", traffics);
                    element.setAttribute("ipaddr", IPUtils.convertLongIpToString((long)rs.getLong("ipaddr")));
                    element.setAttribute("f0", TimeUtils.formatFullDate((Date)session_start));
                    element.setAttribute("f1", TimeUtils.formatFullDate((Date)session_stop));
                    element.setAttribute("f2", Utils.formatSessionTime((int)rs.getInt("session_time")));
                    element.setAttribute("f3", Utils.formatSessionCost((float)rs.getFloat("session_cost")));
                    element.setAttribute("f4", rs.getString("from_number") + " / " + rs.getString("to_number"));
                    element.setAttribute("f5", traffics);
                    StringTokenizer st = new StringTokenizer(traffics, "/");
                    while (st.hasMoreTokens()) {
                        Element traffic = data.getOwnerDocument().createElement("traffic");
                        traffic.appendChild(data.getOwnerDocument().createTextNode(st.nextToken().trim()));
                        element.appendChild(traffic);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addLoginsAmounts(Period period, int cid, Element data, String module, String filter) throws SQLException {
        List logins = this.loginManager.getContractLogins(cid);
        int timeAmount = 0;
        int sessionsCol = 0;
        float moneyAmount = 0.0f;
        TrafficShowConfig tc = new TrafficShowConfig(this.moduleSetup.get("traffics", null));
        int trafCount = tc.getMode() == 1 ? 2 : tc.getServiceCodes().size();
        BigDecimal[] trafficSums = new BigDecimal[trafCount];
        for (int i = 0; i < trafCount; ++i) {
            trafficSums[i] = BigDecimal.ZERO;
        }
        for (Login login : logins) {
            ArrayList<Integer> lids = new ArrayList<Integer>(1);
            lids.add(login.getId());
            List<Object> sums = this.getSessionsColSumTimeTraffics(lids, period);
            int col = (Integer)sums.get(0);
            float cost = ((Float)sums.get(1)).floatValue();
            int time = (Integer)sums.get(2);
            timeAmount += time;
            moneyAmount += cost;
            sessionsCol += col;
            Element row = data.getOwnerDocument().createElement("row");
            data.appendChild(row);
            row.setAttribute("f0", login.getLogin() + this.loginManager.getLoginAliases(login.getId()));
            row.setAttribute("f1", String.valueOf(col));
            row.setAttribute("f2", Utils.formatSessionTime((int)time));
            row.setAttribute("f3", Utils.formatCost((float)cost));
            List traffics = (List)sums.get(3);
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < traffics.size() && k < trafficSums.length; ++k) {
                BigDecimal traffic = (BigDecimal)traffics.get(k);
                trafficSums[k] = trafficSums[k].add(traffic);
                Element trafficEl = data.getOwnerDocument().createElement("traffic");
                trafficEl.appendChild(data.getOwnerDocument().createTextNode(String.valueOf(traffic)));
                row.appendChild(trafficEl);
                if (sb.length() > 0) {
                    sb.append(" / ");
                }
                sb.append(traffic);
            }
            row.setAttribute("f4", sb.toString());
        }
        data.setAttribute("time_amount", Utils.formatSessionTime((int)timeAmount));
        data.setAttribute("count_amount", String.valueOf(sessionsCol));
        data.setAttribute("money_amount", Utils.formatCost((float)moneyAmount));
        StringBuffer traffics = new StringBuffer();
        for (int i = 0; i < trafficSums.length; ++i) {
            if (traffics.length() != 0) {
                traffics.append(" / ");
            }
            traffics.append(trafficSums[i]);
            Element trafficEl = data.getOwnerDocument().createElement("traffic");
            trafficEl.appendChild(data.getOwnerDocument().createTextNode(String.valueOf(trafficSums[i])));
            data.appendChild(trafficEl);
        }
        data.setAttribute("traffics", traffics.toString());
        String trafficTitles = tc.getTrafficTitles();
        data.setAttribute("traffics_title", trafficTitles);
        StringTokenizer st = new StringTokenizer(trafficTitles, "/");
        while (st.hasMoreTokens()) {
            Element traffic = data.getOwnerDocument().createElement("traffic_title");
            traffic.setAttribute("title", st.nextToken().trim());
            data.appendChild(traffic);
        }
    }

    public void addLoginsAmounts(Period period, int cid, Map<String, Object> dataMap, String module, String filter) throws SQLException {
        List logins = this.loginManager.getContractLogins(cid);
        int timeAmount = 0;
        int sessionsCol = 0;
        float moneyAmount = 0.0f;
        TrafficShowConfig tc = new TrafficShowConfig(this.moduleSetup.get("traffics", null));
        int trafCount = tc.getMode() == 1 ? 2 : tc.getServiceCodes().size();
        BigDecimal[] trafficSums = new BigDecimal[trafCount];
        for (int i = 0; i < trafCount; ++i) {
            trafficSums[i] = BigDecimal.ZERO;
        }
        ArrayList<String[]> rowList = new ArrayList<String[]>();
        for (Login login : logins) {
            String[] str = new String[5];
            ArrayList<Integer> lids = new ArrayList<Integer>(1);
            lids.add(login.getId());
            List<Object> sums = this.getSessionsColSumTimeTraffics(lids, period);
            int col = (Integer)sums.get(0);
            float cost = ((Float)sums.get(1)).floatValue();
            int time = (Integer)sums.get(2);
            timeAmount += time;
            moneyAmount += cost;
            sessionsCol += col;
            str[0] = login.getLogin() + this.loginManager.getLoginAliases(login.getId());
            str[1] = String.valueOf(col);
            str[2] = Utils.formatSessionTime((int)time);
            str[3] = Utils.formatCost((float)cost);
            List traffics = (List)sums.get(3);
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < traffics.size() && k < trafficSums.length; ++k) {
                BigDecimal traffic = (BigDecimal)traffics.get(k);
                trafficSums[k] = trafficSums[k].add(traffic);
                sb.append(traffic);
                sb.append(" / ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 3);
            }
            str[4] = sb.toString();
            rowList.add(str);
        }
        dataMap.put("rowList", rowList);
        dataMap.put("time_amount", Utils.formatSessionTime((int)timeAmount));
        dataMap.put("count_amount", String.valueOf(sessionsCol));
        dataMap.put("money_amount", Utils.formatCost((float)moneyAmount));
        StringBuffer traffics = new StringBuffer();
        ArrayList<String[]> trafficList = new ArrayList<String[]>();
        for (int i = 0; i < trafficSums.length; ++i) {
            String[] str = new String[1];
            if (traffics.length() != 0) {
                traffics.append(" / ");
            }
            traffics.append(trafficSums[i]);
            str[0] = String.valueOf(trafficSums[i]);
            trafficList.add(str);
        }
        dataMap.put("trafficList", trafficList);
        dataMap.put("traffics", traffics.toString());
        String trafficTitles = tc.getTrafficTitles();
        dataMap.put("traffics_title", trafficTitles);
        StringTokenizer st = new StringTokenizer(trafficTitles, "/");
        ArrayList<String> trafficTitleList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String title = st.nextToken().trim();
            trafficTitleList.add(title);
        }
        dataMap.put("trafficTitleList", trafficTitleList);
    }

    private String getSessionTraffics(TrafficShowConfig tc, ResultSet rs) throws Exception {
        StringBuilder result = new StringBuilder();
        String log_session = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)rs.getTimestamp("session_start"), (int)this.mid);
        String session_detail = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)rs.getTimestamp("session_start"), (int)this.mid);
        BigDecimal divisor = new BigDecimal(this.unit);
        if (tc.getMode() == 1 || !ServerUtils.tableExists((Connection)this.con, (String)session_detail)) {
            BigDecimal traffic = Utils.parseBigDecimal((String)rs.getString("input_octets"), (BigDecimal)BigDecimal.ZERO);
            traffic = traffic.divide(divisor, this.unit_scale, RoundingMode.HALF_UP);
            result.append(traffic);
            result.append(" / ");
            traffic = Utils.parseBigDecimal((String)rs.getString("output_octets"), (BigDecimal)BigDecimal.ZERO);
            traffic = traffic.divide(divisor, this.unit_scale, RoundingMode.HALF_UP);
            result.append(traffic);
        } else {
            StringBuffer query = new StringBuffer("SELECT SUM(t2.amount) FROM ");
            query.append(log_session);
            query.append(" AS t1 LEFT JOIN ");
            query.append(session_detail);
            query.append(" AS t2 ON t1.id=t2.session_id WHERE t1.id=");
            query.append(rs.getInt("id"));
            query.append(" AND t2.sid=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            for (Integer sid : tc.getServiceCodes()) {
                ps.setInt(1, sid);
                long value = 0L;
                ResultSet rsSum = ps.executeQuery();
                if (rsSum.next()) {
                    value = rsSum.getLong(1);
                }
                rsSum.close();
                if (result.length() != 0) {
                    result.append(" / ");
                }
                BigDecimal traffic = new BigDecimal(value);
                traffic = traffic.divide(divisor, this.unit_scale, RoundingMode.HALF_UP);
                result.append(traffic);
            }
            ps.close();
        }
        return result.toString();
    }

    public int addSums(Element data, List<Integer> lids, Period period, String filter) throws SQLException {
        int col = 0;
        TrafficShowConfig tc = new TrafficShowConfig(this.moduleSetup.get("traffics", null));
        String trafficTitles = tc.getTrafficTitles();
        data.setAttribute("traffics_title", trafficTitles);
        StringTokenizer st = new StringTokenizer(trafficTitles, "/");
        while (st.hasMoreTokens()) {
            Element traffic = data.getOwnerDocument().createElement("traffic_title");
            traffic.setAttribute("title", st.nextToken().trim());
            data.appendChild(traffic);
        }
        List<Object> sums = this.getSessionsColSumTimeTraffics(lids, period);
        if (sums.size() == 4) {
            col = (Integer)sums.get(0);
            data.setAttribute("count_amount", String.valueOf(col));
            float sum = ((Float)sums.get(1)).floatValue();
            int time = (Integer)sums.get(2);
            data.setAttribute("time_amount", Utils.formatSessionTime((int)time));
            data.setAttribute("money_amount", Utils.formatCost((float)sum));
            List traffics = (List)sums.get(3);
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < traffics.size(); ++index) {
                BigDecimal tr = (BigDecimal)traffics.get(index);
                Element traffic = data.getOwnerDocument().createElement("traffic");
                traffic.appendChild(data.getOwnerDocument().createTextNode(String.valueOf(tr)));
                data.appendChild(traffic);
                sb.append(tr);
                sb.append(" / ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 3);
            }
            data.setAttribute("traffics", sb.toString());
        }
        return col;
    }

    public List<Object> getSessionsColSumTimeTraffics(List<Integer> lids, Period period) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(4);
        ArrayList<BigDecimal> traffics = new ArrayList<BigDecimal>();
        Calendar fromCalendar = period.getDateFromCalendar();
        int year = fromCalendar.get(1);
        int month = fromCalendar.get(2) + 1;
        String session_detail = this.getSessionDetailTableName(year, month);
        String log_session = this.getSessionTableName(year, month);
        if (!ServerUtils.tableExists((Connection)this.con, (String)log_session) || lids.size() <= 0) {
            result.add(0);
            result.add(Float.valueOf(0.0f));
            result.add(0);
            result.add(traffics);
        } else {
            TrafficShowConfig tc = new TrafficShowConfig(this.moduleSetup.get("traffics", null));
            List colSumTimeRadinRadout = this.getSessionsColSumTimeTinTout(lids, period, null);
            result.add(colSumTimeRadinRadout.get(0));
            result.add(colSumTimeRadinRadout.get(1));
            result.add(colSumTimeRadinRadout.get(2));
            BigDecimal radin = (BigDecimal)colSumTimeRadinRadout.get(3);
            BigDecimal radout = (BigDecimal)colSumTimeRadinRadout.get(4);
            if (tc.getMode() == 1 || !ServerUtils.tableExists((Connection)this.con, (String)session_detail)) {
                traffics.add(radin);
                traffics.add(radout);
                result.add(traffics);
            } else {
                boolean roundBeforeSumm = this.moduleSetup.getBoolean("report.round.before.sum", true);
                StringBuffer query = new StringBuffer();
                if (roundBeforeSumm) {
                    query.append("SELECT t2.sid, ROUND(t2.amount/");
                    query.append(this.unit);
                    query.append(",");
                    query.append(this.unit_scale);
                    query.append(" ) FROM ");
                } else {
                    query.append("SELECT t2.sid, t2.amount FROM ");
                }
                query.append(log_session);
                query.append(" AS t1 LEFT JOIN ");
                query.append(session_detail);
                query.append(" AS t2 ON t1.id=t2.session_id WHERE t1.lid IN (");
                query.append(Utils.toString(lids));
                query.append(") AND DAYOFMONTH(t1.session_start)>=");
                query.append(period.getDateFromCalendar().get(5));
                query.append(" AND DAYOFMONTH(t1.session_start)<=");
                query.append(period.getDateToCalendar().get(5));
                HashMap<Integer, BigDecimal> traffs = new HashMap<Integer, BigDecimal>();
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal amount;
                    int sid = rs.getInt(1);
                    BigDecimal tr = (BigDecimal)traffs.get(sid);
                    if (tr == null) {
                        tr = BigDecimal.ZERO;
                    }
                    tr = tr.add((amount = rs.getBigDecimal(2)) != null ? amount : BigDecimal.ZERO);
                    traffs.put(sid, tr);
                }
                rs.close();
                ps.close();
                BigDecimal divisor = new BigDecimal(this.unit);
                for (int sid : tc.getServiceCodes()) {
                    BigDecimal sum = BigDecimal.ZERO;
                    if (traffs.containsKey(sid)) {
                        sum = (BigDecimal)traffs.get(sid);
                    }
                    if (!roundBeforeSumm) {
                        sum = sum.divide(divisor, this.unit_scale, RoundingMode.HALF_UP);
                    }
                    traffics.add(sum);
                }
                result.add(traffics);
            }
        }
        return result;
    }

    private String getSessionDetailTableName(int year, int month) {
        StringBuilder sb = new StringBuilder("session_detail_");
        sb.append(this.mid + "_");
        sb.append(year);
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month);
        return sb.toString();
    }

    public void addSessions(Element sessions, List<Integer> lids, Period period, boolean break_on_pages, Page page, String columns, String filter) {
        super.addSessions(sessions, lids, period, break_on_pages, page, columns, filter);
        TrafficShowConfig tc = new TrafficShowConfig(this.moduleSetup.get("traffics", null));
        sessions.setAttribute("traffics_title", tc.getTrafficTitles());
    }
}

