/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.EmailServiceActivator;
import ru.bitel.bgbilling.modules.email.server.bean.LDAPDriver;
import ru.bitel.common.ParameterMap;

public class LdapEmailServiceActivator
extends EmailServiceActivator {
    private Domain domain;
    private LDAPDriver driver;

    public LdapEmailServiceActivator(Domain domain, ParameterMap moduleSetup) throws BGException {
        this.domain = domain;
        ParameterMap params = this.domain.getParameterMap().inherit(moduleSetup).sub("sa.ldap.");
        String driverClass = params.get("class", null);
        try {
            this.driver = (LDAPDriver)Class.forName(driverClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.driver.init(this.domain, params);
        }
        catch (Exception e) {
            throw new BGException("LDAP driver not init: " + driverClass, (Throwable)e);
        }
    }

    @Override
    protected void createImpl(Account account) throws BGException {
        this.checkLDAPResult(this.driver.addAccount(account));
    }

    @Override
    protected void modifyImpl(Account account) throws BGException {
        this.checkLDAPResult(this.driver.updateAccount(account));
    }

    @Override
    protected void cancelImpl(Account account) throws BGException {
        this.checkLDAPResult(this.driver.deleteAccount(account));
    }

    protected void checkLDAPResult(int status_code) throws BGException {
        switch (status_code) {
            case 0: {
                return;
            }
            case 1: {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 LDAP \u0431\u0430\u0437\u043e\u0439!");
            }
            case 2: {
                throw new BGMessageException("E-Mail \u0437\u0430\u043d\u044f\u0442!");
            }
            case 3: {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
            }
            case 4: {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 LDAP!");
            }
            case 5: {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f LDAP!");
            }
        }
        throw new BGMessageException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f LDAP \u043e\u0448\u0438\u0431\u043a\u0430!");
    }

    @Override
    protected void removeDomainImpl(Domain domain) throws BGException {
    }

    @Override
    protected void updateDomainImpl(Domain domain) throws BGException {
    }
}

