/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.WiFiThread;
import ru.bitel.bgbilling.kernel.wifi.common.IpInfo;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.bgbilling.kernel.wifi.server.util.RadiusUtil;
import ru.bitel.bgbilling.kernel.wifi.server.util.ScriptUtil;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Pair;

public class WiFiManager
extends Thread {
    private static Logger log = LogManager.getLogger();
    private DatagramSocket socket = null;
    private ThreadPoolExecutor pool;
    private Map<Integer, IpInfo> ipHash = new ConcurrentHashMap<Integer, IpInfo>();
    private RadiusUtil radiusUtil = null;
    private ScriptUtil scriptUtil = null;
    private long radiusLiveTime;
    private long clientLiveTime;
    private String secret = null;
    private GlobalConfig cfg = null;

    public void init(int port) {
        this.cfg = GlobalConfig.getGlobalConfig();
        try {
            this.socket = new DatagramSocket(port);
            this.pool = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.radiusUtil = new RadiusUtil();
            this.scriptUtil = new ScriptUtil();
            this.scriptUtil.runInitScript();
            Setup setup = GlobalConfig.getGlobalConfig().getSetup();
            this.radiusLiveTime = setup.getLong("wifi.agent.radius.live.time", 60000L);
            this.clientLiveTime = setup.getLong("wifi.agent.client.live.time", 2400000L);
            this.secret = new String(this.cfg.getSecret(), "ISO-8859-1");
        }
        catch (Exception e) {
            log.error("error init WiFiManager", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[4096];
                    DatagramPacket inPacket = new DatagramPacket(buf, buf.length);
                    this.socket.receive(inPacket);
                    log.info("manager: packet recieved");
                    WiFiThread thread = new WiFiThread(this);
                    thread.init(inPacket.getAddress().getHostAddress(), inPacket.getPort(), inPacket.getData(), this.socket, this.secret);
                    while (this.pool.getMaximumPoolSize() == this.pool.getActiveCount()) {
                        Thread.sleep(200L);
                        log.warn("Wating for free Thread..");
                    }
                    this.pool.execute(thread);
                }
            }
            catch (Exception e) {
                log.error("error WiFiManager thread", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public boolean isIpAlive(int ip, boolean checkRadius) {
        long limit;
        boolean result = false;
        IpInfo info = this.ipHash.get(ip);
        if (info == null) {
            return result;
        }
        Long date = info.getDate();
        Date currDate = new Date();
        log.info("alive check (ip={}, checkRadius={})...", (Object)WiFiUtil.getIp(ip), (Object)checkRadius);
        long l = limit = checkRadius ? this.radiusLiveTime : this.clientLiveTime;
        if (date != null) {
            log.info("alive: " + (currDate.getTime() - date) + ";limit=" + limit + ";checkRadius=" + checkRadius);
        }
        if (date != null && currDate.getTime() - date < limit) {
            result = true;
        }
        log.info("alive: " + result);
        return result;
    }

    public void updateLiveInfo(Map<String, Pair<Long, Long>> ipCountMap) {
        long currentDate = new Date().getTime();
        for (Map.Entry<String, Pair<Long, Long>> entry : ipCountMap.entrySet()) {
            int intIp;
            IpInfo info;
            String ip = entry.getKey();
            Pair<Long, Long> counts = entry.getValue();
            long inputBytes = (Long)counts.getFirst();
            long outputBytes = (Long)counts.getSecond();
            if (inputBytes <= 0L && outputBytes <= 0L || (info = this.ipHash.get(intIp = WiFiUtil.getIp(ip))) == null || inputBytes <= info.getInputBytes() && outputBytes <= info.getOutputBytes()) continue;
            info.setDate(currentDate);
            info.setInputBytes(inputBytes);
            info.setOutputBytes(outputBytes);
        }
        for (Map.Entry<Object, Object> entry : this.ipHash.entrySet()) {
            if (currentDate - ((IpInfo)entry.getValue()).getDate() <= this.clientLiveTime) continue;
            this.kill(((IpInfo)entry.getValue()).getIp());
        }
        if (this.cfg.isClearChain()) {
            for (String string : ipCountMap.keySet()) {
                int intIp = WiFiUtil.getIp(string);
                IpInfo info = this.ipHash.get(intIp);
                if (info != null) continue;
                log.debug(" deleting unknown ip from iptables:");
                this.scriptUtil.runStopScript(WiFiUtil.getIp(intIp));
            }
        }
    }

    public Map<Integer, IpInfo> getIpHash() {
        return this.ipHash;
    }

    public RadiusUtil getRadiusUtil() {
        return this.radiusUtil;
    }

    public void setRadiusUtil(RadiusUtil radiusUtil) {
        this.radiusUtil = radiusUtil;
    }

    public void kill(int ip) {
        String ipStr = WiFiUtil.getIp(ip);
        long startTime = 0L;
        IpInfo info = this.ipHash.get(ip);
        if (this.ipHash.get(ip) == null) {
            log.info("trying to kill " + ipStr + "- it doesn't exists!!!");
            return;
        }
        startTime = this.ipHash.get(ip).getStartDate();
        this.ipHash.remove(ip);
        log.info("delete permission: " + ipStr);
        this.scriptUtil.runStopScript(ipStr);
        this.radiusUtil.sendStopPacket(info.getLogin(), ipStr, startTime, info.getAcctSessionId());
    }

    public void add(IpInfo info) {
        this.ipHash.put(info.getIp(), info);
        String ipStr = WiFiUtil.getIp(info.getIp());
        this.radiusUtil.sendStartPacket(info.getLogin(), ipStr, info.getAcctSessionId());
    }

    public void halt() {
        for (Map.Entry<Integer, IpInfo> entry : this.ipHash.entrySet()) {
            this.kill(entry.getValue().getIp());
        }
    }

    public IpInfo getInfo(int ip) {
        return this.ipHash.get(ip);
    }

    public ScriptUtil getScriptUtil() {
        return this.scriptUtil;
    }
}

