/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.client.tariff;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public class ZoneCostRangeTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"service_cost_range");
    private static Icon addIcon = ClientUtils.getIcon((String)"item_add");
    private static Icon deleteIcon = ClientUtils.getIcon((String)"item_delete");
    private JLabel view = new JLabel();
    private Directory zonesDir;
    private JPanel editorsContainer = new JPanel(new GridBagLayout());
    private List<Editor> editorList = new ArrayList<Editor>();
    private JPanel editor = new JPanel(new GridBagLayout());
    public static final int OUTGOING_CALL = 1;
    public static final int INCOMING_CALL = 2;
    private IntTextField toTf;
    private BGComboBox<ComboBoxItem> modeCb;
    private BGComboBox<ComboBoxItem> typeCombo;
    private String to;
    private int modeId;
    private int type;
    private List<Integer> zones;
    protected boolean TYPE_COMBO = true;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.zonesDir = this.getDirManager().getDirectory("zones");
        this.view.setIcon(icon);
        this.makeEditor();
    }

    protected boolean canEmpty() {
        return false;
    }

    private void makeEditor() {
        BGButtonPanelOkCancel yesNoPane = new BGButtonPanelOkCancel();
        yesNoPane.addActionListener(e -> {
            String command = e.getActionCommand();
            if (command != null) {
                if (command.equals("ok")) {
                    this.serializeData();
                    this.saveData();
                    this.tree.updateTree();
                    this.tree.getViewableTree().stopEditing();
                } else if (command.equals("cancel")) {
                    this.loadData();
                    this.tree.getViewableTree().stopEditing();
                }
            }
        });
        JScrollPane editorsScroll = new JScrollPane(this.editorsContainer);
        editorsScroll.setMinimumSize(new Dimension(380, 200));
        editorsScroll.setPreferredSize(new Dimension(380, 200));
        editorsScroll.setHorizontalScrollBarPolicy(31);
        this.editor.add((Component)this.getRangePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u0417\u043e\u043d\u044b: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editor.add((Component)editorsScroll, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editor.add((Component)yesNoPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected JPanel getRangePanel() {
        JPanel editor = new JPanel();
        editor.add(new JLabel("\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e "));
        this.toTf = new IntTextField();
        this.toTf.setColumns(5);
        this.toTf.setMinValue(0L);
        editor.add((Component)this.toTf);
        editor.add(new JLabel(" \u0440\u0443\u0431./\u043c\u0435\u0441\u044f\u0446 "));
        if (this.TYPE_COMBO) {
            this.typeCombo = new BGComboBox();
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"0", ZoneCostRangeTariffTreeNode.getTypeTitle(0)));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"1", ZoneCostRangeTariffTreeNode.getTypeTitle(1)));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"2", ZoneCostRangeTariffTreeNode.getTypeTitle(2)));
            editor.add((Component)this.typeCombo);
        }
        this.modeCb = new BGComboBox();
        this.modeCb.addItem((Object)new ComboBoxItem((Object)"0", ZoneCostRangeTariffTreeNode.getModeTitle(0)));
        this.modeCb.addItem((Object)new ComboBoxItem((Object)"1", ZoneCostRangeTariffTreeNode.getModeTitle(1)));
        editor.add((Component)this.modeCb);
        return editor;
    }

    protected JPanel getEditorPanel() {
        return this.editor;
    }

    public Component getEditor() {
        return this.editor;
    }

    public Component getView() throws Exception {
        this.extractData();
        StringBuffer sb = new StringBuffer("<html>");
        sb.append("\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e ");
        sb.append(this.to);
        sb.append(" \u0440\u0443\u0431./\u043c\u0435\u0441\u044f\u0446 \u0434\u043b\u044f \u0437\u043e\u043d: ");
        if (this.zonesDir != null) {
            for (int sid : this.zones) {
                String title = this.getValue(sid);
                sb.append("<br>-\t");
                sb.append(title);
            }
        }
        if (this.TYPE_COMBO) {
            sb.append(" (");
            sb.append(ZoneCostRangeTariffTreeNode.getTypeTitle(this.type));
            sb.append(") ");
        }
        sb.append(ZoneCostRangeTariffTreeNode.getModeTitle(this.modeId));
        this.view.setText(sb.toString());
        return this.view;
    }

    protected String getValue(int sid) throws Exception {
        return this.zonesDir.getValue(sid);
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.zones = Utils.toIntegerList((String)((String)data.get("zones")));
        this.to = Utils.maskNull((String)((String)data.get("to")));
        this.modeId = Utils.parseInt((String)((String)data.get("mode")));
        if (this.TYPE_COMBO) {
            this.type = Utils.parseInt((String)((String)data.get("type")));
        }
    }

    protected void loadData() {
        this.editorList.clear();
        this.editorsContainer.removeAll();
        this.extractData();
        int pos = 0;
        for (int sid : this.zones) {
            Editor editor = new Editor(pos++);
            editor.setService(sid);
            this.addEditor(editor);
        }
        if (this.zones.size() == 0) {
            Editor editor = new Editor(0);
            this.addEditor(editor);
        }
        ClientUtils.setComboBoxSelection(this.modeCb, (Object)String.valueOf(this.modeId));
        if (this.TYPE_COMBO) {
            ClientUtils.setComboBoxSelection(this.typeCombo, (Object)String.valueOf(this.type));
        }
        this.toTf.setText(this.to);
    }

    protected void serializeData() {
        this.zones = new ArrayList<Integer>();
        for (Editor editor : this.editorList) {
            this.zones.add(editor.getService());
        }
        if (this.canEmpty() && this.zones.size() == 1 && this.zones.contains(-1)) {
            this.zones.clear();
        }
        this.to = this.toTf.getText();
        this.modeId = Utils.parseInt((String)ClientUtils.getIdFromComboBox(this.modeCb));
        if (this.TYPE_COMBO) {
            this.type = Utils.parseInt((String)ClientUtils.getIdFromComboBox(this.typeCombo));
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("zones", Utils.toString(this.zones));
        data.put("to", this.to);
        data.put("mode", String.valueOf(this.modeId));
        if (this.TYPE_COMBO) {
            data.put("type", String.valueOf(this.type));
        }
        this.setDataInHash(data);
    }

    private void addEditor(Editor editor) {
        this.editorList.add(editor);
        this.editorsContainer.add((Component)editor.getPanel(), new GridBagConstraints(0, editor.getPos(), 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.updateUI();
    }

    private static final String getModeTitle(int mode) {
        String result = "\u0431\u0435\u0437\u0443\u0441\u043b\u043e\u0432\u043d\u043e";
        if (mode == 0) {
            result = "\u043f\u0440\u043e\u043f. \u043f\u0435\u0440\u0438\u043e\u0434\u0443";
        }
        return result;
    }

    private static final String getTypeTitle(int type) {
        if (type == 1) {
            return "\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439";
        }
        if (type == 2) {
            return "\u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0439";
        }
        return "\u043e\u0431\u0449\u0438\u0439";
    }

    public void serializeToXML(Element el) throws Exception {
        super.serializeToXML(el);
        el.setAttribute("to", this.to);
        el.setAttribute("zones", Utils.toString(this.zones));
        el.setAttribute("mode", String.valueOf(this.modeId));
        if (this.TYPE_COMBO) {
            el.setAttribute("type", String.valueOf(this.type));
        }
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("to", el.getAttribute("to"));
        data.put("zones", el.getAttribute("zones"));
        data.put("mode", el.getAttribute("mode"));
        data.put("type", el.getAttribute("type"));
        this.setDataInHash(data);
        this.saveData();
        this.loadChildsFromXML(el);
    }

    private class Editor
    implements ActionListener {
        private JPanel panel = new JPanel();
        private BGComboBox<IdTitle> serviceCombo = new BGComboBox();
        private int pos;

        public Editor(int pos) {
            this.pos = pos;
            this.serviceCombo.setMaximumSize(new Dimension(300, 24));
            this.serviceCombo.setPreferredSize(new Dimension(300, 24));
            JButton addButton = new JButton(addIcon);
            addButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
            addButton.setActionCommand("add");
            addButton.setMargin(new Insets(2, 2, 2, 2));
            JButton deleteButton = new JButton(deleteIcon);
            deleteButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
            deleteButton.setActionCommand("delete");
            deleteButton.setMargin(new Insets(2, 2, 2, 2));
            this.panel.add((Component)this.serviceCombo);
            this.panel.add(addButton);
            this.panel.add(deleteButton);
            addButton.addActionListener(this);
            deleteButton.addActionListener(this);
            try {
                ZoneCostRangeTariffTreeNode.this.buildDirectoryCombo(ZoneCostRangeTariffTreeNode.this.zonesDir, this.serviceCombo);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public int getPos() {
            return this.pos;
        }

        public void setService(int sid) {
            ZoneCostRangeTariffTreeNode.this.setDirectoryItemSelection(this.serviceCombo, sid);
        }

        public int getService() {
            return ZoneCostRangeTariffTreeNode.this.getIdFromDirectoryCombo(this.serviceCombo);
        }

        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("add")) {
                int pos = 0;
                int size = ZoneCostRangeTariffTreeNode.this.editorList.size();
                if (size > 0) {
                    Editor lastEditor = ZoneCostRangeTariffTreeNode.this.editorList.get(size - 1);
                    pos = lastEditor.getPos() + 1;
                }
                Editor editor = new Editor(pos);
                ZoneCostRangeTariffTreeNode.this.addEditor(editor);
            } else if (ZoneCostRangeTariffTreeNode.this.editorList.size() <= 1 && !ZoneCostRangeTariffTreeNode.this.canEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
            } else {
                ZoneCostRangeTariffTreeNode.this.editorList.remove(this);
                ZoneCostRangeTariffTreeNode.this.editorsContainer.remove(this.getPanel());
                ZoneCostRangeTariffTreeNode.this.editor.updateUI();
            }
        }
    }
}

