/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.SerializeContract;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusContractProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.server.bean.OperationBonusProgram;
import ru.bitel.bgbilling.plugins.bonus.server.dao.BonusDao;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Period;

public class PluginServerListener
extends WebMenuBase
implements OnInitServer,
OnDestroyServer,
SerializeContract,
EventListener<Event> {
    int cid;

    public void notify(Event event, EventListenerContext ctx) throws Exception {
        block13: {
            ContractWrapEvent contractWrapEvent;
            BonusDao bonusDao;
            block16: {
                block15: {
                    Connection con;
                    block14: {
                        BigDecimal sum;
                        block12: {
                            Document doc;
                            Element bonus;
                            con = ctx.getConnection();
                            bonusDao = new BonusDao(con);
                            this.cid = event.getContractId();
                            if (!(event instanceof ContractCreateEvent)) break block12;
                            ContractCreateEvent crEvent = (ContractCreateEvent)event;
                            if (crEvent.isCheck() || (bonus = XMLUtils.selectElement((Node)(doc = crEvent.getPattern().getData()), (String)"data/plugins/bonus")) == null) break block13;
                            bonusDao.updatePluginInclude(this.cid, Utils.parseBoolean((String)bonus.getAttribute("include")));
                            Element addBonusProgram = XMLUtils.selectElement((Node)doc, (String)"data/plugins/bonus/addBonusProgram");
                            if (addBonusProgram != null) {
                                for (Element item : XMLUtils.selectElements((Node)addBonusProgram, (String)"program")) {
                                    BonusProgram program = bonusDao.getProgram(Utils.parseInt((String)item.getAttribute("programId")));
                                    if (program == null || program.getPeriod().getDateTo() != null && program.getPeriod().getDateTo().compareTo(new Date()) <= 0) continue;
                                    bonusDao.updateProgramContract(new BonusContractProgram(this.cid, program, new Period(new Date(), null)));
                                }
                            }
                            break block13;
                        }
                        if (!(event instanceof PaymentEvent) && !(event instanceof ChargeEvent)) break block14;
                        boolean isPaymentEvent = event instanceof PaymentEvent;
                        int typeIdChargeOrPayment = isPaymentEvent ? ((PaymentEvent)event).getPayment().getTypeId() : ((ChargeEvent)event).getCharge().getTypeId();
                        BigDecimal bigDecimal = sum = isPaymentEvent ? ((PaymentEvent)event).getPayment().getSum() : ((ChargeEvent)event).getCharge().getSum();
                        if (this.cid <= 0 || !bonusDao.pluginInclude(this.cid) || !bonusDao.checkContractOnProgramType(this.cid, 1, new Date())) break block13;
                        List<BonusContractProgram> bonusPrograms = bonusDao.getProgramCotractList(this.cid, 1, new Date());
                        for (BonusContractProgram contractProgram : bonusPrograms) {
                            int typeOperation;
                            BonusProgram program = contractProgram.getProgram();
                            int accrualPeriod = Utils.parseInt((String)((String)program.getParams().get("accrualPeriod")), (int)-1);
                            if (accrualPeriod != 4 || ((typeOperation = Utils.parseInt((String)((String)program.getParams().get("typeOperation")), (int)-1)) != 1 || !isPaymentEvent) && (typeOperation != 2 || isPaymentEvent)) continue;
                            Set typeSet = program.getParams().get("operationTypeId") != null ? Utils.toIntegerSet((String)((String)program.getParams().get("operationTypeId"))) : null;
                            BigDecimal minSum = Utils.parseBigDecimal((String)((String)program.getParams().get("minSumOperation")), (BigDecimal)BigDecimal.ZERO);
                            if (typeSet != null && !typeSet.contains(typeIdChargeOrPayment) || sum.compareTo(minSum) <= -1) continue;
                            OperationBonusProgram operationBonusProgram = new OperationBonusProgram();
                            Period period = operationBonusProgram.getPeriodForBonusPayment(program);
                            BigDecimal bonusSum = operationBonusProgram.getBonusSumAccrual(program, sum);
                            if (bonusSum.compareTo(BigDecimal.ZERO) != 1) continue;
                            BonusPayment bonusPayment = new BonusPayment(0, program.getPaymentTypeId(), new Date(), bonusSum, period.getDateFrom(), period.getDateTo());
                            bonusDao.updatePayment(0, this.cid, bonusPayment);
                        }
                        break block13;
                    }
                    if (!(event instanceof ContractDeleteEvent)) break block15;
                    ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
                    if (!cdEvent.isCheck()) {
                        bonusDao.updatePluginInclude(this.cid, false);
                        try {
                            PreparedStatement ps = con.prepareStatement("DELETE FROM bonus_contract_program WHERE cid=?");
                            ps.setInt(1, this.cid);
                            ps.executeUpdate();
                            ps.close();
                            ps = con.prepareStatement("DELETE FROM bonus_contract_payment WHERE cid=?");
                            ps.setInt(1, this.cid);
                            ps.executeUpdate();
                            ps.close();
                            ps = con.prepareStatement("DELETE FROM bonus_contract_charge WHERE cid=?");
                            ps.setInt(1, this.cid);
                            ps.executeUpdate();
                            ps.close();
                        }
                        catch (SQLException e) {
                            throw new BGException((Throwable)e);
                        }
                    }
                    break block13;
                }
                if (!(event instanceof ContractCloseEvent)) break block16;
                ContractCloseEvent ccEvent = (ContractCloseEvent)event;
                if (ccEvent.isCheck()) break block13;
                this.getLogger().debug("Close bonus programs period for contract " + this.cid);
                List<BonusContractProgram> bonusContractProgramList = bonusDao.getProgramCotractList(ccEvent.getContractId(), 0, ccEvent.getDate());
                for (BonusContractProgram bonusContractProgram : bonusContractProgramList) {
                    Period period = bonusContractProgram.getPeriod();
                    if (period == null) {
                        period = new Period();
                    }
                    period.setDateTo(ccEvent.getDate());
                    bonusDao.updateProgramContract(bonusContractProgram);
                }
                break block13;
            }
            if (event instanceof ContractWrapEvent && !(contractWrapEvent = (ContractWrapEvent)event).isCheck()) {
                this.getLogger().debug("Wrap bonus plugin state and programs from contract #" + this.cid + " to contract #" + contractWrapEvent.getToContractId());
                if (bonusDao.pluginInclude(contractWrapEvent.getContractId())) {
                    bonusDao.updatePluginInclude(contractWrapEvent.getToContractId(), true);
                }
                List<BonusContractProgram> oldBonusContractProgramList = bonusDao.getProgramCotractList(contractWrapEvent.getContractId(), 0, contractWrapEvent.getDateOpen());
                for (BonusContractProgram oldBonusContractProgram : oldBonusContractProgramList) {
                    Period period = oldBonusContractProgram.getPeriod();
                    if (period == null) {
                        period = new Period();
                    }
                    Period newPeriod = new Period(contractWrapEvent.getDateOpen(), period.getDateTo());
                    period.setDateTo(contractWrapEvent.getDateClose());
                    bonusDao.updateProgramContract(oldBonusContractProgram);
                    BonusContractProgram newBonusContractProgram = new BonusContractProgram();
                    newBonusContractProgram.setProgram(oldBonusContractProgram.getProgram());
                    newBonusContractProgram.setContractId(contractWrapEvent.getToContractId());
                    newBonusContractProgram.setPeriod(newPeriod);
                    bonusDao.updateProgramContract(newBonusContractProgram);
                }
            }
        }
    }

    public void onInitServer(String applicationName) {
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().addListener((EventListener)this, PaymentEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, ChargeEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, ContractCreateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, ContractDeleteEvent.class, 0, null);
            EventProcessor.getInstance().addListener((EventListener)this, ContractWrapEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, ContractCloseEvent.class);
        }
        catch (BGException e) {
            this.getLogger().error("error add event listener", (Throwable)e);
        }
    }

    public void onDestroyServer(String applicationName) {
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().removeListener((EventListener)this);
        }
        catch (BGException e) {
            this.getLogger().error("error remove event listener", (Throwable)e);
        }
    }

    public void serializeContract(Connection con, int cid, XMLStreamWriter writer, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(cid);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_include", (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_program", (String)"cid", (String)cidStr, null, (boolean)onlyCurrent, (String)"dateFrom", (String)"dateTo");
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_payment", (String)"cid", (String)cidStr, null, (boolean)onlyCurrent, (String)"dateFrom", (String)"dateTo");
        if (onlyCurrent) {
            Calendar cal = Calendar.getInstance();
            cal.add(2, -1);
            Date dateFrom = TimeUtils.getStartMonth((Date)cal.getTime());
            String joins = " RIGHT JOIN bonus_contract_charge AS bcc ON bonus_contract_charge.id=bcc.id AND bcc.date>= '" + TimeUtils.formatSQLDate((Date)dateFrom) + "'";
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_charge", (String)"bonus_contract_charge.cid", (String)cidStr, null, (boolean)false, null, null, (String)joins);
        } else {
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"bonus_contract_charge", (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        }
    }

    public List<MenuItem> getContractWebMenuItems(Connection con, String module, int moduleId, int contractId) throws Exception {
        HashSet<Integer> disableIds = new HashSet<Integer>();
        try {
            if (!new BonusDao(con).pluginInclude(contractId)) {
                disableIds.add(1);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return this.disableContractWebMenuItems(this.getWebMenuItems(con, module, moduleId), disableIds);
    }
}

