/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server.servlet;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.modules.paymaster.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paymaster.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.paymaster.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.PeriodWithTime;

@WebServlet(name="PayMasterApi", urlPatterns={"/paymaster/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected static final String RESPONSE_NO = "NO";
    protected static final String RESPONSE_YES = "YES";
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(ModuleExecutor.class);

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int moduleId = 0;
        try {
            moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
        }
        catch (BGMessageException ex) {
            this.logError((Exception)((Object)ex));
            this.doResponse(response, RESPONSE_NO);
            return;
        }
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        if (moduleSetup == null) {
            this.getLogger().error("moduleSetup = null");
            this.doResponse(response, RESPONSE_NO);
            return;
        }
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            Transaction transaction = null;
            String paymentNo = request.getParameter("LMI_PAYMENT_NO");
            String searchMode = request.getParameter("search_mode");
            if ("contract".equals(searchMode)) {
                Contract contract = this.getContract(paymentNo, con);
                if (contract == null) {
                    this.getLogger().error("Contract == null!");
                    this.doResponse(response, RESPONSE_NO);
                    return;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("contractId = {}", (Object)contract.getId());
                }
                transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contract.getId())).setCreateDate(new Date())).build();
            } else {
                transaction = this.getTransaction(request.getParameter("LMI_PAYMENT_NO"), moduleId, con);
                if (transaction == null) {
                    this.getLogger().error("Transaction == null!");
                    this.doResponse(response, RESPONSE_NO);
                    return;
                }
            }
            String mode = request.getParameter("LMI_PREREQUEST");
            if (mode == null) {
                mode = "0";
            }
            int contractId = transaction.getContractId();
            int paymentTypeId = moduleSetup.getInt("paymaster.payment.type.id", -1);
            if ("0".equals(mode) && this.checkHash(request, moduleSetup)) {
                this.checkAutopaymentToken(request.getParameter("LMI_TOKEN_CODE"), contractId, moduleId, moduleSetup, con);
                if (transaction.getPaymentId() < 1) {
                    Payment payment = null;
                    TransactionManager transactionManager = new TransactionManager(con, moduleId);
                    String transactionId = request.getParameter("LMI_SYS_PAYMENT_ID");
                    String comment = moduleSetup.get("paymaster.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 Paymaster");
                    payment = transactionManager.addPayment(transaction.getId() > 0 ? String.valueOf(transaction.getId()) : transactionId, contractId, paymentTypeId, new BigDecimal(request.getParameter("LMI_PAYMENT_AMOUNT")), comment);
                    StringBuilder data = new StringBuilder();
                    Enumeration enumeration = request.getParameterNames();
                    while (enumeration.hasMoreElements()) {
                        this.addParameter(data, request, (String)enumeration.nextElement());
                    }
                    transaction.setTransactionId(transactionId);
                    transaction.setTransactionDate(TimeUtils.parseDate((String)request.getParameter("LMI_SYS_PAYMENT_DATE"), (String)"yyyy-MM-dd'T'HH:mm:ss"));
                    transaction.setSum(payment.getSum());
                    transaction.setPaymentId(payment.getId());
                    transaction.setSysPaymentData(data.toString());
                    transaction.setStatus(TransactionStatus.PAY.getCode());
                    transactionManager.update(transaction);
                }
                this.doResponse(response, "OK");
            } else if ("1".equals(mode) || "2".equals(mode)) {
                this.doResponse(response, this.invoiceConfirmation(con, moduleId, contractId, paymentTypeId));
            } else {
                response.sendError(500, "Request parameter error!");
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
    }

    protected Transaction getTransaction(String paymentNo, int moduleId, Connection con) throws SQLException {
        Transaction transaction = null;
        int transactionId = Utils.parseInt((String)paymentNo, (int)-1);
        if (transactionId > 0) {
            transaction = (Transaction)new TransactionManager(con, moduleId).get(transactionId);
        }
        return transaction;
    }

    protected Contract getContract(String contractTitle, Connection con) {
        Contract contract;
        ContractDao contractDao = new ContractDao(con, 0);
        try {
            contract = contractDao.getByTitle(contractTitle);
        }
        catch (Throwable throwable) {
            try {
                try {
                    contractDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException e) {
                e.printStackTrace();
                return null;
            }
        }
        contractDao.close();
        return contract;
    }

    private void checkAutopaymentToken(String tokenCode, int contractId, int moduleId, ModuleSetup moduleSetup, Connection con) {
        if (tokenCode != null) {
            String clientId = moduleSetup.get("paymaster.merchant.id", "");
            Map<String, String> tokenData = TransactionManager.getToken(moduleSetup.get("paymaster.direct.token.url", "https://paymaster.ru/direct/security/token"), tokenCode, clientId, moduleSetup.get("paymaster.direct.redirect.uri", ""), moduleSetup.get("paymaster.direct.secret", ""));
            if (tokenData != null) {
                try {
                    AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                    Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                    PeriodWithTime period = autopayment.getPeriod();
                    if (period != null && period.getDateFrom() == null) {
                        period.setLocalDateTimeFrom(LocalDateTime.now());
                    }
                    autopayment.setAccessToken(tokenData.get("access_token"));
                    autopayment.setData(autopayment.getData() + "\nexpires_in=" + tokenData.get("expires_in") + "\naccount_identifier=" + tokenData.get("account_identifier"));
                    autopaymentManager.update(autopayment);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
    }

    protected void doResponse(HttpServletResponse response, String responseText) throws IOException {
        response.setContentType("text/plain;charset=UTF-8");
        response.getWriter().print(responseText);
        response.flushBuffer();
    }

    protected String invoiceConfirmation(Connection con, int moduleId, int contractId, int paymentTypeId) {
        String responseText = RESPONSE_NO;
        try {
            Contract contract = null;
            try (ContractDao contractDao = new ContractDao(con, 0);){
                contract = (Contract)contractDao.get(contractId);
            }
            if (contract != null && new ContractModuleManager(con).getContractModuleSet(contract.getId()).contains(moduleId) && TimeUtils.dateInRange((Date)new Date(), (Date)contract.getDateFrom(), (Date)contract.getDateTo()) && !contract.isHidden() && paymentTypeId > 0) {
                responseText = RESPONSE_YES;
            } else {
                this.getLogger().error("Contract = " + contract);
                if (contract != null) {
                    this.getLogger().error("Contract period = " + contract.getDateFrom() + " - " + contract.getDateTo() + " [" + new Date() + "]");
                    this.getLogger().error("Contract modules ids = " + Utils.toString((Iterable)new ContractModuleManager(con).getContractModuleSet(contract.getId())) + " [moduleId=" + moduleId + "]");
                    this.getLogger().error("PaymentTypeId = " + paymentTypeId);
                }
            }
        }
        catch (BGException ex) {
            this.logError((Exception)((Object)ex));
        }
        return responseText;
    }

    protected boolean checkHash(HttpServletRequest request, ModuleSetup moduleSetup) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getParameter(request, "LMI_MERCHANT_ID"));
        buf.append(this.getParameter(request, "LMI_PAYMENT_NO"));
        buf.append(this.getParameter(request, "LMI_SYS_PAYMENT_ID"));
        buf.append(this.getParameter(request, "LMI_SYS_PAYMENT_DATE"));
        buf.append(this.getParameter(request, "LMI_PAYMENT_AMOUNT"));
        buf.append(this.getParameter(request, "LMI_CURRENCY"));
        buf.append(this.getParameter(request, "LMI_PAID_AMOUNT"));
        buf.append(this.getParameter(request, "LMI_PAID_CURRENCY"));
        buf.append(this.getParameter(request, "LMI_PAYMENT_SYSTEM"));
        buf.append(this.getParameter(request, "LMI_SIM_MODE"));
        buf.append(moduleSetup.get("paymaster.secret"));
        boolean result = false;
        try {
            MessageDigest digest = MessageDigest.getInstance(moduleSetup.get("paymaster.digest.type", "SHA-256"));
            digest.update(buf.toString().getBytes(StandardCharsets.UTF_8));
            String checkHash = new String(Base64.encode((byte[])digest.digest())).concat(";");
            result = checkHash.equals(this.getParameter(request, "LMI_HASH"));
            if (!result) {
                this.getLogger().error("hash_str = " + buf.toString());
                this.getLogger().error("hash_calc = " + checkHash);
                this.getLogger().error("hash_query = " + this.getParameter(request, "LMI_HASH"));
            }
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    protected String getParameter(HttpServletRequest request, String parameterName) {
        String result = request.getParameter(parameterName);
        return result != null ? result.concat(";") : ";";
    }

    protected void addParameter(StringBuilder data, HttpServletRequest request, String parameterName) {
        data.append(parameterName);
        data.append("=");
        data.append(request.getParameter(parameterName));
        data.append("\n");
    }
}

