/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTask;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.bean.event.RegisterTaskClosedEvent;
import ru.bitel.bgbilling.plugins.crm.server.bean.event.RegisterTaskUpdateEvent;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterTaskManager;
import ru.bitel.common.Utils;

public class ActionUpdateRegisterTask
extends ActionBase {
    public void doAction() throws Exception {
        String checkResult;
        Date targetDate;
        int id = this.getIntParameter("id", -1);
        int status = this.getIntParameter("status", 0);
        Date now = new Date();
        RegisterTask task = null;
        boolean closeEvent = false;
        RegisterTaskManager manager = new RegisterTaskManager(this.con);
        int problemIdNew = this.getIntParameter("problemId", 0);
        int problemIdOld = -1;
        if (id < 1) {
            task = new RegisterTask();
            task.setId(-1);
            task.setContractId(this.cid);
            task.setOpenUserId(this.userId.intValue());
            task.setOpenTime(now);
        } else {
            task = manager.getTaskById(id);
            problemIdOld = task.getProblemId();
        }
        if (problemIdNew != problemIdOld) {
            task.setProblemId(problemIdNew);
        }
        if (task.getStatus() != status) {
            switch (status) {
                case 0: {
                    task.setOpenUserId(this.userId.intValue());
                    task.setOpenTime(now);
                    task.setAcceptUserId(-10);
                    task.setAcceptTime((Date)null);
                    task.setCloseUserId(-10);
                    task.setCloseTime((Date)null);
                    break;
                }
                case 1: {
                    task.setAcceptUserId(this.userId.intValue());
                    task.setAcceptTime(now);
                    task.setCloseUserId(-10);
                    task.setCloseTime((Date)null);
                    break;
                }
                case 2: {
                    task.setCloseUserId(this.userId.intValue());
                    task.setCloseTime(now);
                    closeEvent = true;
                }
            }
        }
        if ((targetDate = this.getDateParameter("target_date_and_time", "dd.MM.yyyy HH:mm", null)) == null) {
            targetDate = this.getDateParameter("target_date");
        }
        task.setTargetDate(targetDate);
        task.setExecuteDate(this.getDateParameter("execute_date"));
        if (task.getStatus() != status && (status == 2 ? (checkResult = this.checkCloseDates(now, task)) != null : status == 1 && (checkResult = this.checkAcceptDates(now, task)) != null)) {
            throw new BGMessageException(checkResult);
        }
        task.setLastmodUserId(this.userId.intValue());
        task.setLastmodTime(now);
        task.setAddressParamId(this.getIntParameter("apid", 0));
        task.setAddressObjectId(this.getIntParameter("aObjectId", 0));
        task.setStatus(status);
        task.setExecutors(Utils.toIntegerList((String)this.getParameter("executors")));
        task.setGroupId(this.getIntParameter("group", 0));
        task.setComment(this.getParameter("comment", ""));
        task.setResolution(this.getParameter("resolution", ""));
        task.setTypeId(this.getIntParameter("type", 0));
        task.setProblemId(this.getIntParameter("problemId", 0));
        manager.updateTask(task, this.userId);
        manager.updateExecutorList(task);
        RegisterProblemManager rpManager = new RegisterProblemManager(this.con);
        RegisterProblem rp = null;
        List taskList = null;
        if (problemIdNew != problemIdOld) {
            if (problemIdOld > 0) {
                rp = rpManager.getProblemByID(problemIdOld);
                taskList = rp.getTasks();
                for (String str : taskList) {
                    if (Integer.valueOf(str).intValue() != task.getId()) continue;
                    taskList.remove(str);
                    break;
                }
                rp.setTasks(taskList);
                rpManager.updateProblem(rp, this.userId);
            }
            if (problemIdNew > 0) {
                rp = rpManager.getProblemByID(problemIdNew);
                taskList = rp.getTasks();
                taskList.add(String.valueOf(task.getId()));
                rp.setTasks(taskList);
                rpManager.updateProblem(rp, this.userId);
            }
        }
        if (closeEvent) {
            EventProcessor.getInstance().request((QueueEvent)new RegisterTaskClosedEvent(this.plugin.getPluginUID(), task, this.userId));
        } else {
            EventProcessor.getInstance().request((QueueEvent)new RegisterTaskUpdateEvent(this.plugin.getPluginUID(), task, this.userId));
        }
        if (task != null && this.getParameter("send.mail") != null) {
            this.sendRegisterEmail(task, this.getSubject(task));
        }
        Element problem = this.createElement(this.rootNode, "task");
        problem.setAttribute("id", String.valueOf(task.getId()));
    }

    private String getSubject(RegisterTask task) {
        String pattern = this.plugin.getSetup().get("register.task.mail.subject", this.setup.get("register.task.mail.subject", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0437\u0430\u0434\u0430\u0447\u0435"));
        try {
            RegisterGroup group;
            if (pattern.indexOf("${group}") >= 0 && (group = new RegisterGroupManager(this.con).getGroupById(task.getGroupId())) != null) {
                pattern = pattern.replaceAll("\\$\\{group\\}", group.getTitle());
            }
            if (pattern.indexOf("${type}") >= 0) {
                pattern = pattern.replaceAll("\\$\\{type\\}", this.getTaskType(task.getTypeId()));
            }
            if (pattern.indexOf("${id}") >= 0) {
                pattern = pattern.replaceAll("\\$\\{id\\}", String.valueOf(task.getId()));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return pattern;
    }

    protected void sendRegisterEmail(RegisterTask task, String subject) throws Exception {
        RegisterGroup group = new RegisterGroupManager(this.con).getGroupById(task.getGroupId());
        if (group == null || !Utils.notEmptyString((String)group.getEmail())) {
            throw new BGMessageException("\u0423 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435\u0442 \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430!");
        }
        this.createRegisterReport(task, group, "crm_register_task.xsl", group.getEmail(), subject);
    }
}

